/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

abstract class ProjectFileNameBasedKey
extends ProjectNameBasedKey {
    protected static final CharSequence NO_PROJECT = CharSequences.create((CharSequence)"<No Project Name>");
    protected final int fileNameIndex;

    protected ProjectFileNameBasedKey(CharSequence prjName, CharSequence fileName) {
        super(prjName);
        assert (fileName != null);
        this.fileNameIndex = KeyUtilities.getFileIdByName(this.getUnitId(), fileName);
    }

    protected ProjectFileNameBasedKey(FileImpl file) {
        this(ProjectFileNameBasedKey.getProjectName(file), file.getAbsolutePath());
    }

    protected ProjectFileNameBasedKey(KeyDataPresentation presentation) {
        super(presentation);
        this.fileNameIndex = presentation.getFilePresentation();
    }

    protected static CharSequence getProjectName(FileImpl file) {
        assert (file != null);
        ProjectBase prj = file.getProjectImpl(true);
        assert (prj != null);
        return prj == null ? NO_PROJECT : prj.getUniqueName();
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        aStream.writeInt(this.fileNameIndex);
    }

    protected ProjectFileNameBasedKey(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        this.fileNameIndex = aStream.readInt();
    }

    @Override
    public int hashCode() {
        int key = super.hashCode();
        key = 19 * key + this.fileNameIndex;
        return key;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ProjectFileNameBasedKey other = (ProjectFileNameBasedKey)obj;
        return this.fileNameIndex == other.fileNameIndex;
    }

    int getProjectFileIndex() {
        return this.fileNameIndex;
    }

    protected CharSequence getFileName() {
        return KeyUtilities.getFileNameById(this.getUnitId(), this.fileNameIndex);
    }

    protected CharSequence getFileNameSafe() {
        return KeyUtilities.getFileNameByIdSafe(this.getUnitId(), this.fileNameIndex);
    }

    @Override
    public int getDepth() {
        assert (super.getDepth() == 0);
        return 1;
    }

    @Override
    public CharSequence getAt(int level) {
        assert (super.getDepth() == 0 && level < this.getDepth());
        return this.getFileName();
    }

    @Override
    public final int getFilePresentation() {
        return this.fileNameIndex;
    }
}

