/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.modelimpl.csm.ExpressionBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NestedType;
import org.netbeans.modules.cnd.modelimpl.csm.NoType;
import org.netbeans.modules.cnd.modelimpl.csm.ParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFunPtrImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.deep.CompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.EmptyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyTryCatchStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.fsm.DummyParametersListImpl;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class PersistentUtils {
    private static final int UTF_LIMIT = 65535;
    private static final String NULL_STRING = new String(new char[]{'\u0000'});
    private static final int FIRST_INDEX = 102;
    private static final int VISIBILITY_PUBLIC = 102;
    private static final int VISIBILITY_PROTECTED = 103;
    private static final int VISIBILITY_PRIVATE = 104;
    private static final int VISIBILITY_NONE = 105;
    private static final int EXPRESSION_BASE = 106;
    private static final int FILE_BUFFER_FILE = 107;
    private static final int NO_TYPE = 108;
    private static final int TYPE_IMPL = 109;
    private static final int NESTED_TYPE = 110;
    private static final int TYPE_FUN_PTR_IMPL = 111;
    private static final int TEMPLATE_PARAM_TYPE = 112;
    private static final int PREPROC_STATE_STATE_IMPL = 113;
    private static final int LAZY_COMPOUND_STATEMENT_IMPL = 114;
    private static final int LAZY_TRY_CATCH_STATEMENT_IMPL = 115;
    private static final int EMPTY_COMPOUND_STATEMENT_IMPL = 116;
    private static final int COMPOUND_STATEMENT_IMPL = 117;
    private static final int PARAM_LIST_IMPL = 118;
    private static final int FUN_PARAM_LIST_IMPL = 119;
    private static final int FUN_KR_PARAM_LIST_IMPL = 120;
    private static final int DUMMY_PARAMS_LIST_IMPL = 121;
    private static final int TEMPLATE_DESCRIPTOR_IMPL = 122;
    private static final int SPECIALIZATION_DESCRIPTOR_IMPL = 123;
    private static final int SPECIALIZATION_PARAMETERS_LIST = 124;
    private static final int TYPE_BASED_SPECIALIZATION_PARAMETER_IMPL = 125;
    private static final int EXPRESSION_BASED_SPECIALIZATION_PARAMETER_IMPL = 126;
    public static final int LAST_INDEX = 126;

    public static FileSystem readFileSystem(RepositoryDataInput input) throws IOException {
        CharSequence rootUrl = PersistentUtils.readUTF(input, FilePathCache.getManager());
        FileObject rootFileObject = CndFileUtils.urlToFileObject((CharSequence)rootUrl);
        assert (rootFileObject != null) : "Restored null file object for URL " + rootUrl;
        return rootFileObject.getFileSystem();
    }

    public static void writeFileSystem(FileSystem fs, RepositoryDataOutput output) throws IOException {
        CharSequence rootUrl = CharSequences.create((CharSequence)CndFileUtils.fileObjectToUrl((FileObject)fs.getRoot()));
        PersistentUtils.writeUTF(rootUrl, output);
    }

    public static void readErrorDirectives(Set<ErrorDirectiveImpl> errors, RepositoryDataInput input) throws IOException {
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            ErrorDirectiveImpl offs = new ErrorDirectiveImpl(input);
            errors.add(offs);
        }
    }

    public static void writeErrorDirectives(Set<ErrorDirectiveImpl> errors, RepositoryDataOutput output) throws IOException {
        int size = errors.size();
        output.writeInt(size);
        for (ErrorDirectiveImpl error : errors) {
            error.write(output);
        }
    }

    private PersistentUtils() {
    }

    public static void writeParameterList(CsmParameterList<?> params, RepositoryDataOutput output) throws IOException {
        if (params == null) {
            output.writeInt(-1);
        } else if (params instanceof ParameterListImpl) {
            int handler = 118;
            if (params instanceof FunctionParameterListImpl) {
                handler = 119;
                if (params instanceof FunctionParameterListImpl.FunctionKnRParameterListImpl) {
                    handler = 120;
                }
            }
            if (params instanceof DummyParametersListImpl) {
                handler = 121;
            }
            output.writeInt(handler);
            ((ParameterListImpl)params).write(output);
        }
    }

    public static CsmParameterList<?> readParameterList(RepositoryDataInput input) throws IOException {
        ParameterListImpl paramList;
        int handler = input.readInt();
        switch (handler) {
            case -1: {
                paramList = null;
                break;
            }
            case 118: {
                paramList = new ParameterListImpl(input);
                break;
            }
            case 119: {
                paramList = new FunctionParameterListImpl(input);
                break;
            }
            case 120: {
                paramList = new FunctionParameterListImpl.FunctionKnRParameterListImpl(input);
                break;
            }
            case 121: {
                paramList = new DummyParametersListImpl(input);
                break;
            }
            default: {
                assert (false) : "unexpected param list implementation " + handler;
                paramList = null;
            }
        }
        return paramList;
    }

    public static void writeBuffer(FileBuffer buffer, RepositoryDataOutput output) throws IOException {
        assert (buffer != null);
        if (!(buffer instanceof AbstractFileBuffer)) {
            throw new IllegalArgumentException("instance of unknown FileBuffer " + buffer);
        }
        output.writeInt(107);
        ((AbstractFileBuffer)buffer).write(output);
    }

    public static FileBuffer readBuffer(RepositoryDataInput input) throws IOException {
        int handler = input.readInt();
        assert (handler == 107);
        FileBufferFile buffer = new FileBufferFile(input);
        return buffer;
    }

    public static void writeStrings(CharSequence[] arr, RepositoryDataOutput output) throws IOException {
        if (arr == null) {
            output.writeInt(-1);
        } else {
            int len = arr.length;
            output.writeInt(len);
            for (int i = 0; i < len; ++i) {
                assert (arr[i] != null);
                PersistentUtils.writeUTF(arr[i], output);
            }
        }
    }

    public static void writeCollectionStrings(Collection<CharSequence> arr, RepositoryDataOutput output) throws IOException {
        if (arr == null) {
            output.writeInt(-1);
        } else {
            int len = arr.size();
            output.writeInt(len);
            for (CharSequence s : arr) {
                assert (s != null);
                PersistentUtils.writeUTF(s, output);
            }
        }
    }

    public static CharSequence[] readStrings(RepositoryDataInput input, APTStringManager manager) throws IOException {
        CharSequence[] arr = null;
        int len = input.readInt();
        if (len != -1) {
            arr = new CharSequence[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = manager.getString(PersistentUtils.readUTF(input, manager));
            }
        }
        return arr;
    }

    public static Collection<CharSequence> readCollectionStrings(RepositoryDataInput input, APTStringManager manager) throws IOException {
        ArrayList<CharSequence> arr = null;
        int len = input.readInt();
        if (len != -1) {
            arr = new ArrayList<CharSequence>(len);
            for (int i = 0; i < len; ++i) {
                arr.add(PersistentUtils.readUTF(input, manager));
            }
        }
        return arr;
    }

    public static void writeUTF(CharSequence st, RepositoryDataOutput aStream) throws IOException {
        if (st == null) {
            aStream.writeUTF(NULL_STRING);
        } else {
            assert (CharSequences.isCompact((CharSequence)st));
            aStream.writeCharSequenceUTF(st);
        }
    }

    public static CharSequence readUTF(RepositoryDataInput aStream, APTStringManager manager) throws IOException {
        CharSequence s = aStream.readCharSequenceUTF();
        if (s.length() == 1 && s.charAt(0) == '\u0000') {
            return null;
        }
        CharSequence res = manager.getString(s);
        assert (CharSequences.isCompact((CharSequence)res));
        return res;
    }

    public static void writeExpression(CsmExpression expr, RepositoryDataOutput output) throws IOException {
        if (expr == null) {
            output.writeInt(-1);
        } else if (expr instanceof ExpressionBase) {
            output.writeInt(106);
            ((ExpressionBase)expr).write(output);
        } else {
            throw new IllegalArgumentException("instance of unknown CsmExpression " + expr);
        }
    }

    public static CsmExpression readExpression(RepositoryDataInput input) throws IOException {
        ExpressionBase expr;
        int handler = input.readInt();
        if (handler == -1) {
            expr = null;
        } else {
            assert (handler == 106);
            expr = new ExpressionBase(input);
        }
        return expr;
    }

    public static void writeExpressions(Collection<CsmExpression> exprs, RepositoryDataOutput output) throws IOException {
        if (exprs == null) {
            output.writeInt(-1);
        } else {
            int collSize = exprs.size();
            output.writeInt(collSize);
            for (CsmExpression expr : exprs) {
                assert (expr != null);
                PersistentUtils.writeExpression(expr, output);
            }
        }
    }

    public static <T extends Collection<CsmExpression>> T readExpressions(T collection, RepositoryDataInput input) throws IOException {
        int collSize = input.readInt();
        if (collSize != -1) {
            for (int i = 0; i < collSize; ++i) {
                CsmExpression expr = PersistentUtils.readExpression(input);
                assert (expr != null);
                collection.add((CsmExpression)expr);
            }
            return collection;
        }
        collection = null;
        return collection;
    }

    public static void writeExpressionKind(CsmExpression.Kind kind, RepositoryDataOutput output) throws IOException {
        if (kind != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        output.writeInt(-1);
    }

    public static CsmExpression.Kind readExpressionKind(RepositoryDataInput input) throws IOException {
        int handler = input.readInt();
        if (handler != -1) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        CsmExpression.Kind kind = null;
        return kind;
    }

    public static CsmType readType(RepositoryDataInput stream) throws IOException {
        Object obj;
        int handler = stream.readInt();
        switch (handler) {
            case -1: {
                obj = null;
                break;
            }
            case 108: {
                obj = NoType.instance();
                break;
            }
            case 109: {
                obj = new TypeImpl(stream);
                break;
            }
            case 110: {
                obj = new NestedType(stream);
                break;
            }
            case 111: {
                obj = new TypeFunPtrImpl(stream);
                break;
            }
            case 112: {
                obj = new TemplateParameterTypeImpl(stream);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type handler" + handler);
            }
        }
        return obj;
    }

    public static void writeType(CsmType type, RepositoryDataOutput stream) throws IOException {
        if (type == null) {
            stream.writeInt(-1);
        } else if (type instanceof NoType) {
            stream.writeInt(108);
        } else if (type instanceof TypeImpl) {
            if (type instanceof TypeFunPtrImpl) {
                stream.writeInt(111);
                ((TypeFunPtrImpl)type).write(stream);
            } else if (type instanceof NestedType) {
                stream.writeInt(110);
                ((NestedType)type).write(stream);
            } else {
                stream.writeInt(109);
                ((TypeImpl)type).write(stream);
            }
        } else if (type instanceof TemplateParameterTypeImpl) {
            stream.writeInt(112);
            ((TemplateParameterTypeImpl)type).write(stream);
        } else {
            throw new IllegalArgumentException("instance of unknown class " + type.getClass().getName());
        }
    }

    public static boolean isPersistable(CsmType type) {
        if (type == null) {
            return true;
        }
        if (type instanceof NoType) {
            return true;
        }
        if (type instanceof TypeImpl) {
            return true;
        }
        return type instanceof TemplateParameterTypeImpl;
    }

    public static <T extends Collection<CsmType>> void readTypes(T collection, RepositoryDataInput input) throws IOException {
        int collSize = input.readInt();
        assert (collSize >= 0);
        for (int i = 0; i < collSize; ++i) {
            CsmType type = PersistentUtils.readType(input);
            assert (type != null);
            collection.add((CsmType)type);
        }
    }

    public static void writeTypes(Collection<? extends CsmType> types, RepositoryDataOutput output) throws IOException {
        assert (types != null);
        int collSize = types.size();
        output.writeInt(collSize);
        for (CsmType csmType : types) {
            assert (csmType != null);
            PersistentUtils.writeType(csmType, output);
        }
    }

    public static TemplateDescriptor readTemplateDescriptor(RepositoryDataInput input) throws IOException {
        int handler = input.readInt();
        if (handler == -1) {
            return null;
        }
        assert (handler == 122);
        return new TemplateDescriptor(input);
    }

    public static void writeTemplateDescriptor(TemplateDescriptor templateDescriptor, RepositoryDataOutput output) throws IOException {
        if (templateDescriptor == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(122);
            templateDescriptor.write(output);
        }
    }

    public static SpecializationDescriptor readSpecializationDescriptor(RepositoryDataInput input) throws IOException {
        int handler = input.readInt();
        if (handler == -1) {
            return null;
        }
        assert (handler == 123);
        return new SpecializationDescriptor(input);
    }

    public static void writeSpecializationDescriptor(SpecializationDescriptor specializationDescriptor, RepositoryDataOutput output) throws IOException {
        if (specializationDescriptor == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(123);
            specializationDescriptor.write(output);
        }
    }

    public static void writeSpecializationParameters(List<CsmSpecializationParameter> params, RepositoryDataOutput output) throws IOException {
        if (params == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(124);
            output.writeInt(params.size());
            for (CsmSpecializationParameter p : params) {
                if (p instanceof TypeBasedSpecializationParameterImpl) {
                    output.writeInt(125);
                    ((TypeBasedSpecializationParameterImpl)p).write(output);
                    continue;
                }
                if (p instanceof ExpressionBasedSpecializationParameterImpl) {
                    output.writeInt(126);
                    ((ExpressionBasedSpecializationParameterImpl)p).write(output);
                    continue;
                }
                assert (false) : "unexpected instance of specialization parameter ";
            }
        }
    }

    public static List<CsmSpecializationParameter> readSpecializationParameters(RepositoryDataInput input) throws IOException {
        int handler = input.readInt();
        if (handler == -1) {
            return null;
        }
        assert (handler == 124);
        ArrayList<CsmSpecializationParameter> params = new ArrayList<CsmSpecializationParameter>();
        PersistentUtils.readSpecializationParametersList(params, input);
        return params;
    }

    public static void readSpecializationParameters(List<CsmSpecializationParameter> params, RepositoryDataInput input) throws IOException {
        int handler = input.readInt();
        if (handler == -1) {
            return;
        }
        assert (handler == 124) : "unexpected handler " + handler;
        PersistentUtils.readSpecializationParametersList(params, input);
    }

    private static void readSpecializationParametersList(List<CsmSpecializationParameter> params, RepositoryDataInput input) throws IOException {
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            int type = input.readInt();
            if (type == 125) {
                params.add((CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(input));
                continue;
            }
            if (type == 126) {
                params.add((CsmSpecializationParameter)new ExpressionBasedSpecializationParameterImpl(input));
                continue;
            }
            assert (false) : "unexpected instance of specialization parameter ";
        }
    }

    public static void writeVisibility(CsmVisibility visibility, RepositoryDataOutput output) throws IOException {
        assert (visibility != null);
        int handler = -1;
        if (visibility == CsmVisibility.PUBLIC) {
            handler = 102;
        } else if (visibility == CsmVisibility.PROTECTED) {
            handler = 103;
        } else if (visibility == CsmVisibility.PRIVATE) {
            handler = 104;
        } else if (visibility == CsmVisibility.NONE) {
            handler = 105;
        } else {
            throw new IllegalArgumentException("instance of unknown visibility " + visibility);
        }
        output.writeInt(handler);
    }

    public static CsmVisibility readVisibility(RepositoryDataInput input) throws IOException {
        CsmVisibility visibility = null;
        int handler = input.readInt();
        switch (handler) {
            case 102: {
                visibility = CsmVisibility.PUBLIC;
                break;
            }
            case 103: {
                visibility = CsmVisibility.PROTECTED;
                break;
            }
            case 104: {
                visibility = CsmVisibility.PRIVATE;
                break;
            }
            case 105: {
                visibility = CsmVisibility.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + handler);
            }
        }
        return visibility;
    }

    public static void writeCompoundStatement(CsmCompoundStatement body, RepositoryDataOutput output) throws IOException {
        assert (body != null);
        if (body instanceof LazyCompoundStatementImpl) {
            output.writeInt(114);
            ((LazyCompoundStatementImpl)body).write(output);
        } else if (body instanceof LazyTryCatchStatementImpl) {
            output.writeInt(115);
            ((LazyTryCatchStatementImpl)body).write(output);
        } else if (body instanceof EmptyCompoundStatementImpl) {
            output.writeInt(116);
            ((EmptyCompoundStatementImpl)body).write(output);
        } else if (body instanceof CompoundStatementImpl) {
            output.writeInt(117);
            ((CompoundStatementImpl)body).write(output);
        } else {
            throw new IllegalArgumentException("unknown compound statement " + body);
        }
    }

    public static CsmCompoundStatement readCompoundStatement(RepositoryDataInput input) throws IOException {
        StatementBase body;
        int handler = input.readInt();
        switch (handler) {
            case 114: {
                body = new LazyCompoundStatementImpl(input);
                break;
            }
            case 115: {
                body = new LazyTryCatchStatementImpl(input);
                break;
            }
            case 116: {
                body = new EmptyCompoundStatementImpl(input);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + handler);
            }
        }
        return body;
    }

    public static void writePreprocState(APTPreprocHandler.State state, RepositoryDataOutput output) throws IOException {
        APTPreprocHandler.State cleanedState = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        APTSerializeUtils.writePreprocState((APTPreprocHandler.State)cleanedState, (RepositoryDataOutput)output);
    }

    public static APTPreprocHandler.State readPreprocState(FileSystem fs, RepositoryDataInput input) throws IOException {
        APTPreprocHandler.State state = APTSerializeUtils.readPreprocState((FileSystem)fs, (RepositoryDataInput)input);
        assert (state.isCleaned());
        return state;
    }
}

