/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileDeclarationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileIncludesKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileInstantiationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileMacrosKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileReferencesKey;
import org.netbeans.modules.cnd.modelimpl.repository.GraphContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.IncludeKey;
import org.netbeans.modules.cnd.modelimpl.repository.InheritanceKey;
import org.netbeans.modules.cnd.modelimpl.repository.InstantiationKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyManager;
import org.netbeans.modules.cnd.modelimpl.repository.MacroKey;
import org.netbeans.modules.cnd.modelimpl.repository.NamespaceDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.NamespaceKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableDeclarationKey;
import org.netbeans.modules.cnd.modelimpl.repository.ParamListKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectSettingsValidatorKey;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class KeyObjectFactory
extends KeyFactory {
    private static final int FIRST_INDEX = 1;
    public static final int KEY_PROJECT_KEY = 1;
    public static final int KEY_NAMESPACE_KEY = 2;
    public static final int KEY_FILE_KEY = 3;
    public static final int KEY_FILE_DECLARATIONS_KEY = 4;
    public static final int KEY_FILE_MACROS_KEY = 5;
    public static final int KEY_FILE_INCLUDES_KEY = 6;
    public static final int KEY_FILE_REFERENCES_KEY = 7;
    public static final int KEY_FILE_INSTANTIATIONS_KEY = 8;
    public static final int KEY_MACRO_KEY = 9;
    public static final int KEY_INCLUDE_KEY = 10;
    public static final int KEY_INHERITANCE_KEY = 11;
    public static final int KEY_PARAM_LIST_KEY = 12;
    public static final int KEY_DECLARATION_KEY = 13;
    public static final int KEY_INSTANTIATION_KEY = 14;
    public static final int KEY_PRJ_VALIDATOR_KEY = 15;
    public static final int KEY_PROJECT_DECLARATION_CONTAINER_KEY = 16;
    public static final int KEY_FILE_CONTAINER_KEY = 17;
    public static final int KEY_GRAPH_CONTAINER_KEY = 18;
    public static final int KEY_NS_DECLARATION_CONTAINER_KEY = 19;
    public static final int KEY_CLASSIFIER_CONTAINER_KEY = 20;
    public static final int LAST_INDEX = 20;

    public void writeKey(Key aKey, RepositoryDataOutput aStream) throws IOException {
        assert (aKey instanceof SelfPersistent);
        super.writeSelfPersistent((SelfPersistent)aKey, aStream);
    }

    public Key readKey(RepositoryDataInput aStream) throws IOException {
        boolean share;
        assert (aStream != null);
        SelfPersistent out = super.readSelfPersistent(aStream);
        assert (out instanceof Key);
        boolean bl = share = !(out instanceof OffsetableDeclarationKey);
        if (share) {
            Key shared = KeyManager.instance().getSharedKey((Key)out);
            assert (shared != null);
            assert (shared instanceof SelfPersistent);
            out = (SelfPersistent)shared;
        }
        return (Key)out;
    }

    public void writeKeyCollection(Collection<Key> aCollection, RepositoryDataOutput aStream) throws IOException {
        assert (aCollection != null);
        assert (aStream != null);
        int collSize = aCollection.size();
        aStream.writeInt(collSize);
        for (Key aKey : aCollection) {
            assert (aKey != null);
            this.writeKey(aKey, aStream);
        }
    }

    public void readKeyCollection(Collection<Key> aCollection, RepositoryDataInput aStream) throws IOException {
        assert (aCollection != null);
        assert (aStream != null);
        int collSize = aStream.readInt();
        for (int i = 0; i < collSize; ++i) {
            Key aKey = this.readKey(aStream);
            assert (aKey != null);
            aCollection.add(aKey);
        }
    }

    protected int getHandler(Object object) {
        int aHandle;
        if (object instanceof ProjectKey) {
            aHandle = 1;
        } else if (object instanceof NamespaceDeclarationContainerKey) {
            aHandle = 19;
        } else if (object instanceof NamespaceKey) {
            aHandle = 2;
        } else if (object instanceof FileKey) {
            aHandle = 3;
        } else if (object instanceof FileDeclarationsKey) {
            aHandle = 4;
        } else if (object instanceof FileMacrosKey) {
            aHandle = 5;
        } else if (object instanceof FileIncludesKey) {
            aHandle = 6;
        } else if (object instanceof FileReferencesKey) {
            aHandle = 7;
        } else if (object instanceof FileInstantiationsKey) {
            aHandle = 8;
        } else if (object instanceof MacroKey) {
            aHandle = 9;
        } else if (object instanceof IncludeKey) {
            aHandle = 10;
        } else if (object instanceof InheritanceKey) {
            aHandle = 11;
        } else if (object instanceof ParamListKey) {
            aHandle = 12;
        } else if (object instanceof OffsetableDeclarationKey) {
            aHandle = 13;
        } else if (object instanceof InstantiationKey) {
            aHandle = 14;
        } else if (object instanceof ProjectSettingsValidatorKey) {
            aHandle = 15;
        } else if (object instanceof ProjectDeclarationContainerKey) {
            aHandle = 16;
        } else if (object instanceof FileContainerKey) {
            aHandle = 17;
        } else if (object instanceof GraphContainerKey) {
            aHandle = 18;
        } else if (object instanceof ClassifierContainerKey) {
            aHandle = 20;
        } else {
            throw new IllegalArgumentException("The Key is an instance of the unknown final class " + object.getClass().getName());
        }
        return aHandle;
    }

    protected SelfPersistent createObject(int handler, RepositoryDataInput aStream) throws IOException {
        ProjectNameBasedKey aKey;
        boolean share = true;
        switch (handler) {
            case 1: {
                aKey = new ProjectKey(aStream);
                break;
            }
            case 2: {
                aKey = new NamespaceKey(aStream);
                break;
            }
            case 3: {
                aKey = new FileKey(aStream);
                break;
            }
            case 4: {
                aKey = new FileDeclarationsKey(aStream);
                break;
            }
            case 5: {
                aKey = new FileMacrosKey(aStream);
                break;
            }
            case 6: {
                aKey = new FileIncludesKey(aStream);
                break;
            }
            case 7: {
                aKey = new FileReferencesKey(aStream);
                break;
            }
            case 8: {
                aKey = new FileInstantiationsKey(aStream);
                break;
            }
            case 9: {
                aKey = new MacroKey(aStream);
                break;
            }
            case 10: {
                aKey = new IncludeKey(aStream);
                break;
            }
            case 11: {
                aKey = new InheritanceKey(aStream);
                break;
            }
            case 12: {
                aKey = new ParamListKey(aStream);
                break;
            }
            case 13: {
                share = false;
                aKey = new OffsetableDeclarationKey(aStream);
                break;
            }
            case 14: {
                share = false;
                aKey = new InstantiationKey(aStream);
                break;
            }
            case 15: {
                aKey = new ProjectSettingsValidatorKey(aStream);
                break;
            }
            case 16: {
                aKey = new ProjectDeclarationContainerKey(aStream);
                break;
            }
            case 17: {
                aKey = new FileContainerKey(aStream);
                break;
            }
            case 18: {
                aKey = new GraphContainerKey(aStream);
                break;
            }
            case 19: {
                aKey = new NamespaceDeclarationContainerKey(aStream);
                break;
            }
            case 20: {
                aKey = new ClassifierContainerKey(aStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hander was provided: " + handler);
            }
        }
        if (share) {
            Key shared = KeyManager.instance().getSharedKey(aKey);
            assert (shared != null);
            assert (shared instanceof SelfPersistent);
            aKey = (SelfPersistent)shared;
        }
        return aKey;
    }
}

