/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyStatementImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.fsm.core.DataRenderer;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FortranParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.generated.FortranParser;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;

public final class ParserProviderImpl
extends CsmParserProvider {
    @Override
    protected CsmParserProvider.CsmParser create(CsmFile file) {
        if (file instanceof FileImpl) {
            if (file.getFileType() == CsmFile.FileType.SOURCE_FORTRAN_FILE) {
                return new Antrl3FortranParser((FileImpl)file);
            }
            return new Antlr2CppParser((FileImpl)file);
        }
        return null;
    }

    private static final class Antrl3FortranParser
    implements CsmParserProvider.CsmParser,
    CsmParserProvider.CsmParserResult {
        private final FileImpl file;
        private FortranParserEx parser;
        private CsmObject parserContainer;
        private FortranParser.program_return ret;
        private CsmParserProvider.CsmParser.ConstructionKind kind;

        Antrl3FortranParser(FileImpl file) {
            this.file = file;
        }

        @Override
        public void init(CsmObject object, TokenStream ts) {
            this.parser = new FortranParserEx(ts);
        }

        @Override
        public CsmParserProvider.CsmParserResult parse(CsmParserProvider.CsmParser.ConstructionKind kind) {
            try {
                this.kind = kind;
                switch (kind) {
                    case TRANSLATION_UNIT: {
                        this.ret = this.parser.program();
                        break;
                    }
                    default: {
                        assert (false) : "unexpected parse kind " + (Object)((Object)kind);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getClass().getName() + " at parsing file " + this.file.getAbsolutePath());
            }
            return this;
        }

        @Override
        public void render(Object ... context) {
            switch (this.kind) {
                case TRANSLATION_UNIT: {
                    new DataRenderer(this.file).render(this.parser.parsedObjects);
                    Antrl3FortranParser antrl3FortranParser = this;
                    antrl3FortranParser.file.incParseCount();
                    break;
                }
                default: {
                    assert (false) : "unexpected render kind " + (Object)((Object)this.kind);
                    break;
                }
            }
        }

        @Override
        public boolean isEmptyAST() {
            return this.ret == null || this.ret.getTree() == null;
        }

        @Override
        public Object getAST() {
            return this.ret == null ? null : this.ret.getTree();
        }

        @Override
        public int getErrorCount() {
            return this.parser.getNumberOfSyntaxErrors();
        }

        @Override
        public void dumpAST() {
            CommonTree tree = (CommonTree)this.ret.getTree();
            System.err.println(tree);
            System.err.println(tree.getChildren());
        }
    }

    private static final class Antlr2CppParser
    implements CsmParserProvider.CsmParser,
    CsmParserProvider.CsmParserResult {
        private final FileImpl file;
        private CPPParserEx parser;
        private final int flags;
        private CsmObject parserContainer;
        private AST ast;
        private CsmParserProvider.CsmParser.ConstructionKind kind;

        Antlr2CppParser(FileImpl file) {
            this.file = file;
            int aFlags = 8;
            if (!TraceFlags.REPORT_PARSING_ERRORS) {
                aFlags |= 4;
            }
            this.flags = aFlags;
        }

        @Override
        public void init(CsmObject object, TokenStream ts) {
            assert (this.parser == null) : "parser can not be reused " + this.parser;
            assert (object != null);
            assert (ts != null);
            this.parserContainer = object;
            this.parser = CPPParserEx.getInstance(((Object)this.file.getName()).toString(), ts, this.flags);
        }

        @Override
        public CsmParserProvider.CsmParserResult parse(CsmParserProvider.CsmParser.ConstructionKind kind) {
            try {
                this.kind = kind;
                switch (kind) {
                    case TRANSLATION_UNIT: {
                        this.parser.translation_unit();
                        break;
                    }
                    case TRY_BLOCK: {
                        this.parser.setLazyCompound(false);
                        this.parser.function_try_block(CsmKindUtilities.isConstructor((CsmObject)((CsmScopeElement)this.parserContainer).getScope()));
                        break;
                    }
                    case COMPOUND_STATEMENT: {
                        this.parser.setLazyCompound(false);
                        this.parser.compound_statement();
                        break;
                    }
                    case NAMESPACE_DEFINITION_BODY: {
                        this.parser.translation_unit();
                        break;
                    }
                    case CLASS_BODY: {
                        this.parser.fix_fake_class_members();
                        break;
                    }
                    default: {
                        assert (false) : "unexpected parse kind " + (Object)((Object)kind);
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                System.err.println(ex.getClass().getName() + " at parsing file " + this.file.getAbsolutePath());
            }
            this.ast = this.parser.getAST();
            return this;
        }

        @Override
        public void render(Object ... context) {
            switch (this.kind) {
                case TRY_BLOCK: 
                case COMPOUND_STATEMENT: {
                    List list = (List)context[0];
                    ((LazyStatementImpl)this.parserContainer).renderStatements(this.ast, list);
                    break;
                }
                case TRANSLATION_UNIT: {
                    if (this.ast == null) break;
                    new AstRenderer(this.file).render(this.ast);
                    Antlr2CppParser antlr2CppParser = this;
                    antlr2CppParser.file.incParseCount();
                    break;
                }
                case NAMESPACE_DEFINITION_BODY: {
                    FileImpl nsBodyFile = (FileImpl)context[0];
                    NamespaceDefinitionImpl nsDef = (NamespaceDefinitionImpl)context[1];
                    CsmNamespace ns = nsDef.getNamespace();
                    if (this.ast == null || !(ns instanceof NamespaceImpl)) break;
                    new AstRenderer(nsBodyFile).render(this.ast, (NamespaceImpl)ns, nsDef);
                    break;
                }
                case CLASS_BODY: {
                    FileImpl clsBodyFile = (FileImpl)context[0];
                    ClassImpl cls = (ClassImpl)context[1];
                    CsmVisibility visibility = (CsmVisibility)context[2];
                    boolean localClass = (Boolean)context[3];
                    cls.fixFakeRender(clsBodyFile, visibility, this.ast, localClass);
                    break;
                }
                default: {
                    assert (false) : "unexpected parse kind " + (Object)((Object)this.kind);
                    break;
                }
            }
        }

        @Override
        public boolean isEmptyAST() {
            return AstUtil.isEmpty(this.ast, true);
        }

        @Override
        public void dumpAST() {
            System.err.println("\n");
            System.err.print("AST: ");
            System.err.print(this.file.getAbsolutePath());
            System.err.print(' ');
            AstUtil.toStream(this.ast, System.err);
            System.err.println("\n");
        }

        @Override
        public Object getAST() {
            return this.ast;
        }

        @Override
        public int getErrorCount() {
            return this.parser.getErrorCount();
        }
    }
}

