/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public final class ReferenceRepositoryImpl
extends CsmReferenceRepository {
    private static final boolean checkFileAttainability = false;

    public Collection<CsmReference> getReferences(CsmObject target, CsmProject project, Set<CsmReferenceKind> kinds, CsmReferenceRepository.Interrupter interrupter) {
        ArrayList<CsmReference> out;
        CsmFile scopeFile;
        if (!(project instanceof ProjectBase)) {
            return Collections.emptyList();
        }
        ProjectBase basePrj = (ProjectBase)project;
        boolean unboxInstantiation = true;
        CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)target, (boolean)unboxInstantiation);
        CsmObject decl = decDef[0];
        CsmObject def = decDef[1];
        CsmScope scope = this.getDeclarationScope(decl);
        CsmFile csmFile = scopeFile = CsmKindUtilities.isOffsetable((Object)scope) ? ((CsmOffsetable)scope).getContainingFile() : null;
        if (scopeFile instanceof FileImpl) {
            out = new ArrayList<CsmReference>(10);
            CsmOffsetable offs = (CsmOffsetable)scope;
            out.addAll(this.getReferences(decl, def, (FileImpl)scopeFile, kinds, unboxInstantiation, offs.getStartOffset(), offs.getEndOffset(), interrupter));
        } else {
            Collection<FileImpl> files = basePrj.getAllFileImpls();
            out = new ArrayList(files.size() * 10);
            for (FileImpl file : files) {
                if (interrupter != null && interrupter.cancelled()) break;
                out.addAll(this.getReferences(decl, def, file, kinds, unboxInstantiation, 0, Integer.MAX_VALUE, interrupter));
            }
        }
        return out;
    }

    public Collection<CsmReference> getReferences(CsmObject target, CsmFile file, Set<CsmReferenceKind> kinds, CsmReferenceRepository.Interrupter interrupter) {
        CsmFile scopeFile;
        CsmScope scope = this.getDeclarationScope(target);
        CsmFile csmFile = scopeFile = CsmKindUtilities.isOffsetable((Object)scope) ? ((CsmOffsetable)scope).getContainingFile() : null;
        if (!(file instanceof FileImpl)) {
            return Collections.emptyList();
        }
        if (scopeFile != null && !scopeFile.equals(file)) {
            return Collections.emptyList();
        }
        boolean unboxInstantiation = true;
        CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)target, (boolean)unboxInstantiation);
        CsmObject decl = decDef[0];
        CsmObject def = decDef[1];
        int start = 0;
        int end = Integer.MAX_VALUE;
        if (CsmKindUtilities.isOffsetable((Object)scope)) {
            start = ((CsmOffsetable)scope).getStartOffset();
            end = ((CsmOffsetable)scope).getEndOffset();
        }
        return this.getReferences(decl, def, (FileImpl)file, kinds, unboxInstantiation, start, end, interrupter);
    }

    public Map<CsmObject, Collection<CsmReference>> getReferences(CsmObject[] targets, CsmProject project, Set<CsmReferenceKind> kinds, CsmReferenceRepository.Interrupter interrupter) {
        HashMap<CsmObject, Collection<CsmReference>> out = new HashMap<CsmObject, Collection<CsmReference>>(targets.length);
        for (CsmObject target : targets) {
            if (interrupter != null && interrupter.cancelled()) break;
            out.put(target, this.getReferences(target, project, kinds, interrupter));
        }
        return out;
    }

    public Collection<CsmReference> getReferences(CsmObject[] targets, CsmFile file, Set<CsmReferenceKind> kinds, CsmReferenceRepository.Interrupter interrupter) {
        AbstractCollection refs = new LinkedHashSet<CsmReference>(1024);
        for (CsmObject target : targets) {
            refs.addAll(this.getReferences(target, file, kinds, interrupter));
        }
        if (!refs.isEmpty() && targets.length > 1) {
            ArrayList<CsmReference> sortedRefs = new ArrayList<CsmReference>(refs);
            Collections.sort(sortedRefs, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference o1, CsmReference o2) {
                    return o1.getStartOffset() - o2.getStartOffset();
                }
            });
            refs = sortedRefs;
        }
        return refs;
    }

    private Collection<CsmReference> getReferences(final CsmObject targetDecl, final CsmObject targetDef, FileImpl file, final Set<CsmReferenceKind> kinds, final boolean unboxInstantiation, int startOffset, int endOffset, final CsmReferenceRepository.Interrupter interrupter) {
        assert (targetDecl != null);
        assert (file != null);
        CharSequence name = "";
        if (CsmKindUtilities.isNamedElement((CsmObject)targetDecl)) {
            name = ((CsmNamedElement)targetDecl).getName();
        } else if (CsmKindUtilities.isStatement((CsmObject)targetDecl)) {
            if (targetDecl instanceof CsmLabel) {
                name = ((CsmLabel)targetDecl).getLabel();
            } else if (targetDecl instanceof CsmGotoStatement) {
                name = ((CsmGotoStatement)targetDecl).getLabel();
            }
        }
        if (name.length() == 0) {
            if (TraceFlags.TRACE_XREF_REPOSITORY) {
                System.err.println("resolving unnamed element is not yet supported " + targetDecl);
            }
            return Collections.emptyList();
        }
        name = CharSequences.create((CharSequence)name);
        if (TraceFlags.TRACE_XREF_REPOSITORY) {
            System.err.println("resolving " + name + " in file " + file.getAbsolutePath());
        }
        if (!this.fastDetect(targetDecl, targetDef, file, name)) {
            return Collections.emptyList();
        }
        Collection<APTToken> tokens = this.getTokensToResolve(file, name, startOffset, endOffset);
        if (TraceFlags.TRACE_XREF_REPOSITORY) {
            System.err.println("collecting tokens");
        }
        ArrayList<CsmReference> refs = new ArrayList<CsmReference>(20);
        for (APTToken token : tokens) {
            if (interrupter != null && interrupter.cancelled()) break;
            CsmReference ref = CsmReferenceResolver.getDefault().findReference((CsmFile)file, token.getOffset());
            if (ref == null) continue;
            refs.add(ref);
        }
        final ArrayList<CsmReference> out = new ArrayList<CsmReference>(20);
        CsmFileReferences.ReferenceVisitor visitor = new CsmFileReferences.ReferenceVisitor(){

            public void visit(CsmReference ref) {
                if (interrupter != null && interrupter.cancelled()) {
                    return;
                }
                if (ReferenceRepositoryImpl.this.acceptReference(ref, targetDecl, targetDef, kinds, unboxInstantiation)) {
                    out.add(ref);
                }
            }
        };
        CsmFileReferences.getDefault().visit(refs, visitor);
        return out;
    }

    private boolean fastDetect(CsmObject targetDecl, CsmObject targetDef, FileImpl file, CharSequence name) {
        return name.length() != 0 && this.hasName(file, name);
    }

    private boolean hasName(FileImpl file, CharSequence name) {
        try {
            if (file.isValid() && name.length() > 0) {
                FileBuffer buffer = file.getBuffer();
                if (buffer == null) {
                    return false;
                }
                char[] charBuffer = buffer.getCharBuffer();
                char first = name.charAt(0);
                int nameLength = name.length();
                int bufLength = charBuffer.length;
                block3: for (int i = 0; i < bufLength - nameLength; ++i) {
                    char next;
                    char prev;
                    if (charBuffer[i] != first) continue;
                    for (int j = 1; j < nameLength; ++j) {
                        if (name.charAt(j) != charBuffer[i + j]) continue block3;
                    }
                    if (i > 0 && ((prev = charBuffer[i - 1]) == '_' || prev == '$' || prev == '~' || Character.isLetterOrDigit(prev)) || i + nameLength + 1 < bufLength && ((next = charBuffer[i + nameLength]) == '_' || next == '$' || Character.isLetterOrDigit(next))) continue;
                    return true;
                }
                return false;
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    private Collection<APTToken> getTokensToResolve(FileImpl file, CharSequence name, int startOffset, int endOffset) {
        TokenStream ts = this.getTokenStream(file);
        ArrayList<APTToken> tokens = new ArrayList<APTToken>(100);
        boolean destructor = false;
        if (name.charAt(0) == '~') {
            destructor = true;
            name = name.subSequence(1, name.length());
        }
        if (ts != null) {
            try {
                APTToken token = (APTToken)ts.nextToken();
                APTToken prev = null;
                while (!APTUtils.isEOF((Token)token)) {
                    int id;
                    if (token.getOffset() >= startOffset && ((id = token.getType()) == 90 || id == 454) && name.equals(token.getTextID()) && (!destructor || prev != null && prev.getType() == 45)) {
                        tokens.add(token);
                    }
                    if (token.getEndOffset() <= endOffset) {
                        prev = token;
                        token = (APTToken)ts.nextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (TokenStreamException ex) {
                APTUtils.LOG.log(Level.SEVERE, ex.getMessage());
            }
        }
        return tokens;
    }

    private TokenStream getTokenStream(FileImpl file) {
        TokenStream ts = null;
        try {
            FileBuffer buffer;
            if (file.isValid() && (buffer = file.getBuffer()) != null) {
                ts = APTTokenStreamBuilder.buildTokenStream((CharSequence)file.getAbsolutePath(), (char[])buffer.getCharBuffer(), (String)file.getFileLanguage());
            }
        }
        catch (IOException ex) {
            DiagnosticExceptoins.register(ex);
            ts = null;
        }
        if (ts == null || !file.isValid()) {
            return null;
        }
        APTPreprocHandler.State ppState = null;
        Collection<APTPreprocHandler.State> preprocStates = file.getProjectImpl(false).getPreprocStates(file);
        if (!preprocStates.isEmpty()) {
            ppState = preprocStates.iterator().next();
        }
        return file.getLanguageFilter(ppState).getFilteredStream((TokenStream)new APTCommentsFilter(ts));
    }

    private boolean acceptReference(CsmReference ref, CsmObject targetDecl, CsmObject targetDef, Set<CsmReferenceKind> kinds, boolean unboxInstantiation) {
        CsmObject referencedObj;
        assert (targetDecl != null);
        boolean accept = false;
        CsmObject csmObject = referencedObj = ref == null ? null : ref.getReferencedObject();
        if (unboxInstantiation && CsmKindUtilities.isTemplateInstantiation((CsmObject)referencedObj)) {
            referencedObj = ((CsmInstantiation)referencedObj).getTemplateDeclaration();
        }
        if (CsmReferenceSupport.sameDeclaration((CsmObject)targetDecl, (CsmObject)referencedObj) || this.checkDefinitions(targetDef, referencedObj)) {
            accept = CsmReferenceResolver.getDefault().isKindOf(ref, kinds);
        }
        return accept;
    }

    private boolean checkDefinitions(CsmObject targetDef, CsmObject referencedObj) {
        if (targetDef == null) {
            return false;
        }
        if (targetDef.equals(referencedObj)) {
            return true;
        }
        if (CsmKindUtilities.isFunction((CsmObject)referencedObj)) {
            CsmFunctionDefinition refDef = ((CsmFunction)referencedObj).getDefinition();
            return targetDef.equals(refDef);
        }
        return false;
    }

    private CsmScope getDeclarationScope(CsmObject decl) {
        assert (decl != null);
        CsmObject scopeElem = decl;
        while (CsmKindUtilities.isScopeElement((CsmObject)scopeElem)) {
            CsmScope scope = ((CsmScopeElement)scopeElem).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)scope)) {
                return (CsmFunction)scope;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)scope)) break;
            scopeElem = (CsmScopeElement)scope;
        }
        return null;
    }
}

