/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ExpressionBase
extends OffsetableBase
implements CsmExpression {
    private List<CsmExpression> operands;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;

    private ExpressionBase(AST ast, CsmFile file, CsmScope scope) {
        super(ast, file);
        if (scope != null) {
            this.setScope(scope);
        }
    }

    public static ExpressionBase create(AST ast, CsmFile file, CsmScope scope) {
        return new ExpressionBase(ast, file, scope);
    }

    public ExpressionBase(int startOffset, int endOffset, CsmFile file, CsmScope scope) {
        super(file, startOffset, endOffset);
        if (scope != null) {
            this.setScope(scope);
        }
    }

    public static ExpressionBase create(int startOffset, int endOffset, CsmFile file, CsmScope scope) {
        return new ExpressionBase(startOffset, endOffset, file, scope);
    }

    public CsmExpression.Kind getKind() {
        return null;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            CsmScope csmScope = this.scopeRef = this.scopeRef != null ? this.scopeRef : UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (scope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        }
        return scope;
    }

    protected void setScope(CsmScope scope) {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null);
        } else {
            this.scopeRef = scope;
        }
    }

    public List<CsmExpression> getOperands() {
        if (this.operands == null) {
            this.operands = new ArrayList<CsmExpression>(0);
        }
        return Collections.unmodifiableList(this.operands);
    }

    public CsmExpression getParent() {
        return null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeExpressions(this.operands, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
    }

    public ExpressionBase(RepositoryDataInput input) throws IOException {
        super(input);
        this.operands = PersistentUtils.readExpressions(new ArrayList(0), input);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }
}

