/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.openide.util.CharSequences;

public final class PersistentKey {
    private static final byte UID = 1;
    private static final byte DECLARATION = 2;
    private Object key;
    private CsmProject project;
    private byte kind;

    private PersistentKey(CsmUID id) {
        this.key = id;
        this.kind = 1;
    }

    private PersistentKey(CharSequence id, CsmProject host, byte type) {
        this.key = id;
        this.project = host;
        this.kind = type;
    }

    public static PersistentKey createKey(CsmOffsetableDeclaration decl) {
        CharSequence name = decl.getName();
        CharSequence uniq = decl.getUniqueName();
        CsmProject project = decl.getContainingFile().getProject();
        if (name.length() > 0 && CharSequences.indexOf((CharSequence)uniq, (CharSequence)"::::") < 0 && project != null) {
            return new PersistentKey(uniq, project, 2);
        }
        return new PersistentKey(UIDProviderIml.get(decl, false));
    }

    public Object getObject() {
        switch (this.kind) {
            case 1: {
                return ((CsmUID)this.key).getObject();
            }
            case 2: {
                return this.project.findDeclaration((CharSequence)this.key);
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof PersistentKey) {
            PersistentKey what = (PersistentKey)object;
            if (this.kind != what.kind) {
                return false;
            }
            switch (this.kind) {
                case 1: {
                    return this.key.equals(what.key);
                }
                case 2: {
                    if (this.project.equals(what.project)) {
                        return CharSequences.comparator().compare((CharSequence)this.key, (CharSequence)what.key) == 0;
                    }
                    return false;
                }
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        switch (this.kind) {
            case 1: {
                return this.key.hashCode();
            }
            case 2: {
                return this.project.hashCode() ^ this.key.hashCode();
            }
        }
        return super.hashCode();
    }
}

