/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.filesystems.FileObject;

public class FileBufferFile
extends AbstractFileBuffer {
    private volatile Reference<char[]> cachedArray;
    private final Object lock = new Object();
    private volatile long lastModifiedWhenCachedString;

    public FileBufferFile(FileObject fileObject) {
        super(fileObject);
    }

    @Override
    public CharSequence getText() throws IOException {
        char[] buf = this.doGetChar();
        return new MyCharSequence(buf);
    }

    @Override
    public String getText(int start, int end) {
        try {
            char[] buf = this.doGetChar();
            if (end > buf.length) {
                new IllegalArgumentException("").printStackTrace(System.err);
                end = buf.length;
            }
            return new String(buf, start, end - start);
        }
        catch (IOException e) {
            DiagnosticExceptoins.register(e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] doGetChar() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] res;
            Reference<char[]> aCachedArray = this.cachedArray;
            if (aCachedArray != null && (res = aCachedArray.get()) != null && this.lastModifiedWhenCachedString == this.lastModified()) {
                return res;
            }
            FileObject fo = this.getFileObject();
            long length = fo.getSize();
            if (length > Integer.MAX_VALUE) {
                new IllegalArgumentException("File is too large: " + fo.getPath()).printStackTrace(System.err);
            }
            if (length == 0L) {
                return new char[0];
            }
            char[] readChars = new char[(int)(++length)];
            InputStream is = this.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, this.getEncoding()));
            try {
                String line;
                int position = 0;
                while ((line = reader.readLine()) != null) {
                    for (int i = 0; i < line.length(); ++i) {
                        if (length == (long)position) {
                            char[] copyChars = new char[(int)(length *= 2L)];
                            System.arraycopy(readChars, 0, copyChars, 0, position);
                            readChars = copyChars;
                        }
                        readChars[position++] = line.charAt(i);
                    }
                    if (length == (long)position) {
                        char[] copyChars = new char[(int)(length *= 2L)];
                        System.arraycopy(readChars, 0, copyChars, 0, position);
                        readChars = copyChars;
                    }
                    readChars[position++] = 10;
                }
                if (readChars.length > position) {
                    char[] copyChars = new char[position];
                    System.arraycopy(readChars, 0, copyChars, 0, position);
                    readChars = copyChars;
                }
            }
            finally {
                reader.close();
                is.close();
            }
            this.cachedArray = MIMENames.isCppOrCOrFortran((String)fo.getMIMEType()) ? new WeakReference<char[]>(readChars) : new SoftReference<char[]>(readChars);
            this.lastModifiedWhenCachedString = this.lastModified();
            return readChars;
        }
    }

    private InputStream getInputStream() throws IOException {
        FileObject fo = this.getFileObject();
        if (fo == null || !fo.isValid()) {
            throw new FileNotFoundException("Null file object for " + this.getAbsolutePath());
        }
        InputStream is = fo.getInputStream();
        return new BufferedInputStream(is, TraceFlags.BUF_SIZE);
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public long lastModified() {
        return this.getFileObject().lastModified().getTime();
    }

    public FileBufferFile(RepositoryDataInput input) throws IOException {
        super(input);
    }

    public char[] getCharBuffer() throws IOException {
        return this.doGetChar();
    }

    static final class MyCharSequence
    implements CharSequence {
        private final char[] buf;
        private final int start;
        private final int end;

        MyCharSequence(char[] buf) {
            this(buf, 0, buf.length);
        }

        MyCharSequence(char[] buf, int start, int end) {
            this.buf = buf;
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            return this.buf[this.start + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new MyCharSequence(this.buf, this.start + start, this.start + end);
        }

        @Override
        public String toString() {
            return new String(this.buf, this.start, this.end - this.start);
        }
    }
}

