/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class DeclarationContainerProject
extends DeclarationContainer {
    private final Map<CharSequence, Set<CsmUID<CsmFriend>>> friends;
    private static final boolean TEST_DATABASE = false;
    private static final DeclarationContainerProject EMPTY = new DeclarationContainerProject(){

        @Override
        public void put() {
        }

        @Override
        public void putDeclaration(CsmOffsetableDeclaration decl) {
        }
    };

    public DeclarationContainerProject(ProjectBase project) {
        super(new ProjectDeclarationContainerKey(project.getUniqueName()), false);
        this.friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<CsmFriend>>>();
        this.put();
    }

    public DeclarationContainerProject(RepositoryDataInput input) throws IOException {
        super(input);
        int colSize = input.readInt();
        this.friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<CsmFriend>>>(colSize);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMapSet(this.friends, input, UniqueNameCache.getManager(), colSize);
    }

    private DeclarationContainerProject() {
        super(null, false);
        this.friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<CsmFriend>>>();
    }

    public static DeclarationContainerProject empty() {
        return EMPTY;
    }

    @Override
    protected void onRemoveDeclaration(CsmOffsetableDeclaration decl) {
        CsmFriend fun;
        CharSequence name;
        Set<CsmUID<CsmFriend>> set;
        if (CsmKindUtilities.isFriendClass((CsmObject)decl)) {
            CsmFriend cls = (CsmFriend)decl;
            CharSequence name2 = CharSequences.create((CharSequence)cls.getName());
            Set<CsmUID<CsmFriend>> set2 = this.friends.get(name2);
            if (set2 != null) {
                set2.remove(UIDs.get((Object)cls));
                if (set2.isEmpty()) {
                    this.friends.remove(name2);
                }
            }
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)decl) && (set = this.friends.get(name = CharSequences.create((CharSequence)((CsmFriendFunction)(fun = (CsmFriend)decl)).getSignature()))) != null) {
            set.remove(UIDs.get((Object)fun));
            if (set.isEmpty()) {
                this.friends.remove(name);
            }
        }
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration decl) {
        super.removeDeclaration(decl);
    }

    @Override
    public void putDeclaration(CsmOffsetableDeclaration decl) {
        super.putDeclaration(decl);
    }

    @Override
    public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence uniqueName) {
        Collection<CsmOffsetableDeclaration> res = super.findDeclarations(uniqueName);
        return res;
    }

    @Override
    public CsmDeclaration getDeclaration(CharSequence uniqueName) {
        CsmDeclaration res = super.getDeclaration(uniqueName);
        return res;
    }

    @Override
    protected void onPutDeclaration(CsmOffsetableDeclaration decl) {
        if (CsmKindUtilities.isFriendClass((CsmObject)decl)) {
            CsmFriend cls = (CsmFriend)decl;
            CharSequence name = CharSequences.create((CharSequence)cls.getName());
            Set<CsmUID<CsmFriend>> set = this.friends.get(name);
            if (set == null) {
                set = new HashSet<CsmUID<CsmFriend>>();
                this.friends.put(name, set);
            }
            set.add((CsmUID<CsmFriend>)UIDs.get((Object)cls));
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)decl)) {
            CsmFriend fun = (CsmFriend)decl;
            CharSequence name = CharSequences.create((CharSequence)((CsmFriendFunction)fun).getSignature());
            Set<CsmUID<CsmFriend>> set = this.friends.get(name);
            if (set == null) {
                set = new HashSet<CsmUID<CsmFriend>>();
                this.friends.put(name, set);
            }
            set.add((CsmUID<CsmFriend>)UIDs.get((Object)fun));
        }
    }

    SortedMap<CharSequence, Set<CsmUID<CsmFriend>>> testFriends() {
        return new TreeMap<CharSequence, Set<CsmUID<CsmFriend>>>(this.friends);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFriend> findFriends(CsmOffsetableDeclaration decl) {
        CharSequence name = null;
        if (CsmKindUtilities.isClass((CsmObject)decl)) {
            CsmClass cls = (CsmClass)decl;
            name = cls.getName();
        } else if (CsmKindUtilities.isFunction((CsmObject)decl)) {
            CsmFunction fun = (CsmFunction)decl;
            name = fun.getSignature();
        }
        if (name != null) {
            name = CharSequences.create((CharSequence)name);
            ArrayList<CsmUID<CsmFriend>> list = new ArrayList<CsmUID<CsmFriend>>();
            try {
                this.getLock().readLock().lock();
                Set<CsmUID<CsmFriend>> set = this.friends.get(name);
                if (set != null) {
                    list.addAll(set);
                }
            }
            finally {
                this.getLock().readLock().unlock();
            }
            if (list.size() > 0) {
                ArrayList<CsmFriend> res = new ArrayList<CsmFriend>();
                for (CsmUID csmUID : list) {
                    CsmFriendFunction fun;
                    CsmFriend friend = (CsmFriend)csmUID.getObject();
                    if (CsmKindUtilities.isFriendClass((CsmObject)friend)) {
                        CsmFriendClass cls = (CsmFriendClass)friend;
                        if (!decl.equals(cls.getReferencedClass())) continue;
                        res.add((CsmFriend)cls);
                        continue;
                    }
                    if (!CsmKindUtilities.isFriendMethod((CsmObject)friend) || !decl.equals((fun = (CsmFriendFunction)friend).getReferencedFunction())) continue;
                    res.add((CsmFriend)fun);
                }
                return res;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        try {
            this.getLock().readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMapSet(this.friends, aStream);
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }
}

