/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;

public class ChangeEventImpl
extends CsmChangeEvent {
    protected Set<CsmFile> newFiles;
    protected Set<CsmFile> removedFiles;
    protected Set<CsmFile> changedFiles;
    protected Set<CsmOffsetableDeclaration> newDeclarations;
    protected Set<CsmOffsetableDeclaration> removedDeclarations;
    protected Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> changedDeclarations;
    protected Set<CsmProject> changedProjects;
    protected Map<CharSequence, CsmNamespace> newNamespaces;
    protected Map<CharSequence, CsmNamespace> removedNamespaces;

    public ChangeEventImpl(Object source) {
        super(source);
    }

    public Collection<CsmFile> getNewFiles() {
        if (this.newFiles == null) {
            this.newFiles = new HashSet<CsmFile>();
        }
        return this.newFiles;
    }

    public Collection<CsmFile> getRemovedFiles() {
        if (this.removedFiles == null) {
            this.removedFiles = new HashSet<CsmFile>();
        }
        return this.removedFiles;
    }

    public Collection<CsmFile> getChangedFiles() {
        if (this.changedFiles == null) {
            this.changedFiles = new HashSet<CsmFile>();
        }
        return this.changedFiles;
    }

    public Collection<CsmOffsetableDeclaration> getNewDeclarations() {
        if (this.newDeclarations == null) {
            this.newDeclarations = new HashSet<CsmOffsetableDeclaration>();
        }
        return this.newDeclarations;
    }

    public Collection<CsmOffsetableDeclaration> getRemovedDeclarations() {
        if (this.removedDeclarations == null) {
            this.removedDeclarations = new HashSet<CsmOffsetableDeclaration>();
        }
        return this.removedDeclarations;
    }

    public Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> getChangedDeclarations() {
        if (this.changedDeclarations == null) {
            this.changedDeclarations = new HashMap<CsmOffsetableDeclaration, CsmOffsetableDeclaration>();
        }
        return this.changedDeclarations;
    }

    public Collection<CsmProject> getChangedProjects() {
        if (this.changedProjects == null) {
            this.changedProjects = new HashSet<CsmProject>();
        }
        return this.changedProjects;
    }

    public Collection<CsmNamespace> getNewNamespaces() {
        if (this.newNamespaces != null) {
            return this.newNamespaces.values();
        }
        return Collections.emptyList();
    }

    public Collection<CsmNamespace> getRemovedNamespaces() {
        if (this.removedNamespaces != null) {
            return this.removedNamespaces.values();
        }
        return Collections.emptyList();
    }

    public boolean isEmpty() {
        return !(this.changedProjects != null && !this.changedProjects.isEmpty() || this.newFiles != null && !this.newFiles.isEmpty() || this.changedFiles != null && !this.changedFiles.isEmpty() || this.removedFiles != null && !this.removedFiles.isEmpty() || this.newDeclarations != null && !this.newDeclarations.isEmpty() || this.removedDeclarations != null && !this.removedDeclarations.isEmpty() || this.changedDeclarations != null && !this.changedDeclarations.isEmpty() || this.newNamespaces != null && !this.newNamespaces.isEmpty() || this.removedNamespaces != null && !this.removedNamespaces.isEmpty());
    }

    public void addChangedFile(CsmFile file) {
        this.getChangedFiles().add(file);
        this.getChangedProjects().add(file.getProject());
    }

    public void addNewFile(CsmFile file) {
        this.getNewFiles().add(file);
        this.getChangedProjects().add(file.getProject());
    }

    public void addRemovedFile(CsmFile file) {
        this.getRemovedFiles().add(file);
        this.getChangedProjects().add(file.getProject());
    }

    public void addChangedDeclaration(CsmOffsetableDeclaration oldDecl, CsmOffsetableDeclaration newDecl) {
        this.getChangedDeclarations().put(oldDecl, newDecl);
        this.addChangedFile(oldDecl.getContainingFile());
    }

    public void addNewDeclaration(CsmOffsetableDeclaration declaration) {
        this.getNewDeclarations().add(declaration);
        CsmFile file = declaration.getContainingFile();
        if (!this.getNewFiles().contains(file)) {
            this.addChangedFile(file);
        }
    }

    public void addRemovedDeclaration(CsmOffsetableDeclaration declaration) {
        this.getRemovedDeclarations().add(declaration);
        CsmFile file = declaration.getContainingFile();
        if (!this.getRemovedFiles().contains(file)) {
            this.addChangedFile(file);
        }
    }

    public void addNewNamespace(CsmNamespace ns) {
        if (this._getRemovedNamespaces().remove(ns.getQualifiedName()) == null) {
            this._getNewNamespaces().put(ns.getQualifiedName(), ns);
            this.getChangedProjects().add(ns.getProject());
        }
    }

    public void addRemovedNamespace(CsmNamespace ns) {
        if (this._getNewNamespaces().get(ns.getQualifiedName()) == null) {
            this._getRemovedNamespaces().put(ns.getQualifiedName(), ns);
            this.getChangedProjects().add(ns.getProject());
        }
    }

    private Map<CharSequence, CsmNamespace> _getRemovedNamespaces() {
        if (this.removedNamespaces == null) {
            this.removedNamespaces = new HashMap<CharSequence, CsmNamespace>();
        }
        return this.removedNamespaces;
    }

    private Map<CharSequence, CsmNamespace> _getNewNamespaces() {
        if (this.newNamespaces == null) {
            this.newNamespaces = new HashMap<CharSequence, CsmNamespace>();
        }
        return this.newNamespaces;
    }
}

