/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Line2Offset;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public abstract class AbstractFileBuffer
implements FileBuffer {
    private final CharSequence absPath;
    private final FileSystem fileSystem;
    private Reference<Line2Offset> lines = new WeakReference<Object>(null);
    private final APTFileBuffer.BufferType bufType;

    protected AbstractFileBuffer(FileObject fileObject) {
        this.absPath = FilePathCache.getManager().getString((CharSequence)CndFileUtils.normalizePath((FileObject)fileObject));
        this.fileSystem = AbstractFileBuffer.getFileSystem(fileObject);
        this.bufType = MIMENames.isCppOrCOrFortran((String)fileObject.getMIMEType()) ? APTFileBuffer.BufferType.START_FILE : APTFileBuffer.BufferType.INCLUDED;
    }

    protected final String getEncoding() {
        FileObject fo = this.getFileObject();
        Charset cs = null;
        if (fo != null && fo.isValid()) {
            cs = FileEncodingQuery.getEncoding((FileObject)fo);
        }
        if (cs == null) {
            cs = FileEncodingQuery.getDefaultEncoding();
        }
        return cs.name();
    }

    private static FileSystem getFileSystem(FileObject fileObject) {
        try {
            return fileObject.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return InvalidFileObjectSupport.getDummyFileSystem();
        }
    }

    public APTFileBuffer.BufferType getType() {
        return this.bufType;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    @Override
    public CharSequence getUrl() {
        return CndFileSystemProvider.toUrl((FileSystem)this.fileSystem, (CharSequence)this.absPath);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public FileObject getFileObject() {
        FileObject result = CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)this.absPath);
        if (result == null) {
            result = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)this.fileSystem, (CharSequence)this.absPath);
        }
        return result;
    }

    public final void write(RepositoryDataOutput output) throws IOException {
        assert (this.absPath != null);
        PersistentUtils.writeUTF(this.absPath, output);
        PersistentUtils.writeFileSystem(this.fileSystem, output);
        output.writeByte((int)((byte)this.bufType.ordinal()));
    }

    protected AbstractFileBuffer(RepositoryDataInput input) throws IOException {
        this.absPath = PersistentUtils.readUTF(input, FilePathCache.getManager());
        this.fileSystem = PersistentUtils.readFileSystem(input);
        assert (this.absPath != null);
        this.bufType = APTFileBuffer.BufferType.values()[input.readByte()];
    }

    @Override
    public int[] getLineColumnByOffset(int offset) throws IOException {
        return this.getLine2Offset().getLineColumnByOffset(offset);
    }

    @Override
    public int getOffsetByLineColumn(int line, int column) throws IOException {
        return this.getLine2Offset().getOffsetByLineColumn(line, column);
    }

    private Line2Offset getLine2Offset() throws IOException {
        Line2Offset lines2Offset = null;
        Reference<Line2Offset> aLines = this.lines;
        if (aLines != null) {
            lines2Offset = aLines.get();
        }
        if (lines2Offset == null) {
            lines2Offset = new Line2Offset(this.getCharBuffer());
            this.lines = new WeakReference<Line2Offset>(lines2Offset);
        }
        return lines2Offset;
    }

    protected void clearLineCache() {
        Reference<Line2Offset> aLines = this.lines;
        if (aLines != null) {
            aLines.clear();
        }
    }
}

