/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.openide.util.CharSequences;

public class NameHolder {
    private final CharSequence name;
    private int start = 0;
    private int end = 0;
    private boolean isMacroExpanded = false;
    private static final int FUNCTION = 0;
    private static final int DESTRUCTOR = 1;
    private static final int DESTRUCTOR_DEFINITION = 2;
    private static final int CLASS = 3;
    private static final int ENUM = 4;

    private NameHolder(AST ast, int kind) {
        switch (kind) {
            case 1: {
                this.name = "~" + this.findFunctionName(ast);
                break;
            }
            case 2: {
                this.name = this.findDestructorDefinitionName(ast);
                break;
            }
            case 3: {
                this.name = this.findClassName(ast);
                break;
            }
            case 4: {
                this.name = this.findEnumName(ast);
                break;
            }
            default: {
                this.name = this.findFunctionName(ast);
            }
        }
    }

    private NameHolder(CharSequence name) {
        this.name = name;
    }

    public static NameHolder createName(CharSequence name) {
        return new NameHolder(name);
    }

    public static NameHolder createFunctionName(AST ast) {
        return new NameHolder(ast, 0);
    }

    public static NameHolder createDestructorName(AST ast) {
        return new NameHolder(ast, 1);
    }

    public static NameHolder createDestructorDefinitionName(AST ast) {
        return new NameHolder(ast, 2);
    }

    public static NameHolder createClassName(AST ast) {
        return new NameHolder(ast, 3);
    }

    public static NameHolder createEnumName(AST ast) {
        return new NameHolder(ast, 4);
    }

    public static NameHolder createSimpleName(AST ast) {
        NameHolder nameHolder = new NameHolder(AstUtil.getText(ast));
        nameHolder.start = OffsetableBase.getStartOffset(ast);
        nameHolder.isMacroExpanded = NameHolder.isMacroExpandedToken(ast);
        nameHolder.end = OffsetableBase.getEndOffset(ast);
        return nameHolder;
    }

    public CharSequence getName() {
        if (this.name == null || this.name.length() == 0) {
            return CharSequences.empty();
        }
        return this.name;
    }

    public int getStartOffset() {
        return this.start;
    }

    public int getEndOffset() {
        return this.end;
    }

    public String toString() {
        return "name=" + this.name + ", start=" + this.start + ", end=" + this.end + ", isMacroExpanded=" + this.isMacroExpanded;
    }

    public void addReference(CsmFile file, final CsmObject decl) {
        if (file instanceof FileImpl && this.start > 0 && !this.isMacroExpanded) {
            final FileImpl fileImpl = (FileImpl)file;
            final CsmReferenceKind kind = CsmKindUtilities.isFunctionDefinition((CsmObject)decl) || CsmKindUtilities.isVariableDefinition((CsmObject)decl) ? CsmReferenceKind.DEFINITION : CsmReferenceKind.DECLARATION;
            CsmReference ref = new CsmReference(){

                public CsmReferenceKind getKind() {
                    return kind;
                }

                public CsmObject getReferencedObject() {
                    return decl;
                }

                public CsmObject getOwner() {
                    return decl;
                }

                public CsmFile getContainingFile() {
                    return fileImpl;
                }

                public int getStartOffset() {
                    return NameHolder.this.start;
                }

                public int getEndOffset() {
                    return NameHolder.this.end;
                }

                public CsmOffsetable.Position getStartPosition() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public CsmOffsetable.Position getEndPosition() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public CharSequence getText() {
                    return NameHolder.this.name;
                }

                public CsmObject getClosestTopLevelObject() {
                    return decl;
                }
            };
            fileImpl.addReference(ref, decl);
        }
    }

    private static boolean isMacroExpandedToken(AST ast) {
        if (ast instanceof CsmAST) {
            return APTUtils.isMacroExpandedToken((Token)((CsmAST)ast).getToken());
        }
        return false;
    }

    private CharSequence findDestructorDefinitionName(AST node) {
        AST token = node.getFirstChild();
        if (token != null) {
            token = AstUtil.findSiblingOfType(token, 508);
        }
        if (token != null && (token = AstUtil.findChildOfType(token, 45)) != null) {
            AST startNameToken = token.getNextSibling();
            if (startNameToken == null) {
                startNameToken = token;
            }
            this.start = OffsetableBase.getStartOffset(startNameToken);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(token);
            this.end = OffsetableBase.getEndOffset(token);
            if ((token = token.getNextSibling()) != null && token.getType() == 90) {
                this.end = OffsetableBase.getEndOffset(token);
                return "~" + token.getText();
            }
        }
        return "~";
    }

    private CharSequence findFunctionName(AST ast) {
        if (CastUtils.isCast(ast)) {
            return this.getFunctionName(ast);
        }
        AST token = AstUtil.findMethodName(ast);
        if (token != null) {
            return this.extractName(token);
        }
        return "";
    }

    private String getFunctionName(AST ast) {
        AST operator = AstUtil.findChildOfType(ast, 109);
        if (operator == null) {
            return "operator ???";
        }
        this.start = OffsetableBase.getStartOffset(operator);
        this.isMacroExpanded = NameHolder.isMacroExpandedToken(operator);
        this.end = OffsetableBase.getEndOffset(operator);
        StringBuilder sb = new StringBuilder(operator.getText());
        sb.append(' ');
        block6: for (AST next = operator.getNextSibling(); next != null; next = next.getNextSibling()) {
            switch (next.getType()) {
                case 474: 
                case 475: {
                    sb.append(' ');
                    this.addTypeText(next, sb);
                    continue block6;
                }
                case 540: {
                    this.addTypeText(next, sb);
                    continue block6;
                }
                case 12: {
                    break block6;
                }
                case 32: 
                case 43: 
                case 134: 
                case 135: 
                case 136: {
                    this.end = OffsetableBase.getEndOffset(next);
                    sb.append(next.getText());
                    continue block6;
                }
                default: {
                    sb.append(' ');
                    this.end = OffsetableBase.getEndOffset(next);
                    sb.append(next.getText());
                }
            }
        }
        return sb.toString();
    }

    private void addTypeText(AST ast, StringBuilder sb) {
        if (ast == null) {
            return;
        }
        for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (460 <= child.getType() && child.getType() <= 547) {
                this.addTypeText(child, sb);
                continue;
            }
            this.end = OffsetableBase.getEndOffset(child);
            String text = child.getText();
            assert (text != null);
            assert (text.length() > 0);
            if (sb.length() > 0 && Character.isLetterOrDigit(sb.charAt(sb.length() - 1)) && Character.isLetterOrDigit(text.charAt(0))) {
                sb.append(' ');
            }
            sb.append(text);
        }
    }

    private CharSequence extractName(AST token) {
        AST last;
        int type = token.getType();
        if (type == 90) {
            this.start = OffsetableBase.getStartOffset(token);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(token);
            this.end = OffsetableBase.getEndOffset(token);
            return AstUtil.getText(token);
        }
        if (type == 508 && (last = AstUtil.getLastChild(token)) != null) {
            if (last.getType() == 23) {
                AST lastId = null;
                int level = 0;
                block5: for (AST token2 = token.getFirstChild(); token2 != null; token2 = token2.getNextSibling()) {
                    int type2 = token2.getType();
                    switch (type2) {
                        case 90: {
                            lastId = token2;
                            continue block5;
                        }
                        case 23: {
                            --level;
                            continue block5;
                        }
                        case 21: {
                            ++level;
                            continue block5;
                        }
                        default: {
                            if (level != 0) continue block5;
                            lastId = null;
                        }
                    }
                }
                if (lastId != null) {
                    last = lastId;
                }
            }
            if (last.getType() == 90) {
                this.start = OffsetableBase.getStartOffset(last);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(last);
                this.end = OffsetableBase.getEndOffset(last);
                return AstUtil.getText(last);
            }
            AST operator = AstUtil.findChildOfType(token, 109);
            if (operator != null) {
                this.start = OffsetableBase.getStartOffset(operator);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(operator);
                this.end = OffsetableBase.getEndOffset(operator);
                StringBuilder sb = new StringBuilder(operator.getText());
                sb.append(' ');
                boolean first = true;
                for (AST next = operator.getNextSibling(); next != null && (first || next.getType() != 21); next = next.getNextSibling()) {
                    sb.append(next.getText());
                    this.end = OffsetableBase.getEndOffset(next);
                    first = false;
                }
                return sb.toString();
            }
            AST first = token.getFirstChild();
            if (first.getType() == 90) {
                this.start = OffsetableBase.getStartOffset(first);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(first);
                this.end = OffsetableBase.getEndOffset(first);
                return AstUtil.getText(first);
            }
        }
        return "";
    }

    private CharSequence findClassName(AST ast) {
        return this.findId(ast, 17, true);
    }

    private CharSequence findEnumName(AST ast) {
        AST token;
        CharSequence aName = this.findId(ast, 17, false);
        if ((aName == null || aName.length() == 0) && (token = ast.getNextSibling()) != null && token.getType() == 90) {
            this.start = OffsetableBase.getStartOffset(token);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(token);
            this.end = OffsetableBase.getEndOffset(token);
            aName = AstUtil.getText(token);
        }
        return aName;
    }

    private CharSequence findId(AST ast, int limitingTokenType, boolean qualified) {
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            int type = token.getType();
            if (type == limitingTokenType && limitingTokenType >= 0) {
                return null;
            }
            if (type == 90) {
                this.start = OffsetableBase.getStartOffset(token);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(token);
                this.end = OffsetableBase.getEndOffset(token);
                return AstUtil.getText(token);
            }
            if (type != 508) continue;
            if (qualified) {
                AST lastNamePart = AstUtil.getLastChild(token);
                this.start = OffsetableBase.getStartOffset(lastNamePart);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(lastNamePart);
                this.end = OffsetableBase.getEndOffset(lastNamePart);
                return AstUtil.getText(token);
            }
            AST last = AstUtil.getLastChild(token);
            if (last == null) continue;
            if (last.getType() == 90) {
                this.start = OffsetableBase.getStartOffset(last);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(last);
                this.end = OffsetableBase.getEndOffset(last);
                return AstUtil.getText(last);
            }
            AST first = token.getFirstChild();
            if (first.getType() == 109) {
                this.start = OffsetableBase.getStartOffset(first);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(first);
                this.end = OffsetableBase.getEndOffset(first);
                StringBuilder sb = new StringBuilder(first.getText());
                sb.append(' ');
                AST next = first.getNextSibling();
                if (next != null) {
                    this.end = OffsetableBase.getEndOffset(next);
                    sb.append(next.getText());
                }
                return sb.toString();
            }
            if (first.getType() != 90) continue;
            this.start = OffsetableBase.getStartOffset(first);
            this.end = OffsetableBase.getEndOffset(first);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(first);
            return AstUtil.getText(first);
        }
        return "";
    }
}

