/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public final class FriendClassImpl
extends OffsetableDeclarationBase<CsmFriendClass>
implements CsmFriendClass,
CsmTemplate {
    private final CharSequence name;
    private final CharSequence[] nameParts;
    private final CsmUID<CsmClass> parentUID;
    private final CsmUID<CsmClassForwardDeclaration> classForwardUID;
    private CsmUID<CsmClass> friendUID;
    private TemplateDescriptor templateDescriptor = null;
    private SpecializationDescriptor specializationDesctiptor;
    private int lastParseCount = -1;
    private int lastFileID = -1;

    private FriendClassImpl(AST ast, AST qid, CsmClassForwardDeclaration cfd, FileImpl file, CsmClass parent, boolean register) throws AstRendererException {
        super(ast, file);
        this.parentUID = UIDs.get((Object)parent);
        AST aST = qid = qid != null ? qid : AstUtil.findSiblingOfType(ast, 508);
        if (qid == null) {
            throw new AstRendererException(file, this.getStartOffset(), "Invalid friend class declaration.");
        }
        this.name = QualifiedNameCache.getManager().getString(AstRenderer.getQualifiedName(qid));
        this.nameParts = this.initNameParts(qid);
        this.classForwardUID = UIDCsmConverter.declarationToUID(cfd);
        AST templateParams = AstUtil.findSiblingOfType(ast, 115);
        if (templateParams != null) {
            List<CsmTemplateParameter> params = TemplateUtils.getTemplateParameters(templateParams, file, (CsmScope)parent, register);
            String classSpecializationSuffix = TemplateUtils.getClassSpecializationSuffix(templateParams, null);
            String fullName = "<" + classSpecializationSuffix + ">";
            this.setTemplateDescriptor(params, fullName, !classSpecializationSuffix.isEmpty(), register);
        }
        this.specializationDesctiptor = SpecializationDescriptor.createIfNeeded(ast, this.getContainingFile(), (CsmScope)parent, register);
    }

    public static FriendClassImpl create(AST ast, AST qid, CsmClassForwardDeclaration cfd, FileImpl file, CsmClass parent, boolean register) throws AstRendererException {
        FriendClassImpl friendClassImpl = new FriendClassImpl(ast, qid, cfd, file, parent, register);
        FriendClassImpl.postObjectCreateRegistration(register, friendClassImpl);
        return friendClassImpl;
    }

    @Override
    protected boolean registerInProject() {
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            return ((ProjectBase)project).registerDeclaration(this);
        }
        return false;
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.parentUID.getObject();
    }

    public CsmScope getScope() {
        return this.getContainingClass();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmClass cls = this.getContainingClass();
        CharSequence clsQName = cls.getQualifiedName();
        if (clsQName != null && clsQName.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)clsQName).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION;
    }

    private boolean needRecount(int newParseCount, Resolver currentResolver) {
        int fileID;
        if (this.lastParseCount != newParseCount) {
            return true;
        }
        CsmFile startFile = null;
        if (currentResolver != null) {
            startFile = currentResolver.getStartFile();
        }
        if (startFile == null) {
            startFile = this.getContainingFile();
        }
        return this.lastFileID != (fileID = UIDUtilities.getFileID(UIDs.get((Object)startFile)));
    }

    private void updateCache(int newParseCount, Resolver currentResolver) {
        int fileID;
        this.lastParseCount = newParseCount;
        CsmFile startFile = null;
        if (currentResolver != null) {
            startFile = currentResolver.getStartFile();
        }
        if (startFile == null) {
            startFile = this.getContainingFile();
        }
        this.lastFileID = fileID = UIDUtilities.getFileID(UIDs.get((Object)startFile));
    }

    public CsmClass getReferencedClass() {
        Resolver currentResolver;
        CsmClass cls = UIDCsmConverter.UIDtoClass(this.friendUID);
        int newParseCount = FileImpl.getParseCount();
        if (this.needRecount(newParseCount, currentResolver = ResolverFactory.getCurrentResolver())) {
            CsmObject o;
            if (!CsmBaseUtilities.isValid((CsmObject)cls) || ForwardClass.isForwardClass((CsmDeclaration)cls)) {
                cls = null;
                CsmClassForwardDeclaration cfd = UIDCsmConverter.UIDtoCsmObject(this.classForwardUID);
                if (CsmBaseUtilities.isValid((CsmObject)cfd)) {
                    cls = cfd.getCsmClass();
                }
                this.friendUID = UIDCsmConverter.declarationToUID(cls);
            }
            if ((!CsmBaseUtilities.isValid((CsmObject)cls) || ForwardClass.isForwardClass((CsmDeclaration)cls)) && CsmKindUtilities.isClass((CsmObject)(o = this.resolve()))) {
                cls = (CsmClass)o;
                this.friendUID = UIDCsmConverter.objectToUID(cls);
            }
            if (CsmKindUtilities.isTemplate((CsmObject)cls) && this.specializationDesctiptor != null) {
                CsmInstantiationProvider instProvider = CsmInstantiationProvider.getDefault();
                CsmObject o2 = instProvider.instantiate((CsmTemplate)cls, this.specializationDesctiptor.getSpecializationParameters());
                while (CsmKindUtilities.isInstantiation((CsmObject)o2)) {
                    o2 = ((CsmInstantiation)o2).getTemplateDeclaration();
                }
                if (CsmKindUtilities.isClass((CsmObject)o2)) {
                    cls = (CsmClass)o2;
                    this.friendUID = UIDCsmConverter.objectToUID(cls);
                }
            }
            this.updateCache(newParseCount, currentResolver);
        }
        return cls;
    }

    private CharSequence[] initNameParts(AST qid) {
        if (qid != null) {
            return AstRenderer.getNameTokens(qid);
        }
        return new CharSequence[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolve() {
        CsmObject result = null;
        Resolver aResolver = ResolverFactory.createResolver(this);
        try {
            result = aResolver.resolve(this.nameParts, 4);
        }
        finally {
            ResolverFactory.releaseResolver(aResolver);
        }
        if (result == null) {
            result = ((ProjectBase)this.getContainingFile().getProject()).getDummyForUnresolved(this.nameParts, this.getContainingFile(), this.getStartOffset());
        }
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unregisterInProject();
    }

    private void unregisterInProject() {
        CsmClassForwardDeclaration cfd = UIDCsmConverter.UIDtoCsmObject(this.classForwardUID);
        if (cfd instanceof ClassForwardDeclarationImpl) {
            ((ClassForwardDeclarationImpl)cfd).dispose();
        }
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration(this);
        this.cleanUID();
    }

    private void setTemplateDescriptor(List<CsmTemplateParameter> params, String name, boolean specialization, boolean global) {
        this.templateDescriptor = new TemplateDescriptor(params, name, specialization, global);
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        PersistentUtils.writeStrings(this.nameParts, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.parentUID, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.friendUID, output);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.classForwardUID, output);
        PersistentUtils.writeSpecializationDescriptor(this.specializationDesctiptor, output);
    }

    public FriendClassImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.nameParts = PersistentUtils.readStrings(input, NameCache.getManager());
        this.parentUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.friendUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(input);
        this.classForwardUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.specializationDesctiptor = PersistentUtils.readSpecializationDescriptor(input);
    }
}

