/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class ClassForwardDeclarationImpl
extends OffsetableDeclarationBase<CsmClassForwardDeclaration>
implements CsmClassForwardDeclaration,
CsmTemplate {
    private final CharSequence name;
    private CharSequence[] nameParts;
    private int lastParseCount = -1;
    private int lastFileID = -1;
    private CsmObject lastResult;
    private final TemplateDescriptor templateDescriptor;

    protected ClassForwardDeclarationImpl(AST ast, CsmFile file, boolean global) {
        super(file, ClassForwardDeclarationImpl.getClassForwardStartOffset(ast), ClassForwardDeclarationImpl.getClassForwardEndOffset(ast));
        AST qid = AstUtil.findChildOfType(ast, 508);
        this.name = qid == null ? CharSequences.empty() : QualifiedNameCache.getManager().getString(AstRenderer.getQualifiedName(qid));
        this.nameParts = this.initNameParts(qid);
        this.templateDescriptor = TemplateDescriptor.createIfNeeded(ast, file, null, global);
    }

    public static ClassForwardDeclarationImpl create(AST ast, CsmFile file, CsmScope scope, MutableDeclarationsContainer container, boolean global) {
        ClassForwardDeclarationImpl cfdi = new ClassForwardDeclarationImpl(ast, file, global);
        if (container != null) {
            container.addDeclaration(cfdi);
        }
        cfdi.init(ast, scope, global);
        return cfdi;
    }

    public static ClassForwardDeclarationImpl create(AST ast, CsmFile file, boolean global) {
        ClassForwardDeclarationImpl cfdi = new ClassForwardDeclarationImpl(ast, file, global);
        if (!global) {
            Utils.setSelfUID(cfdi);
        }
        return cfdi;
    }

    private static int getClassForwardStartOffset(AST ast) {
        AST secondChild;
        AST firstChild = ast.getFirstChild();
        if (firstChild != null && firstChild.getType() == 116 && (secondChild = firstChild.getNextSibling()) != null && (secondChild.getType() == 158 || secondChild.getType() == 159 || secondChild.getType() == 157)) {
            return ClassForwardDeclarationImpl.getStartOffset(secondChild);
        }
        return ClassForwardDeclarationImpl.getStartOffset(ast);
    }

    private static int getClassForwardEndOffset(AST ast) {
        AST qid;
        AST firstChild = ast.getFirstChild();
        if (firstChild != null && firstChild.getType() == 116 && (qid = AstUtil.findChildOfType(ast, 508)) != null) {
            return ClassForwardDeclarationImpl.getEndOffset(qid);
        }
        return ClassForwardDeclarationImpl.getEndOffset(ast);
    }

    public CsmScope getScope() {
        return this.getContainingFile();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        return this.name;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION;
    }

    public CsmClass getCsmClass() {
        CsmObject o = this.resolve();
        return o instanceof CsmClass ? (CsmClass)o : (CsmClass)null;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    private CharSequence[] initNameParts(AST qid) {
        if (qid != null) {
            return AstRenderer.getNameTokens(qid);
        }
        return new CharSequence[0];
    }

    private boolean needRecount(int newParseCount, Resolver currentResolver) {
        int fileID;
        if (this.lastParseCount != newParseCount) {
            return true;
        }
        CsmFile startFile = null;
        if (currentResolver != null) {
            startFile = currentResolver.getStartFile();
        }
        if (startFile == null) {
            startFile = this.getContainingFile();
        }
        return this.lastFileID != (fileID = UIDUtilities.getFileID(UIDs.get((Object)startFile)));
    }

    private void updateCache(int newParseCount, Resolver currentResolver) {
        int fileID;
        this.lastParseCount = newParseCount;
        CsmFile startFile = null;
        if (currentResolver != null) {
            startFile = currentResolver.getStartFile();
        }
        if (startFile == null) {
            startFile = this.getContainingFile();
        }
        this.lastFileID = fileID = UIDUtilities.getFileID(UIDs.get((Object)startFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolve() {
        int newParseCount = FileImpl.getParseCount();
        Resolver currentResolver = ResolverFactory.getCurrentResolver();
        CsmObject result = this.lastResult;
        if (this.needRecount(newParseCount, currentResolver)) {
            Resolver aResolver = ResolverFactory.createResolver(this);
            try {
                result = aResolver.resolve(this.nameParts, 4);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
            if (result == null) {
                result = ((ProjectBase)this.getContainingFile().getProject()).getDummyForUnresolved(this.nameParts, this.getContainingFile(), this.getStartOffset());
            }
            this.lastResult = result;
            this.updateCache(newParseCount, currentResolver);
        }
        return result;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return Collections.emptyList();
    }

    public void init(AST ast, CsmScope scope, boolean registerInProject) {
        CharSequence scopeQName;
        if (CsmKindUtilities.isQualified((CsmObject)scope) && (scopeQName = ((CsmQualifiedNamedElement)scope).getQualifiedName()) != null && scopeQName.length() > 0) {
            ArrayList<CharSequence> l = new ArrayList<CharSequence>();
            StringTokenizer stringTokenizer = new StringTokenizer(((Object)scopeQName).toString());
            while (stringTokenizer.hasMoreTokens()) {
                l.add(NameCache.getManager().getString((CharSequence)stringTokenizer.nextToken()));
            }
            l.addAll(Arrays.asList(this.nameParts));
            CharSequence[] newNameParts = new CharSequence[l.size()];
            l.toArray(newNameParts);
            this.nameParts = newNameParts;
            if (registerInProject) {
                RepositoryUtils.put(this);
            } else {
                Utils.setSelfUID(this);
            }
        }
        this.createForwardClassIfNeed(ast, scope, registerInProject);
    }

    protected CsmClass createForwardClassIfNeed(AST ast, CsmScope scope, boolean registerInProject) {
        return ForwardClass.create(((Object)this.name).toString(), this.getContainingFile(), ast, this.getStartOffset(), this.getEndOffset(), scope, registerInProject);
    }

    @Override
    public void dispose() {
        super.dispose();
        CsmClass cls = this.getCsmClass();
        if (ForwardClass.isForwardClass((CsmDeclaration)cls)) {
            ((ForwardClass)cls).dispose();
        }
        CsmNamespace scope = this.getContainingFile().getProject().getGlobalNamespace();
        ((NamespaceImpl)scope).removeDeclaration(this);
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration(this);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        PersistentUtils.writeStrings(this.nameParts, output);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, output);
    }

    public ClassForwardDeclarationImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.nameParts = PersistentUtils.readStrings(input, NameCache.getManager());
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(input);
    }
}

