/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyExecution;
import org.netbeans.modules.editor.fold.FoldHierarchyTransactionImpl;
import org.netbeans.modules.editor.fold.SpiPackageAccessor;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;

public final class FoldOperationImpl {
    private static final Logger LOG = Logger.getLogger(FoldHierarchy.class.getName());
    private FoldOperation operation;
    private FoldHierarchyExecution execution;
    private FoldManager manager;
    private int priority;
    private boolean released;

    public FoldOperationImpl(FoldHierarchyExecution execution, FoldManager manager, int priority) {
        this.execution = execution;
        this.manager = manager;
        this.priority = priority;
        this.operation = SpiPackageAccessor.get().createFoldOperation(this);
        if (manager != null) {
            manager.init(this.getOperation());
        }
    }

    public FoldOperation getOperation() {
        return this.operation;
    }

    public void initFolds(FoldHierarchyTransactionImpl transaction) {
        this.manager.initFolds(transaction.getTransaction());
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Fold Hierarchy after initFolds():\n" + this.execution + '\n');
            this.execution.checkConsistency();
        }
    }

    public FoldHierarchy getHierarchy() {
        return this.execution.getHierarchy();
    }

    public FoldManager getManager() {
        return this.manager;
    }

    public int getPriority() {
        return this.priority;
    }

    public Document getDocument() {
        return this.execution.getComponent().getDocument();
    }

    public Fold createFold(FoldType type, String description, boolean collapsed, int startOffset, int endOffset, int startGuardedLength, int endGuardedLength, Object extraInfo) throws BadLocationException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating fold: type=" + type + ", description='" + description + "', collapsed=" + collapsed + ", startOffset=" + startOffset + ", endOffset=" + endOffset + ", startGuardedLength=" + startGuardedLength + ", endGuardedLength=" + endGuardedLength + ", extraInfo=" + extraInfo + '\n');
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "Fold creation stack", new Exception());
            }
        }
        return FoldOperationImpl.getAccessor().createFold(this, type, description, collapsed, this.getDocument(), startOffset, endOffset, startGuardedLength, endGuardedLength, extraInfo);
    }

    public Object getExtraInfo(Fold fold) {
        this.checkFoldOperation(fold);
        return FoldOperationImpl.getAccessor().foldGetExtraInfo(fold);
    }

    public boolean isStartDamaged(Fold fold) {
        this.checkFoldOperation(fold);
        return FoldOperationImpl.getAccessor().foldIsStartDamaged(fold);
    }

    public boolean isEndDamaged(Fold fold) {
        this.checkFoldOperation(fold);
        return FoldOperationImpl.getAccessor().foldIsEndDamaged(fold);
    }

    public FoldHierarchyTransactionImpl openTransaction() {
        return this.execution.openTransaction();
    }

    public boolean addToHierarchy(Fold fold, FoldHierarchyTransactionImpl transaction) {
        this.checkFoldOperation(fold);
        return this.execution.add(fold, transaction);
    }

    public void removeFromHierarchy(Fold fold, FoldHierarchyTransactionImpl transaction) {
        this.checkFoldOperation(fold);
        this.execution.remove(fold, transaction);
    }

    public boolean isAddedOrBlocked(Fold fold) {
        this.checkFoldOperation(fold);
        return this.execution.isAddedOrBlocked(fold);
    }

    public boolean isBlocked(Fold fold) {
        this.checkFoldOperation(fold);
        return this.execution.isBlocked(fold);
    }

    public void setEndOffset(Fold fold, int endOffset, FoldHierarchyTransactionImpl transaction) throws BadLocationException {
        this.checkFoldOperation(fold);
        int origEndOffset = fold.getEndOffset();
        ApiPackageAccessor api = FoldOperationImpl.getAccessor();
        api.foldSetEndOffset(fold, this.getDocument(), endOffset);
        api.foldStateChangeEndOffsetChanged(transaction.getFoldStateChange(fold), origEndOffset);
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransactionImpl transaction) {
        this.manager.insertUpdate(evt, transaction.getTransaction());
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransactionImpl transaction) {
        this.manager.removeUpdate(evt, transaction.getTransaction());
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransactionImpl transaction) {
        this.manager.changedUpdate(evt, transaction.getTransaction());
    }

    public void release() {
        this.released = true;
        this.manager.release();
    }

    public boolean isReleased() {
        return this.released;
    }

    private void checkFoldOperation(Fold fold) {
        FoldOperationImpl foldOperation = FoldOperationImpl.getAccessor().foldGetOperation(fold);
        if (foldOperation != this) {
            throw new IllegalStateException("Attempt to use the fold " + fold + " with invalid fold operation " + foldOperation + " instead of " + this);
        }
    }

    private static ApiPackageAccessor getAccessor() {
        return ApiPackageAccessor.get();
    }
}

