/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateId;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class IdDefinedInHierarchy
extends JPAClassRule {
    public IdDefinedInHierarchy() {
        this.setClassContraints(Collections.singleton(JPAClassRule.ClassConstraints.ENTITY));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        TypeElement javaClass = subject;
        Object modelElement = ctx.getModelElement();
        EntityMappingsMetadata metadata = ((JPAProblemContext)ctx).getMetaData();
        do {
            Element parent;
            if (JPAHelper.isAnyMemberAnnotatedAsIdOrEmbeddedId(modelElement)) {
                return null;
            }
            TypeMirror parentType = javaClass.getSuperclass();
            javaClass = null;
            if ("java.lang.Object".equals(((Object)parentType).toString()) || parentType.getKind() != TypeKind.DECLARED || (parent = ((DeclaredType)parentType).asElement()).getKind() != ElementKind.CLASS || (modelElement = ModelUtils.getEntity(metadata, javaClass = (TypeElement)parent)) != null) continue;
            modelElement = ModelUtils.getMappedSuperclass(metadata, javaClass);
        } while (javaClass != null && modelElement != null);
        CreateId fix = new CreateId(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)subject), ((JPAProblemContext)ctx).getAccessType());
        return new ErrorDescription[]{IdDefinedInHierarchy.createProblem((Element)subject, ctx, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_NoIdDefinedInHierarchy"), fix)};
    }
}

