/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateDefaultConstructor;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class HasNoArgConstructor
extends JPAClassRule {
    public HasNoArgConstructor() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.IDCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        if (!subject.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        boolean hasDefaultContructor = true;
        for (ExecutableElement constr : ElementFilter.constructorsIn(subject.getEnclosedElements())) {
            hasDefaultContructor = false;
            if (constr.getParameters().size() != 0 || !constr.getModifiers().contains((Object)Modifier.PUBLIC) && !constr.getModifiers().contains((Object)Modifier.PROTECTED)) continue;
            return null;
        }
        if (hasDefaultContructor) {
            return null;
        }
        CreateDefaultConstructor fix = new CreateDefaultConstructor(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)ctx.getJavaClass()));
        return new ErrorDescription[]{HasNoArgConstructor.createProblem((Element)subject, ctx, NbBundle.getMessage(HasNoArgConstructor.class, (String)"MSG_HasNoNoArgConstructor"), fix)};
    }
}

