/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.netbeans.modules.php.zend.ZendPhpFrameworkProvider;
import org.netbeans.modules.php.zend.ZendScript;
import org.netbeans.modules.php.zend.ui.wizards.NewProjectConfigurationPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ZendPhpModuleExtender
extends PhpModuleExtender {
    private NewProjectConfigurationPanel panel = null;

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        FileObject bootstrap;
        FileObject indexController;
        ZendScript zendScript = null;
        try {
            zendScript = ZendScript.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        assert (zendScript.isValid()) : "Zend script has to be valid!";
        if (!zendScript.initProject(phpModule)) {
            Logger.getLogger(ZendPhpModuleExtender.class.getName()).log(Level.INFO, "Framework Zend not found in newly created project {0}", phpModule.getDisplayName());
            throw new PhpModuleExtender.ExtendingException(NbBundle.getMessage(ZendPhpModuleExtender.class, (String)"MSG_NotExtended"));
        }
        ZendPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule).refreshFrameworkCommandsLater(null);
        HashSet<FileObject> files = new HashSet<FileObject>();
        FileObject appConfig = phpModule.getSourceDirectory().getFileObject("application/configs/application.ini");
        if (appConfig != null) {
            files.add(appConfig);
        }
        if ((indexController = phpModule.getSourceDirectory().getFileObject("application/controllers/IndexController.php")) != null) {
            files.add(indexController);
        }
        if ((bootstrap = phpModule.getSourceDirectory().getFileObject("application/Bootstrap.php")) != null) {
            files.add(bootstrap);
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        try {
            ZendScript.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            return NbBundle.getMessage(ZendPhpModuleExtender.class, (String)"MSG_CannotExtend", (Object)ex.getMessage());
        }
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return this.getPanel().getWarningMessage();
    }

    private synchronized NewProjectConfigurationPanel getPanel() {
        if (this.panel == null) {
            this.panel = new NewProjectConfigurationPanel();
        }
        return this.panel;
    }
}

