/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.openide.util.Parameters;

public final class ServerLibraryDependency {
    private final String name;
    private final Version specificationVersion;
    private final Version implementationVersion;
    private boolean exactMatch;

    private ServerLibraryDependency(String name, Version specificationVersion, Version implementationVersion, boolean exactMatch) {
        this.name = name;
        this.specificationVersion = specificationVersion;
        this.implementationVersion = implementationVersion;
        this.exactMatch = exactMatch;
    }

    public static ServerLibraryDependency minimalVersion(@NonNull String name, @NullAllowed Version specificationVersion, @NullAllowed Version implementationVersion) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        return new ServerLibraryDependency(name, specificationVersion, implementationVersion, false);
    }

    public static ServerLibraryDependency exactVersion(@NonNull String name, @NullAllowed Version specificationVersion, @NullAllowed Version implementationVersion) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"specificationVersion", (Object)name);
        return new ServerLibraryDependency(name, specificationVersion, implementationVersion, true);
    }

    public boolean versionMatches(@NonNull ServerLibrary library) {
        Parameters.notNull((CharSequence)"library", (Object)library);
        if (this.exactMatch) {
            return !(library.getName() == null || !library.getName().equals(this.name) || this.specificationVersion != null && !this.specificationVersion.equals(library.getSpecificationVersion()) || this.implementationVersion != null && !this.implementationVersion.equals(library.getImplementationVersion()));
        }
        return library.getName() != null && library.getName().equals(this.name) && (this.specificationVersion == null || library.getSpecificationVersion() != null && this.specificationVersion.isBelowOrEqual(library.getSpecificationVersion())) && (this.implementationVersion == null || library.getImplementationVersion() != null && this.implementationVersion.isBelowOrEqual(library.getImplementationVersion()));
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public Version getSpecificationVersion() {
        return this.specificationVersion;
    }

    @CheckForNull
    public Version getImplementationVersion() {
        return this.implementationVersion;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerLibraryDependency other = (ServerLibraryDependency)obj;
        if (!this.specificationEquals(obj)) {
            return false;
        }
        if (!(this.implementationVersion == other.implementationVersion || this.implementationVersion != null && this.implementationVersion.equals(other.implementationVersion))) {
            return false;
        }
        return this.exactMatch == other.exactMatch;
    }

    public boolean specificationEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerLibraryDependency other = (ServerLibraryDependency)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.specificationVersion == other.specificationVersion || this.specificationVersion != null && this.specificationVersion.equals(other.specificationVersion);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + (this.specificationVersion != null ? this.specificationVersion.hashCode() : 0);
        hash = 53 * hash + (this.implementationVersion != null ? this.implementationVersion.hashCode() : 0);
        hash = 53 * hash + (this.exactMatch ? 1 : 0);
        return hash;
    }
}

