/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.ServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerProgress;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InitialServerFileDistributor
extends ServerProgress {
    private static final Logger LOGGER = Logger.getLogger(InitialServerFileDistributor.class.getName());
    private final ServerString serverString;
    private final DeploymentTarget dtarget;
    private final IncrementalDeployment incDeployment;
    private final Target target;
    boolean inPlace = false;

    public InitialServerFileDistributor(DeploymentTarget dtarget, Target target) {
        super(dtarget.getServer().getServerInstance());
        this.serverString = dtarget.getServer();
        this.dtarget = dtarget;
        this.target = target;
        this.incDeployment = this.serverString.getServerInstance().getIncrementalDeployment();
    }

    public File distribute() {
        ModuleConfigurationProvider deployment = this.dtarget.getModuleConfigurationProvider();
        J2eeModule source = this.dtarget.getModule();
        String name = this.dtarget.getDeploymentName();
        File dir = this.incDeployment.getDirectoryForNewApplication(name, this.target, deployment.getModuleConfiguration());
        try {
            if (dir == null) {
                this.inPlace = true;
                if (this.dtarget.getModule().getContentDirectory() != null) {
                    dir = FileUtil.toFile((FileObject)this.dtarget.getModule().getContentDirectory());
                }
                if (dir == null) {
                    String msg = NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_InPlaceNoSupport");
                    this.setStatusDistributeFailed(msg);
                    return null;
                }
                this.setStatusDistributeCompleted(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_InPlaceDeployment", (Object)dir));
                return dir;
            }
            this.setStatusDistributeRunning(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_RunningInitialDeploy", (Object)this.dtarget.getDeploymentName(), (Object)dir));
            this._distribute(source.getArchiveContents(), dir, null);
            if (source instanceof J2eeApplication) {
                J2eeModule[] childModules = ((J2eeApplication)source).getModules();
                for (int i = 0; i < childModules.length; ++i) {
                    String uri = childModules[i].getUrl();
                    J2eeModule childModule = deployment.getJ2eeModule(uri);
                    File subdir = this.incDeployment.getDirectoryForNewModule(dir, uri, childModule, deployment.getModuleConfiguration());
                    this._distribute(childModules[i].getArchiveContents(), subdir, uri);
                }
            }
            this.setStatusDistributeCompleted(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_DoneInitialDistribute", (Object)this.dtarget.getDeploymentName()));
            return dir;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
            this.setStatusDistributeFailed(e.getMessage());
            if (!this.inPlace && !this.cleanup(dir)) {
                this.setStatusDistributeFailed("Failed to cleanup the data after unsucesful distribution");
            }
            return null;
        }
    }

    public void cleanup() {
        if (this.inPlace) {
            return;
        }
        ModuleConfigurationProvider deployment = this.dtarget.getModuleConfigurationProvider();
        J2eeModule deployable = deployment.getJ2eeModule(null);
        File dir = this.incDeployment.getDirectoryForNewApplication(this.target, deployable, deployment.getModuleConfiguration());
        if (!this.cleanup(dir)) {
            this.setStatusDistributeFailed("Failed to cleanup the data after unsucesful distribution");
        }
    }

    private boolean cleanup(File f) {
        String[] chNames = f.list();
        boolean deleted = true;
        for (int i = 0; i < chNames.length; ++i) {
            File ch = new File(f.getAbsolutePath(), chNames[i]);
            deleted = ch.isDirectory() ? deleted && this.cleanup(ch) : deleted && ch.delete();
        }
        deleted = deleted && f.delete();
        return deleted;
    }

    private void _distribute(Iterator rootedEntries, File dir, String childModuleUri) {
        Object lock = null;
        try {
            FileObject destRoot = FileUtil.createFolder((File)dir);
            FileObject[] garbages = destRoot.getChildren();
            for (int i = 0; i < garbages.length; ++i) {
                try {
                    garbages[i].delete();
                    continue;
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINER, null, ioe);
                    if (Utilities.isWindows()) {
                        String ext = garbages[i].getExt().toLowerCase(Locale.ENGLISH);
                        if ("jar".equals(ext) || "zip".equals(ext)) {
                            this.zeroOutArchive(garbages[i]);
                            continue;
                        }
                        throw ioe;
                    }
                    throw ioe;
                }
            }
            while (rootedEntries.hasNext()) {
                J2eeModule.RootedEntry entry = (J2eeModule.RootedEntry)rootedEntries.next();
                String relativePath = entry.getRelativePath();
                FileObject sourceFO = entry.getFileObject();
                FileObject destFolder = ServerFileDistributor.findOrCreateParentFolder(destRoot, relativePath);
                if (!sourceFO.isData()) continue;
                this.copyFile(sourceFO, dir, relativePath);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, null, e);
            String msg = NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)e);
            this.setStatusDistributeFailed(msg);
            throw new RuntimeException(e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.releaseLock();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void setStatusDistributeRunning(String message) {
        this.notify(this.createRunningProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeFailed(String message) {
        this.notify(this.createFailedProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeCompleted(String message) {
        this.notify(this.createCompletedProgressEvent(CommandType.DISTRIBUTE, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(FileObject sourceObject, File directory, String relativePath) throws IOException {
        String ext = sourceObject.getExt();
        if (sourceObject.getSize() == 0L && ("zip".equals(ext) || "jar".equals(ext))) {
            return;
        }
        File destFile = new File(directory, relativePath);
        FileOutputStream os = new FileOutputStream(destFile);
        FileInputStream fis = null;
        InputStream is = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            File sourceFile = FileUtil.toFile((FileObject)sourceObject);
            if (null != sourceFile && sourceFile.canRead()) {
                fis = new FileInputStream(sourceFile);
                in = fis.getChannel();
                out = os.getChannel();
                long fileSize = sourceFile.length();
                long bufSize = Math.min(65536L, fileSize);
                long offset = 0L;
                while ((offset += ((FileChannel)in).transferTo(offset, bufSize, (WritableByteChannel)((Object)out))) < fileSize) {
                }
            } else {
                is = sourceObject.getInputStream();
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zeroOutArchive(FileObject garbage) throws IOException, FileAlreadyLockedException {
        OutputStream fileToOverwrite = garbage.getOutputStream();
        try {
            JarOutputStream jos = new JarOutputStream(fileToOverwrite);
            try {
                jos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                jos.write("Manifest-Version: 1.0\n".getBytes("UTF-8"));
            }
            finally {
                jos.close();
            }
        }
        finally {
            fileToOverwrite.close();
        }
    }
}

