/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;

public final class DeploymentHelper {
    private static final Logger LOGGER = Logger.getLogger(DeploymentHelper.class.getName());

    public static void deployMessageDestinations(J2eeModuleProvider jmp) throws ConfigurationException {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(jmp.getServerInstanceID());
        if (si != null) {
            si.deployMessageDestinations(jmp.getConfigSupport().getMessageDestinations());
        } else {
            LOGGER.log(Level.WARNING, "The message destinations cannot be deployed because the server instance cannot be found.");
        }
    }

    public static void deployJdbcDrivers(J2eeModuleProvider jmp, ProgressUI progress) throws ConfigurationException, TimeoutException {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(jmp.getServerInstanceID());
        if (si != null) {
            Target target;
            ServerTarget[] targets;
            JDBCDriverDeployer jdbcDriverDeployer;
            Set<Datasource> moduleDatasources = jmp.getConfigSupport().getDatasources();
            if (moduleDatasources != null && moduleDatasources.size() > 0 && (jdbcDriverDeployer = si.getJDBCDriverDeployer()) != null && (targets = si.getTargets()).length > 0 && jdbcDriverDeployer.supportsDeployJDBCDrivers(target = targets[0].getTarget())) {
                ProgressObject po = jdbcDriverDeployer.deployJDBCDrivers(target, moduleDatasources);
                ProgressObjectUtil.trackProgressObject(progress, po, Long.MAX_VALUE);
            }
        } else {
            LOGGER.log(Level.WARNING, "The JDBC drivers cannot be deployed because the server instance cannot be found.");
        }
    }

    public static void deployDatasources(J2eeModuleProvider jmp) throws ConfigurationException, DatasourceAlreadyExistsException {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(jmp.getServerInstanceID());
        if (si != null) {
            Set<Datasource> moduleDS = jmp.getConfigSupport().getDatasources();
            si.deployDatasources(moduleDS);
        } else {
            LOGGER.log(Level.WARNING, "The data sources cannot be deployed because the server instance cannot be found.");
        }
    }

    public static void deployServerLibraries(J2eeModuleProvider jmp) throws ConfigurationException {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(jmp.getServerInstanceID());
        if (si != null) {
            Set<ServerLibraryDependency> libraries = jmp.getConfigSupport().getLibraries();
            si.deployLibraries(libraries);
        } else {
            LOGGER.log(Level.WARNING, "The libraries cannot be deployed because the server instance cannot be found.");
        }
    }
}

