/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.MappingEditor;
import org.netbeans.modules.web.wizards.MappingTable;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.Utilities;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

class MappingPanel
extends JPanel
implements ActionListener,
TableModelListener,
ListSelectionListener {
    private static final String ADD = "add";
    private static final String EDIT = "edit";
    private static final String REMOVE = "remove";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private JLabel jLtableheader;
    private MappingTable table;
    private JButton jBnew;
    private JButton jBedit;
    private JButton jBdelete;
    private JButton jBdown;
    private JButton jBup;
    private JScrollPane scrollP;
    private ServletData deployData;
    private BaseWizardPanel parent;
    private boolean edited = false;
    private static final long serialVersionUID = 6540270797782597645L;
    private TemplateWizard wizard;

    public MappingPanel(ServletData deployData, BaseWizardPanel parent, TemplateWizard wizard) {
        this.deployData = deployData;
        this.parent = parent;
        this.wizard = wizard;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints fullRowC = new GridBagConstraints();
        fullRowC.gridx = 0;
        fullRowC.gridy = 0;
        fullRowC.gridwidth = 2;
        fullRowC.anchor = 17;
        fullRowC.fill = 2;
        fullRowC.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints bC = new GridBagConstraints();
        bC.gridx = 1;
        bC.gridy = 1;
        bC.weightx = 0.05;
        bC.fill = 2;
        bC.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints tablePanelC = new GridBagConstraints();
        tablePanelC.gridx = 0;
        tablePanelC.gridy = 1;
        tablePanelC.gridheight = 6;
        tablePanelC.fill = 1;
        tablePanelC.weightx = 0.95;
        tablePanelC.weighty = 1.0;
        tablePanelC.anchor = 17;
        tablePanelC.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints fillerC = new GridBagConstraints();
        fillerC.gridx = 1;
        fillerC.gridy = -1;
        fillerC.fill = 1;
        fillerC.weighty = 1.0;
        fillerC.insets = new Insets(4, 0, 4, 0);
        this.jLtableheader = new JLabel(NbBundle.getMessage(MappingPanel.class, (String)"LBL_filter_mappings"));
        this.jLtableheader.setDisplayedMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_filter_mappings_mnemonic").charAt(0));
        this.jLtableheader.setLabelFor(this.table);
        this.add((Component)this.jLtableheader, fullRowC);
        this.table = new MappingTable(this.deployData.getName(), this.deployData.getFilterMappings());
        this.jLtableheader.setLabelFor(this.table);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_desc"));
        this.table.getModel().addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.scrollP = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.add((Component)this.scrollP, tablePanelC);
        this.jBnew = new JButton();
        this.jBnew.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_newdots"));
        this.jBnew.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_new_mnemonic").charAt(0));
        this.jBnew.addActionListener(this);
        this.jBnew.setActionCommand(ADD);
        this.jBnew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_new"));
        this.add((Component)this.jBnew, bC);
        ++bC.gridy;
        this.jBedit = new JButton();
        this.jBedit.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_edit"));
        this.jBedit.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_edit_mnemonic").charAt(0));
        this.jBedit.addActionListener(this);
        this.jBedit.setActionCommand(EDIT);
        this.jBedit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_edit"));
        this.add((Component)this.jBedit, bC);
        ++bC.gridy;
        this.jBdelete = new JButton();
        this.jBdelete.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_delete"));
        this.jBdelete.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_delete_mnemonic").charAt(0));
        this.jBdelete.addActionListener(this);
        this.jBdelete.setActionCommand(REMOVE);
        this.jBdelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_delete"));
        this.add((Component)this.jBdelete, bC);
        ++bC.gridy;
        this.jBup = new JButton();
        this.jBup.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_up"));
        this.jBup.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_up_mnemonic").charAt(0));
        this.jBup.addActionListener(this);
        this.jBup.setActionCommand(UP);
        this.jBup.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_up"));
        this.add((Component)this.jBup, bC);
        ++bC.gridy;
        this.jBdown = new JButton();
        this.jBdown.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_down"));
        this.jBdown.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_down_mnemonic").charAt(0));
        this.jBdown.addActionListener(this);
        this.jBdown.setActionCommand(DOWN);
        this.jBdown.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_down"));
        this.add((Component)this.jBdown, bC);
        ++bC.gridy;
        bC.fill = 1;
        JPanel filler = new JPanel();
        this.add((Component)filler, bC);
        this.add((Component)new JPanel(), fillerC);
    }

    void setData() {
        this.table.setFilterName(this.deployData.getName());
        if (!this.edited) {
            if (!this.deployData.makeEntry() && !Utilities.isJavaEE6(this.wizard)) {
                this.setEnabled(false);
                return;
            }
            if (this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
            this.edited = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JButton) {
            if (evt.getActionCommand() == ADD) {
                FilterMappingData fmd = new FilterMappingData(this.deployData.getName());
                MappingEditor editor = new MappingEditor(fmd, this.deployData.getServletNames());
                editor.showEditor();
                if (editor.isOK()) {
                    this.table.addRow(0, fmd);
                }
            } else if (evt.getActionCommand() == EDIT) {
                int index = this.table.getSelectedRow();
                FilterMappingData fmd = this.table.getRow(index);
                FilterMappingData fmd2 = (FilterMappingData)fmd.clone();
                MappingEditor editor = new MappingEditor(fmd2, this.deployData.getServletNames());
                editor.showEditor();
                if (editor.isOK()) {
                    this.table.setRow(index, fmd2);
                }
            } else if (evt.getActionCommand() == REMOVE) {
                int index = this.table.getSelectedRow();
                this.table.removeRow(index);
                this.table.clearSelection();
            } else if (evt.getActionCommand() == UP) {
                int index = this.table.getSelectedRow();
                this.table.moveRowUp(index);
                this.table.setRowSelectionInterval(index - 1, index - 1);
            } else if (evt.getActionCommand() == DOWN) {
                int index = this.table.getSelectedRow();
                this.table.moveRowDown(index);
                this.table.setRowSelectionInterval(index + 1, index + 1);
            }
        }
        this.edited = true;
        this.deployData.setFilterMappings(this.table.getFilterMappings());
        this.scrollP.revalidate();
        this.parent.fireChangeEvent();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.edited = true;
        this.deployData.setFilterMappings(this.table.getFilterMappings());
        this.parent.fireChangeEvent();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setEnabled(this.deployData.makeEntry() || Utilities.isJavaEE6(this.wizard));
    }

    @Override
    public void setEnabled(boolean enable) {
        this.jLtableheader.setEnabled(enable);
        this.jBnew.setEnabled(enable);
        if (!enable) {
            this.jBedit.setEnabled(false);
            this.jBdelete.setEnabled(false);
            this.jBup.setEnabled(false);
            this.jBdown.setEnabled(false);
            return;
        }
        ListSelectionModel lsm = this.table.getSelectionModel();
        if (lsm.isSelectionEmpty()) {
            this.jBdelete.setEnabled(false);
            this.jBedit.setEnabled(false);
            this.jBdown.setEnabled(false);
            this.jBup.setEnabled(false);
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            String str = (String)this.table.getValueAt(selectedRow, 0);
            boolean canEdit = str.equals(this.deployData.getName());
            this.jBdelete.setEnabled(canEdit);
            this.jBedit.setEnabled(canEdit);
            int numRows = this.table.getRowCount();
            if (selectedRow > 0) {
                this.jBup.setEnabled(true);
            } else {
                this.jBup.setEnabled(false);
            }
            if (selectedRow < numRows - 1) {
                this.jBdown.setEnabled(true);
            } else {
                this.jBdown.setEnabled(false);
            }
        }
    }
}

