/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.ListenerVisualPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ListenerPanel
implements WizardDescriptor.Panel {
    private ListenerVisualPanel component;
    private transient TemplateWizard wizard;
    private static final String SERVLET_CONTEXT_LISTENER = "javax.servlet.ServletContextListener";
    private static final String SERVLET_CONTEXT_ATTRIBUTE_LISTENER = "javax.servlet.ServletContextAttributeListener";
    private static final String HTTP_SESSION_LISTENER = "javax.servlet.http.HttpSessionListener";
    private static final String HTTP_SESSION_ATTRIBUTE_LISTENER = "javax.servlet.http.HttpSessionAttributeListener";
    private static final String SERVLET_REQUEST_LISTENER = "javax.servlet.ServletRequestListener";
    private static final String SERVLET_REQUEST_ATTRIBUTE_LISTENER = "javax.servlet.ServletRequestAttributeListener";
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ListenerPanel(TemplateWizard wizard) {
        this.wizard = wizard;
    }

    public Component getComponent() {
        if (this.component == null) {
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            WebModule wm = null;
            Profile j2eeVersion = Profile.J2EE_14;
            if (groups != null && groups.length > 0) {
                wm = WebModule.getWebModule((FileObject)groups[0].getRootFolder());
            }
            if (wm != null) {
                j2eeVersion = wm.getJ2eeProfile();
            }
            this.component = new ListenerVisualPanel(this, j2eeVersion);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (!this.isListenerSelected()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ListenerPanel.class, (String)"MSG_noListenerSelected"));
            return false;
        }
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        ClassPath cp = null;
        String resource = null;
        if (groups != null && groups.length != 0) {
            cp = ClassPath.getClassPath((FileObject)groups[0].getRootFolder(), (String)"classpath/compile");
            if (this.isContextListener()) {
                resource = SERVLET_CONTEXT_LISTENER;
            } else if (this.isContextAttrListener()) {
                resource = SERVLET_CONTEXT_ATTRIBUTE_LISTENER;
            } else if (this.isSessionListener()) {
                resource = HTTP_SESSION_LISTENER;
            } else if (this.isSessionAttrListener()) {
                resource = HTTP_SESSION_ATTRIBUTE_LISTENER;
            } else if (this.isRequestListener()) {
                resource = SERVLET_REQUEST_LISTENER;
            } else if (this.isRequestAttrListener()) {
                resource = SERVLET_REQUEST_ATTRIBUTE_LISTENER;
            }
        }
        if (cp != null && resource != null && cp.findResource(resource.replace('.', '/') + ".class") == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ListenerPanel.class, (String)"MSG_noResourceInClassPath", (Object)resource));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    boolean createElementInDD() {
        return this.component.createElementInDD();
    }

    boolean isContextListener() {
        return this.component.isContextListener();
    }

    boolean isContextAttrListener() {
        return this.component.isContextAttrListener();
    }

    boolean isSessionListener() {
        return this.component.isSessionListener();
    }

    boolean isSessionAttrListener() {
        return this.component.isSessionAttrListener();
    }

    boolean isRequestListener() {
        return this.component.isRequestListener();
    }

    boolean isRequestAttrListener() {
        return this.component.isRequestAttrListener();
    }

    boolean isListenerSelected() {
        return this.isContextListener() || this.isContextAttrListener() || this.isSessionListener() || this.isSessionAttrListener() || this.isRequestListener() || this.isRequestAttrListener();
    }
}

