/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.ui.BackgroundStyleEditor;
import org.netbeans.modules.css.visual.ui.BorderStyleEditor;
import org.netbeans.modules.css.visual.ui.FontStyleEditor;
import org.netbeans.modules.css.visual.ui.MarginStyleEditor;
import org.netbeans.modules.css.visual.ui.PositionStyleEditor;
import org.netbeans.modules.css.visual.ui.StyleEditor;
import org.netbeans.modules.css.visual.ui.TextBlockStyleEditor;

public final class StyleBuilderPanel
extends JPanel {
    private List<StyleEditor> styleEditorList = new ArrayList<StyleEditor>();
    private Document activeDocument;
    private JTabbedPane jTabbedPane1;

    public static StyleBuilderPanel createInstance() {
        return new StyleBuilderPanel();
    }

    private StyleBuilderPanel() {
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        this.jTabbedPane1.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof SingleSelectionModel) {
                    SingleSelectionModel model = (SingleSelectionModel)e.getSource();
                    StyleEditor editor = (StyleEditor)StyleBuilderPanel.this.styleEditorList.get(model.getSelectedIndex());
                    editor.initializePanel();
                }
            }
        });
        this.styleEditorList.add(new FontStyleEditor());
        this.styleEditorList.add(new BackgroundStyleEditor());
        this.styleEditorList.add(new TextBlockStyleEditor());
        this.styleEditorList.add(new BorderStyleEditor());
        this.styleEditorList.add(new MarginStyleEditor());
        this.styleEditorList.add(new PositionStyleEditor());
        for (StyleEditor styleEditor : this.styleEditorList) {
            JScrollPane spane = new JScrollPane(styleEditor);
            spane.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jTabbedPane1.addTab(styleEditor.getDisplayName(), spane);
        }
        this.jTabbedPane1.setSelectedIndex(0);
    }

    public void setContent(CssRuleContext content) {
        this.activeDocument = content.document();
        for (StyleEditor editor : this.styleEditorList) {
            editor.setContent(content);
        }
    }

    public Document getActiveDocument() {
        return this.activeDocument;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

