/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Request;
import com.jcraft.jsch.RequestAgentForwarding;
import com.jcraft.jsch.RequestEnv;
import com.jcraft.jsch.RequestPtyReq;
import com.jcraft.jsch.RequestWindowChange;
import com.jcraft.jsch.RequestX11;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.util.Enumeration;
import java.util.Hashtable;

class ChannelSession
extends Channel {
    private static byte[] _session = Util.str2byte("session");
    protected boolean agent_forwarding = false;
    protected boolean xforwading = false;
    protected Hashtable env = null;
    protected boolean pty = false;
    protected String ttype = "vt100";
    protected int tcol = 80;
    protected int trow = 24;
    protected int twp = 640;
    protected int thp = 480;
    protected byte[] terminal_mode = null;

    ChannelSession() {
        this.type = _session;
        this.io = new IO();
    }

    public void setAgentForwarding(boolean bl) {
        this.agent_forwarding = bl;
    }

    public void setXForwarding(boolean bl) {
        this.xforwading = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnv(Hashtable hashtable) {
        ChannelSession channelSession = this;
        synchronized (channelSession) {
            this.env = hashtable;
        }
    }

    public void setEnv(String string, String string2) {
        this.setEnv(Util.str2byte(string), Util.str2byte(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnv(byte[] byArray, byte[] byArray2) {
        ChannelSession channelSession = this;
        synchronized (channelSession) {
            this.getEnv().put(byArray, byArray2);
        }
    }

    private Hashtable getEnv() {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        return this.env;
    }

    public void setPty(boolean bl) {
        this.pty = bl;
    }

    public void setTerminalMode(byte[] byArray) {
        this.terminal_mode = byArray;
    }

    public void setPtySize(int n, int n2, int n3, int n4) {
        this.setPtyType(this.ttype, n, n2, n3, n4);
        if (!this.pty || !this.isConnected()) {
            return;
        }
        try {
            RequestWindowChange requestWindowChange = new RequestWindowChange();
            requestWindowChange.setSize(n, n2, n3, n4);
            requestWindowChange.request(this.getSession(), this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPtyType(String string) {
        this.setPtyType(string, 80, 24, 640, 480);
    }

    public void setPtyType(String string, int n, int n2, int n3, int n4) {
        this.ttype = string;
        this.tcol = n;
        this.trow = n2;
        this.twp = n3;
        this.thp = n4;
    }

    protected void sendRequests() throws Exception {
        Request request;
        Session session = this.getSession();
        if (this.agent_forwarding) {
            request = new RequestAgentForwarding();
            request.request(session, this);
        }
        if (this.xforwading) {
            request = new RequestX11();
            request.request(session, this);
        }
        if (this.pty) {
            request = new RequestPtyReq();
            ((RequestPtyReq)request).setTType(this.ttype);
            ((RequestPtyReq)request).setTSize(this.tcol, this.trow, this.twp, this.thp);
            if (this.terminal_mode != null) {
                ((RequestPtyReq)request).setTerminalMode(this.terminal_mode);
            }
            request.request(session, this);
        }
        if (this.env != null) {
            Enumeration enumeration = this.env.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.env.get(k);
                request = new RequestEnv();
                ((RequestEnv)request).setEnv(this.toByteArray(k), this.toByteArray(v));
                request.request(session, this);
            }
        }
    }

    private byte[] toByteArray(Object object) {
        if (object instanceof String) {
            return Util.str2byte((String)object);
        }
        return (byte[])object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = -1;
        try {
            while (this.isConnected() && this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 32 - 20);
                if (n == 0) continue;
                if (n == -1) {
                    this.eof();
                } else if (!this.close) {
                    packet.reset();
                    buffer.putByte((byte)94);
                    buffer.putInt(this.recipient);
                    buffer.putInt(n);
                    buffer.skip(n);
                    this.getSession().write(packet, this, n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread thread = this.thread;
        if (thread != null) {
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notifyAll();
            }
        }
        this.thread = null;
    }
}

