/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spi.support;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class FixFactory {
    private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.VARIABLE});

    private FixFactory() {
    }

    public static final Fix addModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toAdd, String text) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"toAdd", toAdd);
        Parameters.notNull((CharSequence)"text", (Object)text);
        return FixFactory.changeModifiersFix(compilationInfo, treePath, toAdd, Collections.<Modifier>emptySet(), text);
    }

    public static final Fix removeModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toRemove, String text) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"toRemove", toRemove);
        Parameters.notNull((CharSequence)"text", (Object)text);
        return FixFactory.changeModifiersFix(compilationInfo, treePath, Collections.<Modifier>emptySet(), toRemove, text);
    }

    public static final Fix changeModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toAdd, Set<Modifier> toRemove, String text) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"toAdd", toAdd);
        Parameters.notNull((CharSequence)"toRemove", toRemove);
        Parameters.notNull((CharSequence)"text", (Object)text);
        if (treePath.getLeaf().getKind() != Tree.Kind.MODIFIERS) {
            return null;
        }
        return new ChangeModifiersFixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), toAdd, toRemove, text);
    }

    public static Fix createSuppressWarningsFix(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"keys", (Object)keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        if (!FixFactory.isSuppressWarningsSupported(compilationInfo)) {
            return null;
        }
        while (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            return new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getFileObject(), keys);
        }
        return null;
    }

    public static List<Fix> createSuppressWarnings(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"keys", (Object)keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        Fix f = FixFactory.createSuppressWarningsFix(compilationInfo, treePath, keys);
        if (f != null) {
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    public static boolean isSuppressWarningsFix(Fix f) {
        return f instanceof FixImpl;
    }

    private static boolean isSuppressWarningsSupported(CompilationInfo info) {
        if (info.getElements().getTypeElement("java.lang.SuppressWarnings") == null) {
            return false;
        }
        return info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
    }

    private static final class ChangeModifiersFixImpl
    implements Fix {
        private final TreePathHandle modsHandle;
        private final Set<Modifier> toAdd;
        private final Set<Modifier> toRemove;
        private final String text;

        public ChangeModifiersFixImpl(TreePathHandle modsHandle, Set<Modifier> toAdd, Set<Modifier> toRemove, String text) {
            this.modsHandle = modsHandle;
            this.toAdd = toAdd;
            this.toRemove = toRemove;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.modsHandle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath path = ChangeModifiersFixImpl.this.modsHandle.resolve((CompilationInfo)wc);
                    if (path == null) {
                        return;
                    }
                    ModifiersTree mt = (ModifiersTree)path.getLeaf();
                    EnumSet<Modifier> modifiers = mt.getFlags().isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(mt.getFlags());
                    modifiers.addAll(ChangeModifiersFixImpl.this.toAdd);
                    modifiers.removeAll(ChangeModifiersFixImpl.this.toRemove);
                    ModifiersTree newMod = wc.getTreeMaker().Modifiers(modifiers, mt.getAnnotations());
                    wc.rewrite((Tree)mt, (Tree)newMod);
                }
            }).commit();
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChangeModifiersFixImpl other = (ChangeModifiersFixImpl)obj;
            if (!(this.modsHandle == other.modsHandle || this.modsHandle != null && this.modsHandle.equals((Object)other.modsHandle))) {
                return false;
            }
            if (!(this.toAdd == other.toAdd || this.toAdd != null && ((Object)this.toAdd).equals(other.toAdd))) {
                return false;
            }
            return this.toRemove == other.toRemove || this.toRemove != null && ((Object)this.toRemove).equals(other.toRemove);
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + (this.modsHandle != null ? this.modsHandle.hashCode() : 0);
            hash = 71 * hash + (this.toAdd != null ? ((Object)this.toAdd).hashCode() : 0);
            hash = 71 * hash + (this.toRemove != null ? ((Object)this.toRemove).hashCode() : 0);
            return hash;
        }
    }

    private static final class FixImpl
    implements Fix {
        private String[] keys;
        private TreePathHandle handle;
        private FileObject file;

        public FixImpl(TreePathHandle handle, FileObject file, String ... keys) {
            this.keys = keys;
            this.handle = handle;
            this.file = file;
        }

        public String getText() {
            StringBuilder keyNames = new StringBuilder();
            for (int i = 0; i < this.keys.length; ++i) {
                String string = this.keys[i];
                keyNames.append(string);
                if (i >= this.keys.length - 1) continue;
                keyNames.append(", ");
            }
            return NbBundle.getMessage(FixFactory.class, (String)"LBL_FIX_Suppress_Waning", (Object)keyNames.toString());
        }

        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws IOException {
                    TreePath path;
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    for (path = FixImpl.this.handle.resolve((CompilationInfo)copy); path != null && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)path.getLeaf().getKind()); path = path.getParentPath()) {
                    }
                    if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        return;
                    }
                    Tree top = path.getLeaf();
                    ModifiersTree modifiers = null;
                    switch (top.getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            modifiers = ((ClassTree)top).getModifiers();
                            break;
                        }
                        case METHOD: {
                            modifiers = ((MethodTree)top).getModifiers();
                            break;
                        }
                        case VARIABLE: {
                            modifiers = ((VariableTree)top).getModifiers();
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled Tree.Kind";
                            break;
                        }
                    }
                    if (modifiers == null) {
                        return;
                    }
                    TypeElement el = copy.getElements().getTypeElement("java.lang.SuppressWarnings");
                    if (el == null) {
                        return;
                    }
                    for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                        TreePath tp = new TreePath(new TreePath(path, annotationTree), annotationTree.getAnnotationType());
                        Element e = copy.getTrees().getElement(tp);
                        if (!el.equals(e)) continue;
                        List<? extends ExpressionTree> arguments = annotationTree.getArguments();
                        if (arguments.isEmpty() || arguments.size() > 1) {
                            Logger.getLogger(FixFactory.class.getName()).log(Level.INFO, "SupressWarnings annotation has incorrect number of arguments - {0}.", arguments.size());
                            return;
                        }
                        ExpressionTree et = annotationTree.getArguments().get(0);
                        if (et.getKind() != Tree.Kind.ASSIGNMENT) {
                            Logger.getLogger(FixFactory.class.getName()).log(Level.INFO, "SupressWarnings annotation's argument is not an assignment - {0}.", (Object)et.getKind());
                            return;
                        }
                        AssignmentTree assignment = (AssignmentTree)et;
                        List<ExpressionTree> currentValues = null;
                        currentValues = assignment.getExpression().getKind() == Tree.Kind.NEW_ARRAY ? ((NewArrayTree)assignment.getExpression()).getInitializers() : Collections.singletonList(assignment.getExpression());
                        assert (currentValues != null);
                        ArrayList<ExpressionTree> values = new ArrayList<ExpressionTree>(currentValues);
                        for (String key : FixImpl.this.keys) {
                            values.add(copy.getTreeMaker().Literal((Object)key));
                        }
                        copy.rewrite((Tree)assignment.getExpression(), (Tree)copy.getTreeMaker().NewArray(null, Collections.emptyList(), values));
                        return;
                    }
                    ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(modifiers.getAnnotations());
                    if (FixImpl.this.keys.length > 1) {
                        ArrayList<LiteralTree> arrayList = new ArrayList<LiteralTree>(FixImpl.this.keys.length);
                        for (String key : FixImpl.this.keys) {
                            arrayList.add(copy.getTreeMaker().Literal((Object)key));
                        }
                        annotations.add(copy.getTreeMaker().Annotation((Tree)copy.getTreeMaker().QualIdent((Element)el), Collections.singletonList(copy.getTreeMaker().NewArray(null, Collections.emptyList(), arrayList))));
                    } else {
                        annotations.add(copy.getTreeMaker().Annotation((Tree)copy.getTreeMaker().QualIdent((Element)el), Collections.singletonList(copy.getTreeMaker().Literal((Object)FixImpl.this.keys[0]))));
                    }
                    ModifiersTree modifiersTree = copy.getTreeMaker().Modifiers(modifiers, annotations);
                    copy.rewrite((Tree)modifiers, (Tree)modifiersTree);
                }
            }).commit();
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixImpl other = (FixImpl)obj;
            if (!Arrays.deepEquals(this.keys, other.keys)) {
                return false;
            }
            if (!(this.handle == other.handle || this.handle != null && this.handle.equals((Object)other.handle))) {
                return false;
            }
            return this.file == other.file || this.file != null && this.file.equals(other.file);
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Arrays.deepHashCode(this.keys);
            hash = 79 * hash + (this.handle != null ? this.handle.hashCode() : 0);
            hash = 79 * hash + (this.file != null ? this.file.hashCode() : 0);
            return hash;
        }
    }
}

