/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.MatcherUtilities;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.modules.java.hints.perf.SizeEqualsZero;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class Tiny {
    static final String SC_IGNORE_SUBSTRING = "ignore.substring";
    static final boolean SC_IGNORE_SUBSTRING_DEFAULT = true;
    private static final String CONF_SC_CHECKBOX_LABEL = NbBundle.getMessage(SizeEqualsZero.class, (String)"CONF_LBL_SizeEqualsZero");
    private static final String CONF_SC_CHECKBOX_TP = NbBundle.getMessage(SizeEqualsZero.class, (String)"CONF_TP_SizeEqualsZero");
    private static final Set<Tree.Kind> KEEP_PARENTHESIS = EnumSet.of(Tree.Kind.MEMBER_SELECT);

    public static ErrorDescription stringConstructor(HintContext ctx) {
        TreePath original = ctx.getVariables().get("$original");
        if (ctx.getPreferences().getBoolean(SC_IGNORE_SUBSTRING, true) && (MatcherUtilities.matches(ctx, original, "$str1.substring($s)", true) || MatcherUtilities.matches(ctx, original, "$str2.substring($s, $e)", true))) {
            TypeElement te;
            TreePath str;
            TreePath treePath = str = ctx.getVariables().get("$str1") != null ? ctx.getVariables().get("$str1") : ctx.getVariables().get("$str2");
            assert (str != null);
            TypeMirror type = ctx.getInfo().getTrees().getTypeMirror(str);
            if (type != null && type.getKind() == TypeKind.DECLARED && (te = (TypeElement)((DeclaredType)type).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                return null;
            }
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_StringConstructor");
        Fix f = JavaFix.rewriteFix(ctx, fixDisplayName, ctx.getPath(), "$original", new String[0]);
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_StringConstructor");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription stringEqualsEmpty(HintContext ctx) {
        Fix f;
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_6) >= 0) {
            String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_StringEqualsEmpty16");
            f = JavaFix.rewriteFix(ctx, fixDisplayName, ctx.getPath(), "$string.isEmpty()", new String[0]);
        } else {
            boolean not = ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
            String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)(not ? "FIX_StringEqualsEmptyNeg" : "FIX_StringEqualsEmpty"));
            f = JavaFix.rewriteFix(ctx, fixDisplayName, not ? ctx.getPath().getParentPath() : ctx.getPath(), not ? "$string.length() != 0" : "$string.length() == 0", new String[0]);
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_StringEqualsEmpty");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription lengthOneStringIndexOf(HintContext ctx) {
        TreePath toSearch = ctx.getVariables().get("$toSearch");
        if (toSearch.getLeaf().getKind() != Tree.Kind.STRING_LITERAL) {
            return null;
        }
        LiteralTree lt = (LiteralTree)toSearch.getLeaf();
        String data = (String)lt.getValue();
        if (data.length() != 1) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_LengthOneStringIndexOf");
        Fix f = JavaFix.rewriteFix(ctx, fixDisplayName, toSearch, "'" + (data.equals("'") ? "\\" : "") + data + "'", new String[0]);
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        String literal = ctx.getInfo().getText().substring(start, end);
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_LengthOneStringIndexOf", (Object)literal);
        return ErrorDescriptionFactory.forTree(ctx, toSearch, displayName, f);
    }

    public static ErrorDescription getClassInsteadOfDotClass(HintContext ctx) {
        TreePath O = ctx.getVariables().get("$O");
        if (O.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            O = new TreePath(O, ((ParameterizedTypeTree)O.getLeaf()).getType());
        }
        ctx.getVariables().put("$OO", O);
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_GetClassInsteadOfDotClass");
        Fix f = JavaFix.rewriteFix(ctx, fixDisplayName, ctx.getPath(), "$OO.class", new String[0]);
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_GetClassInsteadOfDotClass");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription constantIntern(HintContext ctx) {
        String target;
        TreePath str = ctx.getVariables().get("$str");
        TreePath constant = str.getLeaf().getKind() == Tree.Kind.PARENTHESIZED ? new TreePath(str, ((ParenthesizedTree)str.getLeaf()).getExpression()) : str;
        if (!Utilities.isConstantString(ctx.getInfo(), constant)) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_ConstantIntern");
        if (constant != str && KEEP_PARENTHESIS.contains((Object)ctx.getPath().getParentPath().getLeaf().getKind())) {
            target = "$str";
        } else {
            target = "$constant";
            ctx.getVariables().put("$constant", constant);
        }
        Fix f = JavaFix.rewriteFix(ctx, fixDisplayName, ctx.getPath(), target, new String[0]);
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_ConstantIntern");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription enumSet(HintContext ctx) {
        return Tiny.enumHint(ctx, "java.util.Set", null, "ERR_Tiny_enumSet", new Fix[0]);
    }

    public static ErrorDescription enumMap(HintContext ctx) {
        Fix[] fixes;
        Collection<? extends TreePath> mvars = ctx.getMultiVariables().get("$params$");
        if (mvars != null && mvars.isEmpty()) {
            String displayName = NbBundle.getMessage(Tiny.class, (String)"FIX_Tiny_enumMap");
            fixes = new Fix[]{JavaFix.rewriteFix(ctx, displayName, ctx.getPath(), "new java.util.EnumMap<$param, $to>($param.class)", new String[0])};
        } else {
            fixes = new Fix[]{};
        }
        return Tiny.enumHint(ctx, "java.util.Map", "java.util.EnumMap", "ERR_Tiny_enumMap", fixes);
    }

    private static ErrorDescription enumHint(HintContext ctx, String baseName, String targetTypeName, String key, Fix ... fixes) {
        Element type = ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$param"));
        if (type == null || type.getKind() != ElementKind.ENUM) {
            return null;
        }
        Element coll = ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$coll"));
        if (coll == null || coll.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement base = ctx.getInfo().getElements().getTypeElement(baseName);
        if (base == null) {
            return null;
        }
        Types t = ctx.getInfo().getTypes();
        if (!t.isSubtype(t.erasure(coll.asType()), t.erasure(base.asType()))) {
            return null;
        }
        if (targetTypeName != null) {
            TypeElement target = ctx.getInfo().getElements().getTypeElement(targetTypeName);
            if (target == null) {
                return null;
            }
            if (t.isSubtype(t.erasure(coll.asType()), t.erasure(target.asType()))) {
                return null;
            }
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)key);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fixes);
    }

    public static final class StringConstructorCustomizerProviderImpl
    extends OneCheckboxCustomizerProvider {
        public StringConstructorCustomizerProviderImpl() {
            super(CONF_SC_CHECKBOX_LABEL, CONF_SC_CHECKBOX_TP, Tiny.SC_IGNORE_SUBSTRING, true);
        }
    }
}

