/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.util.ChangeSupport;

public class HintsSettings {
    static final AbstractHint.HintSeverity SEVERITY_DEFAUT = AbstractHint.HintSeverity.WARNING;
    static final boolean IN_TASK_LIST_DEFAULT = true;
    public static HintsAccessor HINTS_ACCESSOR;
    static final String ENABLED_KEY = "enabled";
    static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private static final String DEFAULT_PROFILE = "default";
    private static Map<String, Preferences> preferencesOverride;
    private static final ChangeSupport cs;

    private HintsSettings() {
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static boolean isEnabled(HintMetadata hint) {
        Preferences p = RulesManager.getPreferences(hint.id, HintsSettings.getCurrentProfileId());
        return HintsSettings.isEnabled(hint, p);
    }

    public static boolean isShowInTaskList(HintMetadata hint) {
        Preferences p = RulesManager.getPreferences(hint.id, HintsSettings.getCurrentProfileId());
        return HintsSettings.isShowInTaskList(hint, p);
    }

    public static boolean isEnabled(HintMetadata metadata, Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, metadata.enabled);
    }

    public static boolean isEnabled(AbstractHint hint, Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, HINTS_ACCESSOR.isEnabledDefault(hint));
    }

    public static void setEnabled(HintMetadata metadata, boolean value) {
        HintsSettings.setEnabled(RulesManager.getPreferences(metadata.id, HintsSettings.getCurrentProfileId()), value);
        HintsSettings.fireChangeEvent();
    }

    public static void setEnabled(Preferences p, boolean value) {
        p.putBoolean(ENABLED_KEY, value);
    }

    public static boolean isShowInTaskList(HintMetadata hint, Preferences preferences) {
        Preferences p = RulesManager.getPreferences(hint.id, HintsSettings.getCurrentProfileId());
        return preferences.getBoolean(IN_TASK_LIST_KEY, hint.showInTaskList);
    }

    public static void setShowInTaskList(Preferences p, boolean value) {
        p.putBoolean(IN_TASK_LIST_KEY, value);
    }

    public static AbstractHint.HintSeverity getSeverity(HintMetadata hint, Preferences preferences) {
        String s = preferences.get(SEVERITY_KEY, null);
        return s == null ? hint.severity : AbstractHint.HintSeverity.valueOf(s);
    }

    public static AbstractHint.HintSeverity getSeverity(AbstractHint hint, Preferences preferences) {
        String s = preferences.get(SEVERITY_KEY, null);
        return s == null ? HINTS_ACCESSOR.severiryDefault(hint) : AbstractHint.HintSeverity.valueOf(s);
    }

    public static void setSeverity(Preferences p, AbstractHint.HintSeverity severity) {
        p.put(SEVERITY_KEY, severity.name());
    }

    public static String[] getSuppressedBy(AbstractHint ah) {
        return HINTS_ACCESSOR.getSuppressBy(ah);
    }

    public static void setPreferencesOverride(Map<String, Preferences> preferencesOverride) {
        HintsSettings.preferencesOverride = preferencesOverride;
    }

    public static Map<String, Preferences> getPreferencesOverride() {
        return preferencesOverride;
    }

    public static void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }

    public static void removeChangeListener(ChangeListener l) {
        cs.removeChangeListener(l);
    }

    public static void fireChangeEvent() {
        cs.fireChange();
    }

    static {
        cs = new ChangeSupport(HintsSettings.class);
    }

    public static interface HintsAccessor {
        public boolean isEnabledDefault(AbstractHint var1);

        public boolean isShowInTaskListDefault(AbstractHint var1);

        public AbstractHint.HintSeverity severiryDefault(AbstractHint var1);

        public String[] getSuppressBy(AbstractHint var1);
    }
}

