/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jdk.UseSpecificCatch;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class JoinCatches {
    public static ErrorDescription hint(HintContext ctx) {
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0) {
            return null;
        }
        TryTree tt = (TryTree)ctx.getPath().getLeaf();
        ArrayList<? extends CatchTree> catches = new ArrayList<CatchTree>(tt.getCatches());
        if (catches.size() <= 1) {
            return null;
        }
        for (int i = 0; i < catches.size(); ++i) {
            CatchTree toTest = (CatchTree)catches.get(0);
            TreePath toTestPath = new TreePath(ctx.getPath(), toTest);
            VariableElement excVar = (VariableElement)ctx.getInfo().getTrees().getElement(new TreePath(toTestPath, toTest.getParameter()));
            LinkedList<Integer> duplicates = new LinkedList<Integer>();
            for (int j = i + 1; j < catches.size(); ++j) {
                if (!CopyFinder.isDuplicate(ctx.getInfo(), new TreePath(toTestPath, toTest.getBlock()), new TreePath(new TreePath(ctx.getPath(), (Tree)catches.get(j)), ((CatchTree)catches.get(j)).getBlock()), true, ctx, false, Collections.singleton(excVar), new AtomicBoolean(), new CopyFinder.Options[0])) continue;
                TreePath catchPath = new TreePath(ctx.getPath(), (Tree)catches.get(j));
                TreePath var = new TreePath(catchPath, ((CatchTree)catches.get(j)).getParameter());
                ArrayList<TreePath> statements = new ArrayList<TreePath>();
                TreePath blockPath = new TreePath(catchPath, ((CatchTree)catches.get(j)).getBlock());
                for (StatementTree statementTree : ((CatchTree)catches.get(j)).getBlock().getStatements()) {
                    statements.add(new TreePath(blockPath, statementTree));
                }
                if (UseSpecificCatch.assignsTo(ctx, var, statements)) continue;
                duplicates.add(j);
            }
            if (duplicates.isEmpty()) continue;
            String displayName = NbBundle.getMessage(JoinCatches.class, (String)"ERR_JoinCatches");
            return ErrorDescriptionFactory.forName(ctx, toTest.getParameter().getType(), displayName, JavaFix.toEditorFix(new FixImpl(ctx.getInfo(), ctx.getPath(), i, duplicates)));
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private final int first;
        private final List<Integer> duplicates;

        public FixImpl(CompilationInfo info, TreePath tryStatement, int first, List<Integer> duplicates) {
            super(info, tryStatement);
            this.first = first;
            this.duplicates = duplicates;
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(JoinCatches.class, (String)"FIX_JoinCatches");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, JavaFix.UpgradeUICallback callback) {
            LinkedList<Tree> disjointTypes = new LinkedList<Tree>();
            TryTree tt = (TryTree)tp.getLeaf();
            disjointTypes.add(tt.getCatches().get(this.first).getParameter().getType());
            for (Integer d : this.duplicates) {
                disjointTypes.add(tt.getCatches().get(d).getParameter().getType());
            }
            LinkedList<CatchTree> newCatches = new LinkedList<CatchTree>();
            int c = 0;
            for (CatchTree catchTree : tt.getCatches()) {
                if (c == this.first) {
                    wc.rewrite(catchTree.getParameter().getType(), (Tree)wc.getTreeMaker().UnionType(disjointTypes));
                }
                if (this.duplicates.contains(c++)) continue;
                newCatches.add(catchTree);
            }
            TryTree nue = wc.getTreeMaker().Try(tt.getResources(), tt.getBlock(), newCatches, tt.getFinallyBlock());
            wc.rewrite((Tree)tt, (Tree)nue);
        }
    }
}

