/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class ClassEncapsulation {
    private static final String ACTION_PATH = "Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance";
    private static final Logger LOG = Logger.getLogger(ClassEncapsulation.class.getName());
    static final String ALLOW_ENUMS_KEY = "allow.enums";
    static final boolean ALLOW_ENUMS_DEFAULT = false;

    public static ErrorDescription publicCls(HintContext ctx) {
        assert (ctx != null);
        return ClassEncapsulation.create(ctx, Utilities.Visibility.PUBLIC, NbBundle.getMessage(ClassEncapsulation.class, (String)"TXT_PublicInnerClass"), "PublicInnerClass");
    }

    public static ErrorDescription protectedCls(HintContext ctx) {
        assert (ctx != null);
        return ClassEncapsulation.create(ctx, Utilities.Visibility.PROTECTED, NbBundle.getMessage(ClassEncapsulation.class, (String)"TXT_ProtectedInnerClass"), "ProtectedInnerClass");
    }

    public static ErrorDescription packageCls(HintContext ctx) {
        assert (ctx != null);
        return ClassEncapsulation.create(ctx, Utilities.Visibility.PACKAGE_PRIVATE, NbBundle.getMessage(ClassEncapsulation.class, (String)"TXT_PackageInnerClass"), "PackageVisibleInnerClass");
    }

    private static ErrorDescription create(HintContext ctx, Utilities.Visibility visibility, String description, String suppressWarnings) {
        assert (ctx != null);
        assert (description != null);
        assert (suppressWarnings != null);
        TreePath tp = ctx.getPath();
        Tree owner = tp.getParentPath().getLeaf();
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)owner.getKind())) {
            return null;
        }
        if (Utilities.effectiveVisibility(tp) != visibility) {
            return null;
        }
        if (ctx.getPreferences().getBoolean(ALLOW_ENUMS_KEY, false) && ctx.getInfo().getTreeUtilities().isEnum((ClassTree)tp.getLeaf())) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, tp, description, new FixImpl(TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo())), FixFactory.createSuppressWarningsFix(ctx.getInfo(), tp, suppressWarnings));
    }

    public static final class CustomizerImpl
    extends OneCheckboxCustomizerProvider {
        public CustomizerImpl() {
            super(NbBundle.getMessage(ClassEncapsulation.class, (String)"DN_IgnoreEnumForInnerClass"), NbBundle.getMessage(ClassEncapsulation.class, (String)"TP_IgnoreEnumForInnerClass"), ClassEncapsulation.ALLOW_ENUMS_KEY, false);
        }
    }

    private static class FixImpl
    implements Fix {
        private final TreePathHandle handle;

        private FixImpl(TreePathHandle handle) {
            assert (handle != null);
            this.handle = handle;
        }

        public String getText() {
            return NbBundle.getMessage(ClassEncapsulation.class, (String)"FIX_MoveInnerToOuter");
        }

        public ChangeInfo implement() throws Exception {
            FileObject file = this.handle.getFileObject();
            JTextComponent component = EditorRegistry.lastFocusedComponent();
            if (file != null && file == FixImpl.getFileObject(component)) {
                final int[] position = new int[]{-1};
                JavaSource.forFileObject((FileObject)file).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.PARSED);
                        TreePath tp = FixImpl.this.handle.resolve((CompilationInfo)controller);
                        if (tp != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                            position[0] = (int)controller.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), (ClassTree)tp.getLeaf()) + 1;
                        }
                    }
                }, true);
                this.invokeRefactoring(component, position[0]);
            }
            return null;
        }

        private static FileObject getFileObject(JTextComponent comp) {
            if (comp == null) {
                return null;
            }
            Document doc = comp.getDocument();
            if (doc == null) {
                return null;
            }
            Object sdp = doc.getProperty("stream");
            if (sdp instanceof FileObject) {
                return (FileObject)sdp;
            }
            if (sdp instanceof DataObject) {
                return ((DataObject)sdp).getPrimaryFile();
            }
            return null;
        }

        private void invokeRefactoring(final JTextComponent component, final int position) {
            assert (component != null);
            FileObject cfgRoot = FileUtil.getConfigRoot();
            FileObject actionFo = cfgRoot.getFileObject(ClassEncapsulation.ACTION_PATH);
            if (actionFo == null) {
                LOG.warning("Move Inner to Outer action not found at: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance");
                return;
            }
            try {
                DataObject actionDobj = DataObject.find((FileObject)actionFo);
                InstanceCookie ic = (InstanceCookie)actionDobj.getLookup().lookup(InstanceCookie.class);
                if (ic == null) {
                    throw new IOException();
                }
                final Object instance = ic.instanceCreate();
                if (!(instance instanceof Action)) {
                    throw new IOException();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (position != -1) {
                            component.setCaretPosition(position);
                        }
                        ((Action)instance).actionPerformed(new ActionEvent(component, 0, null));
                    }
                });
            }
            catch (IOException ioe) {
                LOG.warning("Move Inner to Outer action is broken: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance");
                return;
            }
            catch (ClassNotFoundException cnf) {
                LOG.warning("Move Inner to Outer action is broken: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance");
                return;
            }
        }
    }
}

