/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class EqualsHint {
    private static final String ERASURE_PREFS_KEY = "eguals-hint-erasure";
    private static final boolean ERASURE_PREFS_DEFAULT = true;

    public static ErrorDescription arrayEquals(HintContext ctx) {
        TreePath arr = ctx.getVariables().get("$arr");
        TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(arr);
        if (tm == null || tm.getKind() != TypeKind.ARRAY) {
            return null;
        }
        String fixArraysDisplayName = NbBundle.getMessage(EqualsHint.class, (String)"FIX_ReplaceWithArraysEquals");
        Fix arrays = JavaFix.rewriteFix(ctx, fixArraysDisplayName, ctx.getPath(), "java.util.Arrays.equals($obj, $arr)", new String[0]);
        String fixInstanceDisplayName = NbBundle.getMessage(EqualsHint.class, (String)"FIX_ReplaceWithInstanceEquals");
        Fix instance = JavaFix.rewriteFix(ctx, fixInstanceDisplayName, ctx.getPath(), "$obj == $arr", new String[0]);
        String displayName = NbBundle.getMessage(EqualsHint.class, (String)"ERR_ARRAY_EQUALS");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, arrays, instance);
    }

    public static ErrorDescription incompatibleEquals(HintContext ctx) {
        boolean castable;
        TypeMirror thsType;
        TreePath ths = ctx.getVariables().get("$this");
        TreePath par = ctx.getVariables().get("$par");
        if (ths != null) {
            thsType = ctx.getInfo().getTrees().getTypeMirror(ths);
        } else {
            TreePath cls;
            for (cls = ctx.getPath(); cls != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)cls.getLeaf().getKind()); cls = cls.getParentPath()) {
            }
            if (cls == null) {
                return null;
            }
            thsType = ctx.getInfo().getTrees().getTypeMirror(cls);
            if (thsType == null || thsType.getKind() != TypeKind.DECLARED) {
                return null;
            }
        }
        TypeMirror parType = ctx.getInfo().getTrees().getTypeMirror(par);
        if (ctx.getPreferences().getBoolean(ERASURE_PREFS_KEY, true)) {
            Types types = ctx.getInfo().getTypes();
            thsType = types.erasure(thsType);
            parType = types.erasure(parType);
        }
        boolean bl = castable = ctx.getInfo().getTypeUtilities().isCastable(thsType, parType) || ctx.getInfo().getTypeUtilities().isCastable(parType, thsType);
        if (castable) {
            return null;
        }
        String displayName = NbBundle.getMessage(EqualsHint.class, (String)"ERR_INCOMPATIBLE_EQUALS");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, new Fix[0]);
    }

    public static final class CustomizerProviderImpl
    extends OneCheckboxCustomizerProvider {
        public CustomizerProviderImpl() {
            super(NbBundle.getMessage(EqualsHint.class, (String)"LBL_Customizer_IncompatibleEquals"), NbBundle.getMessage(EqualsHint.class, (String)"TP_Customizer_IncompatibleEquals"), EqualsHint.ERASURE_PREFS_KEY, true);
        }
    }
}

