/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ThisInAnonymous {
    private static final String THIS_KEYWORD = "this";
    private static final Set<ElementKind> LOCAL_CLASS_CONTAINERS = EnumSet.of(ElementKind.METHOD, ElementKind.CONSTRUCTOR);

    public static ErrorDescription hint(HintContext ctx) {
        TreePath thisVariable = ctx.getVariables().get("$this");
        if (thisVariable.getLeaf().getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)thisVariable.getLeaf()).getName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        TreePath anonClassTP = ThisInAnonymous.getParentClass(ctx.getPath());
        Element annonClass = ctx.getInfo().getTrees().getElement(anonClassTP);
        String key = ThisInAnonymous.getKey(annonClass);
        if (key != null) {
            Element parent = ctx.getInfo().getTrees().getElement(ThisInAnonymous.getParentClass(anonClassTP.getParentPath()));
            if (parent == null || !parent.getKind().isClass() && !parent.getKind().isInterface()) {
                return null;
            }
            FixImpl fix = new FixImpl(TreePathHandle.create((TreePath)thisVariable, (CompilationInfo)ctx.getInfo()), (ElementHandle<TypeElement>)ElementHandle.create((Element)((TypeElement)parent)), ctx.getInfo().getFileObject());
            String displayName = NbBundle.getMessage(ThisInAnonymous.class, (String)key);
            return ErrorDescriptionFactory.forName(ctx, thisVariable, displayName, fix);
        }
        return null;
    }

    private static TreePath getParentClass(TreePath tp) {
        while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        return tp;
    }

    private static String getKey(Element e) {
        ElementKind enclosingKind = e.getKind();
        if (enclosingKind == ElementKind.CLASS) {
            if (e.getSimpleName().length() == 0) {
                return "ERR_ThisInAnonymous";
            }
            if (LOCAL_CLASS_CONTAINERS.contains((Object)e.getEnclosingElement().getKind())) {
                return "ERR_ThisInAnonymousLocal";
            }
        }
        return null;
    }

    private static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private final TreePathHandle thisHandle;
        private final ElementHandle<TypeElement> parentClassElementHandle;
        private final FileObject file;

        public FixImpl(TreePathHandle thisHandle, ElementHandle<TypeElement> parentClassElementHandle, FileObject file) {
            this.thisHandle = thisHandle;
            this.parentClassElementHandle = parentClassElementHandle;
            this.file = file;
        }

        public String getText() {
            return NbBundle.getMessage(ThisInAnonymous.class, (String)"FIX_ThisInAnonymous");
        }

        public ChangeInfo implement() throws Exception {
            ModificationResult result = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            result.commit();
            return null;
        }

        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = this.thisHandle.resolve((CompilationInfo)wc);
            TypeElement parentClass = (TypeElement)this.parentClassElementHandle.resolve((CompilationInfo)wc);
            assert (tp != null);
            assert (parentClass != null);
            TreeMaker make = wc.getTreeMaker();
            wc.rewrite(tp.getLeaf(), (Tree)make.MemberSelect(make.QualIdent((Element)parentClass), (CharSequence)ThisInAnonymous.THIS_KEYWORD));
        }
    }
}

