/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SyncOnNonFinal
extends AbstractHint {
    public SyncOnNonFinal() {
        super(true, false, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(SyncOnNonFinal.class, (String)"DSC_SynchronizationOnNonFinalField");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.SYNCHRONIZED);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        if (!this.getTreeKinds().contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        ExpressionTree expression = ((SynchronizedTree)treePath.getLeaf()).getExpression();
        Element e = compilationInfo.getTrees().getElement(new TreePath(treePath, expression));
        if (e == null || e.getKind() != ElementKind.FIELD || e.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        int start = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), expression);
        int end = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), expression);
        String displayName = NbBundle.getMessage(SyncOnNonFinal.class, (String)"ERR_SynchronizationOnNonFinalField");
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)displayName, (FileObject)compilationInfo.getFileObject(), (int)start, (int)end));
    }

    @Override
    public String getId() {
        return SyncOnNonFinal.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(SyncOnNonFinal.class, (String)"DN_SynchronizationOnNonFinalField");
    }

    @Override
    public void cancel() {
    }
}

