/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class StaticImport
extends AbstractHint {
    private final AtomicBoolean cancel = new AtomicBoolean();

    public StaticImport() {
        super(false, false, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(StaticImport.class, (String)"DSC_StaticImport");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.MEMBER_SELECT);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        List<FixImpl> fixes;
        if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        this.cancel.set(false);
        TreePath mitp = treePath.getParentPath();
        if (mitp == null || mitp.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        List<? extends Tree> typeArgs = ((MethodInvocationTree)mitp.getLeaf()).getTypeArguments();
        if (typeArgs != null && !typeArgs.isEmpty()) {
            return null;
        }
        Element e = info.getTrees().getElement(treePath);
        if (e == null || !e.getModifiers().contains((Object)Modifier.STATIC) || e.getKind() != ElementKind.METHOD) {
            return null;
        }
        if (!StaticImport.supportsStaticImports(info)) {
            return null;
        }
        Element enclosingEl = e.getEnclosingElement();
        if (enclosingEl == null) {
            return null;
        }
        String sn = e.getSimpleName().toString();
        if (!StaticImport.isValidStaticMethod(info, ((Object)Utilities.getElementName((Element)enclosingEl, (boolean)true)).toString(), sn)) {
            Collection<String> fqns = this.guessCandidates(info, ((MemberSelectTree)treePath.getLeaf()).getExpression().toString(), sn);
            if (fqns.isEmpty()) {
                return null;
            }
            fixes = new ArrayList<FixImpl>();
            for (String fqn : fqns) {
                fixes.add(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)info), fqn, sn));
            }
        } else {
            String fqn;
            TreePath cc = StaticImport.getContainingClass(treePath);
            if (cc == null) {
                return null;
            }
            Element klass = info.getTrees().getElement(cc);
            if (klass.getKind() != ElementKind.CLASS) {
                return null;
            }
            fqn = null;
            String fqn1 = StaticImport.getMethodFqn(e);
            if (!StaticImport.isSubTypeOrInnerOfSubType(info, klass, enclosingEl) && !StaticImport.isStaticallyImported(info, fqn1)) {
                if (StaticImport.hasMethodNameClash(info, klass, sn) || StaticImport.hasStaticImportSimpleNameClash(info, sn)) {
                    return null;
                }
                fqn = fqn1;
            }
            fixes = Collections.singletonList(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)info), fqn, sn));
        }
        String desc = NbBundle.getMessage(StaticImport.class, (String)"ERR_StaticImport");
        int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), treePath.getLeaf());
        int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), treePath.getLeaf());
        ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)desc, fixes, (FileObject)info.getFileObject(), (int)start, (int)end);
        if (this.cancel.get()) {
            return null;
        }
        return Collections.singletonList(ed);
    }

    @Override
    public String getId() {
        return StaticImport.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(StaticImport.class, (String)"DN_StaticImport");
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    public static boolean supportsStaticImports(CompilationInfo info) {
        return info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
    }

    private static boolean hasMethodWithSimpleName(CompilationInfo info, Element element, final String sn) {
        Iterable members = info.getElementUtilities().getMembers(element.asType(), new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror type) {
                return e.getKind() == ElementKind.METHOD && e.getSimpleName().toString().equals(sn);
            }
        });
        return members.iterator().hasNext();
    }

    public static boolean hasStaticImportSimpleNameClash(CompilationInfo info, String simpleName) {
        for (ImportTree importTree : info.getCompilationUnit().getImports()) {
            if (!importTree.isStatic()) continue;
            String q = importTree.getQualifiedIdentifier().toString();
            if (q.endsWith(".*")) {
                TypeElement ie = info.getElements().getTypeElement(q.substring(0, q.length() - 2));
                if (ie == null) continue;
                for (Element element : ie.getEnclosedElements()) {
                    String sn1;
                    Set<Modifier> modifiers = element.getModifiers();
                    if (element.getKind() != ElementKind.METHOD || !modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !simpleName.equals(sn1 = element.getSimpleName().toString())) continue;
                    return true;
                }
                continue;
            }
            int endIndex = q.lastIndexOf(".");
            if (endIndex == -1 || endIndex >= q.length() - 1 || !q.substring(endIndex).equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubTypeOrInnerOfSubType(CompilationInfo info, Element t1, Element t2) {
        boolean isSubtype = info.getTypes().isSubtype(t1.asType(), t2.asType());
        boolean isInnerClass = t1.getEnclosingElement().getKind() == ElementKind.CLASS;
        return isSubtype || isInnerClass && info.getTypes().isSubtype(t1.getEnclosingElement().asType(), t2.asType());
    }

    public static boolean hasMethodNameClash(CompilationInfo info, Element klass, String simpleName) {
        assert (klass != null);
        assert (klass.getKind() == ElementKind.CLASS);
        if (StaticImport.hasMethodWithSimpleName(info, klass, simpleName)) {
            return true;
        }
        Element klassEnclosing = klass.getEnclosingElement();
        return klassEnclosing != null && klassEnclosing.getKind() == ElementKind.CLASS && StaticImport.hasMethodWithSimpleName(info, klassEnclosing, simpleName);
    }

    public static String getMethodFqn(Element e) {
        assert (e.getKind() == ElementKind.METHOD);
        return Utilities.getElementName((Element)e.getEnclosingElement(), (boolean)true) + "." + e.getSimpleName();
    }

    public static TreePath getContainingClass(TreePath tp) {
        while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        return tp;
    }

    private static boolean isStaticallyImported(CompilationInfo info, String fqn) {
        for (ImportTree importTree : info.getCompilationUnit().getImports()) {
            if (!importTree.isStatic()) continue;
            String q = importTree.getQualifiedIdentifier().toString();
            if (q.endsWith(".*") && fqn.startsWith(q.substring(0, q.length() - 1))) {
                return true;
            }
            if (!q.equals(fqn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidStaticMethod(CompilationInfo info, String fqn, String simpleName) {
        TypeElement ie = info.getElements().getTypeElement(fqn);
        if (ie == null) {
            return false;
        }
        for (Element element : ie.getEnclosedElements()) {
            String sn1;
            Set<Modifier> modifiers = element.getModifiers();
            if (element.getKind() != ElementKind.METHOD || !modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !simpleName.equals(sn1 = element.getSimpleName().toString())) continue;
            return true;
        }
        return false;
    }

    private Collection<String> guessCandidates(CompilationInfo info, String klass, String sn) {
        Logger.getLogger(StaticImport.class.getName()).log(Level.FINE, "GUESS {0}.{1}", new Object[]{klass, sn});
        ComputeImports.Pair candidates = new ComputeImports().computeCandidates(info);
        HashSet<String> fqns = new HashSet<String>();
        if (candidates == null || candidates.a == null) {
            return fqns;
        }
        for (String k : ((Map)candidates.a).keySet()) {
            if (!klass.equals(k)) continue;
            for (TypeElement klazz : (List)((Map)candidates.a).get(k)) {
                String klazzFqn = klazz.getQualifiedName().toString();
                String fqn = klazzFqn + "." + sn;
                System.out.println(fqn);
                if (fqns.contains(fqn) || !StaticImport.isValidStaticMethod(info, klazzFqn, sn)) continue;
                fqns.add(fqn);
            }
        }
        return fqns;
    }

    public static final class FixImpl
    implements EnhancedFix,
    Task<WorkingCopy> {
        private final TreePathHandle handle;
        private final String fqn;
        private final String sn;

        public FixImpl(TreePathHandle handle, String fqn, String sn) {
            this.handle = handle;
            this.fqn = fqn;
            this.sn = sn;
        }

        public String getText() {
            if (this.fqn == null) {
                return NbBundle.getMessage(StaticImport.class, (String)"HINT_StaticImport", (Object)this.sn);
            }
            return NbBundle.getMessage(StaticImport.class, (String)"HINT_StaticImport2", (Object)this.fqn);
        }

        public ChangeInfo implement() throws Exception {
            JavaSource js = JavaSource.forFileObject((FileObject)this.handle.getFileObject());
            js.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy copy) throws Exception {
            if (copy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            TreePath treePath = this.handle.resolve((CompilationInfo)copy);
            if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
                return;
            }
            TreePath mitp = treePath.getParentPath();
            if (mitp == null || mitp.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
                return;
            }
            Element e = copy.getTrees().getElement(treePath);
            if (e == null || !e.getModifiers().contains((Object)Modifier.STATIC)) {
                return;
            }
            TreeMaker make = copy.getTreeMaker();
            copy.rewrite(treePath.getLeaf(), (Tree)make.Identifier((CharSequence)this.sn));
            if (this.fqn == null) {
                return;
            }
            CompilationUnitTree cut = copy.getCompilationUnit();
            CompilationUnitTree nue = JavaFixAllImports.addImports((CompilationUnitTree)cut, Collections.singletonList(this.fqn), (TreeMaker)make, (boolean)true);
            copy.rewrite((Tree)cut, (Tree)nue);
        }

        public CharSequence getSortText() {
            return "\uffffa";
        }
    }
}

