/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MissingHashCode
extends AbstractHint {
    volatile transient boolean[] stop = new boolean[]{false};

    public MissingHashCode() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.CLASS);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = new boolean[1];
        Element clazz = compilationInfo.getTrees().getElement(treePath);
        if (clazz == null || !clazz.getKind().isClass()) {
            return null;
        }
        ExecutableElement[] ret = EqualsHashCodeGenerator.overridesHashCodeAndEquals((CompilationInfo)compilationInfo, (Element)clazz, (boolean[])this.stop);
        ExecutableElement warningToElement = null;
        String addHint = null;
        if (ret[0] == null && ret[1] != null) {
            addHint = "MSG_GenEquals";
            warningToElement = ret[1];
        }
        if (ret[1] == null && ret[0] != null) {
            addHint = "MSG_GenHashCode";
            warningToElement = ret[0];
        }
        if (addHint != null) {
            assert (warningToElement != null);
            TreePath warningTo = compilationInfo.getTrees().getPath(warningToElement);
            if (warningTo == null || warningTo.getLeaf().getKind() != Tree.Kind.METHOD) {
                return null;
            }
            List<FixImpl> fixes = Collections.singletonList(new FixImpl(addHint, TreePathHandle.create((Element)clazz, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
            int[] span = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)warningTo.getLeaf());
            if (span != null) {
                ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(MissingHashCode.class, (String)addHint), fixes, (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
                return Collections.singletonList(ed);
            }
        }
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"MSG_MissingHashCode");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"HINT_MissingHashCode");
    }

    @Override
    public void cancel() {
        this.stop[0] = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static final class FixImpl
    implements Fix,
    Runnable,
    Task<WorkingCopy> {
        private TreePathHandle handle;
        private FileObject file;
        private String msg;
        private boolean fieldFound;

        public FixImpl(String type, TreePathHandle handle, FileObject file) {
            this.handle = handle;
            this.file = file;
            this.msg = type;
        }

        public String getText() {
            return NbBundle.getMessage(MissingHashCode.class, (String)this.msg);
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult result = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            if (this.fieldFound) {
                EventQueue.invokeLater(this);
            } else {
                result.commit();
            }
            return null;
        }

        @Override
        public void run() {
            try {
                EditorCookie cook = (EditorCookie)DataObject.find((FileObject)this.file).getLookup().lookup(EditorCookie.class);
                JEditorPane[] arr = cook.getOpenedPanes();
                if (arr == null) {
                    return;
                }
                EqualsHashCodeGenerator.invokeEqualsHashCode((TreePathHandle)this.handle, (JTextComponent)arr[0]);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (Element element : this.handle.resolveElement((CompilationInfo)wc).getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                this.fieldFound = true;
                return;
            }
            EqualsHashCodeGenerator.generateEqualsAndHashCode((WorkingCopy)wc, (TreePath)this.handle.resolve((CompilationInfo)wc));
        }

        public String toString() {
            return "Fix";
        }
    }
}

