/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class LoggerNotStaticFinal {
    public static ErrorDescription checkLoggerDeclaration(HintContext ctx) {
        Element e = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (!(e.getEnclosingElement().getKind() != ElementKind.CLASS || e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.FINAL))) {
            return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(LoggerNotStaticFinal.class, (String)"MSG_LoggerNotStaticFinal_checkLoggerDeclaration", (Object)e), new LoggerNotStaticFinalFix(NbBundle.getMessage(LoggerNotStaticFinal.class, (String)"MSG_LoggerNotStaticFinal_checkLoggerDeclaration_fix", (Object)e), TreePathHandle.create((Element)e, (CompilationInfo)ctx.getInfo())), FixFactory.createSuppressWarningsFix(ctx.getInfo(), ctx.getPath(), "NonConstantLogger"));
        }
        return null;
    }

    private static final class LoggerNotStaticFinalFix
    implements Fix {
        private final String text;
        private final TreePathHandle loggerFieldHandle;

        public LoggerNotStaticFinalFix(String text, TreePathHandle loggerFieldHandle) {
            this.text = text;
            this.loggerFieldHandle = loggerFieldHandle;
        }

        public String getText() {
            return this.text;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.loggerFieldHandle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath tp = LoggerNotStaticFinalFix.this.loggerFieldHandle.resolve((CompilationInfo)wc);
                    if (tp == null) {
                        return;
                    }
                    VariableTree vt = (VariableTree)tp.getLeaf();
                    ModifiersTree mt = vt.getModifiers();
                    EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
                    modifiers.addAll(mt.getFlags());
                    modifiers.add(Modifier.FINAL);
                    modifiers.add(Modifier.STATIC);
                    ModifiersTree newMod = wc.getTreeMaker().Modifiers(modifiers, mt.getAnnotations());
                    wc.rewrite((Tree)mt, (Tree)newMod);
                }
            }).commit();
            return null;
        }
    }
}

