/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;

public class ArithmeticUtilities {
    public static Number compute(CompilationInfo info, TreePath tp, boolean resolveCompileTimeConstants) {
        return new VisitorImpl(info, resolveCompileTimeConstants).scan(tp, null);
    }

    private static final class VisitorImpl
    extends TreePathScanner<Number, Void> {
        private static final Set<Tree.Kind> ACCEPTED_KINDS = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.PARENTHESIZED, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL});
        private final CompilationInfo info;
        private final boolean resolveCompileTimeConstants;

        public VisitorImpl(CompilationInfo info, boolean resolveCompileTimeConstants) {
            this.info = info;
            this.resolveCompileTimeConstants = resolveCompileTimeConstants;
        }

        @Override
        public Number scan(TreePath tree, Void p) {
            if (!ACCEPTED_KINDS.contains((Object)tree.getLeaf().getKind())) {
                return null;
            }
            return (Number)super.scan(tree, p);
        }

        @Override
        public Number scan(Tree tree, Void p) {
            if (tree == null) {
                return null;
            }
            if (!ACCEPTED_KINDS.contains((Object)tree.getKind())) {
                return null;
            }
            return (Number)super.scan(tree, p);
        }

        @Override
        public Number visitLiteral(LiteralTree node, Void p) {
            if (node.getValue() instanceof Number) {
                return (Number)node.getValue();
            }
            return (Number)super.visitLiteral(node, p);
        }

        @Override
        public Number visitIdentifier(IdentifierTree node, Void p) {
            return this.resolve();
        }

        @Override
        public Number visitMemberSelect(MemberSelectTree node, Void p) {
            return this.resolve();
        }

        private Number resolve() {
            if (!this.resolveCompileTimeConstants) {
                return null;
            }
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el == null || el.getKind() != ElementKind.FIELD) {
                return null;
            }
            Object obj = ((VariableElement)el).getConstantValue();
            if (!(obj instanceof Number)) {
                return null;
            }
            return (Number)obj;
        }

        @Override
        public Number visitBinary(BinaryTree node, Void p) {
            Number left = this.scan((Tree)node.getLeftOperand(), p);
            Number right = this.scan((Tree)node.getRightOperand(), p);
            if (left != null && right != null) {
                Number result = null;
                switch (node.getKind()) {
                    case MULTIPLY: {
                        if (left instanceof Double || right instanceof Double) {
                            result = left.doubleValue() * right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(left.floatValue() * right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() * right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() * right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case DIVIDE: {
                        if (left instanceof Double || right instanceof Double) {
                            result = left.doubleValue() / right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(left.floatValue() / right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() / right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() / right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case REMAINDER: {
                        if (left instanceof Double || right instanceof Double) {
                            result = left.doubleValue() % right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(left.floatValue() % right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() % right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() % right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case PLUS: {
                        if (left instanceof Double || right instanceof Double) {
                            result = left.doubleValue() + right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(left.floatValue() + right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() + right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() + right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case MINUS: {
                        if (left instanceof Double || right instanceof Double) {
                            result = left.doubleValue() - right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(left.floatValue() - right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() - right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() - right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case LEFT_SHIFT: {
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() << (int)right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() << right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case RIGHT_SHIFT: {
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() >> (int)right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() >> right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case UNSIGNED_RIGHT_SHIFT: {
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() >>> (int)right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() >>> right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case AND: {
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() & right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() & right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case XOR: {
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() ^ right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() ^ right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case OR: {
                        if (left instanceof Long || right instanceof Long) {
                            result = left.longValue() | right.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(left) || VisitorImpl.integerLike(right)) {
                            result = left.intValue() | right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                }
                return result;
            }
            return null;
        }

        @Override
        public Number visitUnary(UnaryTree node, Void p) {
            Number op = this.scan((Tree)node.getExpression(), p);
            if (op != null) {
                Number result = null;
                switch (node.getKind()) {
                    case UNARY_MINUS: {
                        if (op instanceof Double) {
                            result = -op.doubleValue();
                            break;
                        }
                        if (op instanceof Float) {
                            result = Float.valueOf(-op.floatValue());
                            break;
                        }
                        if (op instanceof Long) {
                            result = -op.longValue();
                            break;
                        }
                        if (op instanceof Integer) {
                            result = -op.intValue();
                            break;
                        }
                        throw new IllegalStateException("op=" + op.getClass());
                    }
                    case UNARY_PLUS: {
                        result = op;
                    }
                }
                return result;
            }
            return (Number)super.visitUnary(node, p);
        }

        private static boolean integerLike(Number n) {
            return n instanceof Integer || n instanceof Short || n instanceof Byte;
        }
    }
}

