/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.ui;

import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;

public class JavaEePlatformUiSupport {
    private JavaEePlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String serverInstanceId) {
        return new JavaEePlatformComboBoxModel(serverInstanceId);
    }

    public static String getServerInstanceID(Object j2eePlatformModelObject) {
        String retVal = null;
        if (j2eePlatformModelObject != null) {
            J2eePlatform j2eePlatform = ((JavaEePlatformAdapter)j2eePlatformModelObject).getJ2eePlatform();
            String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
            for (int i = 0; retVal == null && i < serverInstanceIDs.length; ++i) {
                J2eePlatform platform = null;
                try {
                    platform = Deployment.getDefault().getServerInstance(serverInstanceIDs[i]).getJ2eePlatform();
                }
                catch (InstanceRemovedException ex) {
                    Logger.getLogger("global").log(Level.INFO, serverInstanceIDs[i], ex);
                }
                if (platform == null || !platform.getDisplayName().equals(j2eePlatform.getDisplayName())) continue;
                retVal = serverInstanceIDs[i];
            }
        }
        return retVal;
    }

    public static Object getServerInstanceID(String id) {
        JavaEePlatformAdapter retVal = null;
        if (null != id) {
            JavaEePlatformComboBoxModel jeepcbm = new JavaEePlatformComboBoxModel(null);
            JavaEePlatformAdapter[] jeepas = jeepcbm.getJavaEePlatforms();
            for (int i = 0; retVal == null && i < jeepas.length; ++i) {
                J2eePlatform platform = null;
                try {
                    platform = Deployment.getDefault().getServerInstance(id).getJ2eePlatform();
                }
                catch (InstanceRemovedException ex) {
                    Logger.getLogger("global").log(Level.INFO, id, ex);
                }
                if (platform == null || !platform.getDisplayName().equals(jeepas[i].getJ2eePlatform().getDisplayName())) continue;
                retVal = jeepas[i];
            }
        }
        return retVal;
    }

    public static boolean getJ2eePlatformAndSpecVersionMatch(Object j2eePlatformModelObject, Object j2eeSpecVersionModelObject) {
        if (!(j2eePlatformModelObject instanceof JavaEePlatformAdapter) || !(j2eeSpecVersionModelObject instanceof String)) {
            return false;
        }
        J2eePlatform j2eePlatform = ((JavaEePlatformAdapter)j2eePlatformModelObject).getJ2eePlatform();
        String specVersion = (String)j2eeSpecVersionModelObject;
        return j2eePlatform.getSupportedSpecVersions().contains(specVersion);
    }

    private static final class JavaEePlatformAdapter
    implements Comparable {
        private J2eePlatform platform;

        public JavaEePlatformAdapter(J2eePlatform platform) {
            this.platform = platform;
        }

        public J2eePlatform getJ2eePlatform() {
            return this.platform;
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public int compareTo(Object o) {
            JavaEePlatformAdapter oa = (JavaEePlatformAdapter)o;
            return this.toString().compareTo(oa.toString());
        }
    }

    private static final class JavaEePlatformComboBoxModel
    implements ListModel,
    ComboBoxModel {
        private JavaEePlatformAdapter[] j2eePlatforms;
        private String initialJ2eePlatform;
        private JavaEePlatformAdapter selectedJ2eePlatform;

        public JavaEePlatformComboBoxModel(String serverInstanceID) {
            this.initialJ2eePlatform = serverInstanceID;
            this.getJavaEePlatforms();
        }

        @Override
        public Object getElementAt(int index) {
            return this.getJavaEePlatforms()[index];
        }

        @Override
        public int getSize() {
            return this.getJavaEePlatforms().length;
        }

        @Override
        public synchronized Object getSelectedItem() {
            return this.selectedJ2eePlatform;
        }

        @Override
        public synchronized void setSelectedItem(Object obj) {
            this.selectedJ2eePlatform = (JavaEePlatformAdapter)obj;
        }

        private synchronized JavaEePlatformAdapter[] getJavaEePlatforms() {
            if (this.j2eePlatforms == null) {
                String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
                TreeSet<JavaEePlatformAdapter> orderedNames = new TreeSet<JavaEePlatformAdapter>();
                boolean activeFound = false;
                JavaEePlatformAdapter firstAdapter = null;
                boolean sjasFound = false;
                for (int i = 0; i < serverInstanceIDs.length; ++i) {
                    J2eePlatform j2eePlatform = null;
                    try {
                        j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceIDs[i]).getJ2eePlatform();
                    }
                    catch (InstanceRemovedException ex) {
                        Logger.getLogger("global").log(Level.INFO, serverInstanceIDs[i], ex);
                    }
                    if (j2eePlatform == null) continue;
                    JavaEePlatformAdapter adapter = new JavaEePlatformAdapter(j2eePlatform);
                    orderedNames.add(adapter);
                    if (this.selectedJ2eePlatform == null && !activeFound && this.initialJ2eePlatform != null && serverInstanceIDs[i].equals(this.initialJ2eePlatform)) {
                        this.selectedJ2eePlatform = adapter;
                        activeFound = true;
                    }
                    if (firstAdapter != null && sjasFound || !j2eePlatform.getSupportedProfiles().contains(Profile.JAVA_EE_5) || !j2eePlatform.getSupportedTypes().contains(J2eeModule.Type.EJB)) continue;
                    String shortName = null;
                    try {
                        shortName = Deployment.getDefault().getServerInstance(serverInstanceIDs[i]).getServerID();
                    }
                    catch (InstanceRemovedException ex) {
                        Logger.getLogger("global").log(Level.INFO, serverInstanceIDs[i], ex);
                    }
                    if ("J2EE".equals(shortName)) {
                        firstAdapter = adapter;
                        sjasFound = true;
                        continue;
                    }
                    if (!"JBoss4".equals(shortName)) continue;
                    firstAdapter = adapter;
                }
                if (this.selectedJ2eePlatform == null && null != firstAdapter) {
                    this.selectedJ2eePlatform = firstAdapter;
                }
                this.j2eePlatforms = orderedNames.toArray(new JavaEePlatformAdapter[orderedNames.size()]);
            }
            return this.j2eePlatforms;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

