/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemData;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataLoader;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class SVGPaletteItemDataObject
extends MultiDataObject {
    private final SVGPaletteItemData m_data;

    public SVGPaletteItemDataObject(FileObject pf, SVGPaletteItemDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        this.m_data = SVGPaletteItemData.get(pf);
    }

    public SVGPaletteItemData getData() {
        return this.m_data;
    }

    public File getReferencedFile() throws FileNotFoundException, IOException {
        return new File(this.m_data.getFilePath());
    }

    protected Node createNodeDelegate() {
        return new SVGPaletteItemDataNode(this, this.getLookup());
    }

    public Lookup getLookup() {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)new ActiveEditorDrop(){

            public boolean handleTransfer(JTextComponent target) {
                SVGDataObject dObj = SVGDataObject.getActiveDataObject(target);
                if (dObj != null) {
                    try {
                        File file = SVGPaletteItemDataObject.this.getReferencedFile();
                        if (file.exists() && file.isFile()) {
                            SceneManager.log(Level.INFO, "Dropping file " + file.getPath());
                            SVGPaletteItemDataObject.insertToTextComponent(dObj.getModel().getSVGBody(file, null), target);
                            return true;
                        }
                        SceneManager.log(Level.SEVERE, "Nothing to drop, file " + file + " not found");
                    }
                    catch (Exception ex) {
                        SceneManager.error("Error during image merge", ex);
                    }
                } else {
                    SceneManager.log(Level.INFO, "SVGDataObject not found.");
                }
                return false;
            }
        });
        ic.add((Object)this);
        return new AbstractLookup((AbstractLookup.Content)ic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertToTextComponent(final String text, final JTextComponent target) {
        final Document doc = target.getDocument();
        if (doc instanceof BaseDocument) {
            final Reformat formatter = Reformat.get((Document)doc);
            formatter.lock();
            try {
                final boolean[] ok = new boolean[]{false};
                ((BaseDocument)doc).runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Caret caret = target.getCaret();
                            int p0 = Math.min(caret.getDot(), caret.getMark());
                            int p1 = Math.max(caret.getDot(), caret.getMark());
                            doc.remove(p0, p1 - p0);
                            int start = caret.getDot();
                            doc.insertString(start, text, null);
                            int end = start + text.length();
                            formatter.reformat(start, end);
                            ok[0] = true;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                if (!ok[0]) {
                    ((BaseDocument)doc).atomicUndo();
                }
            }
            finally {
                formatter.unlock();
            }
        }
    }
}

