/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.converter.wizard.Converter;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;

public class ConverterUtil {
    static Boolean getBoolean(String value) {
        if (value == null) {
            return null;
        }
        value = ConverterUtil.decryptStringFromJavaCode(value);
        return "true".equalsIgnoreCase(value);
    }

    static Character getChar(String value) {
        return (value = ConverterUtil.decryptStringFromJavaCode(value)).length() > 0 ? Character.valueOf(value.charAt(0)) : null;
    }

    static Byte getByte(String value) {
        if (value == null) {
            return null;
        }
        value = ConverterUtil.decryptStringFromJavaCode(value);
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            Debug.warning((Object[])new Object[]{e});
            return null;
        }
    }

    static Short getShort(String value) {
        if (value == null) {
            return null;
        }
        value = ConverterUtil.decryptStringFromJavaCode(value);
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            Debug.warning((Object[])new Object[]{e});
            return null;
        }
    }

    static Integer getInteger(String value) {
        if (value == null) {
            return null;
        }
        value = ConverterUtil.decryptStringFromJavaCode(value);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Debug.warning((Object[])new Object[]{e});
            return null;
        }
    }

    static Long getLong(String value) {
        if (value == null) {
            return null;
        }
        value = ConverterUtil.decryptStringFromJavaCode(value);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Debug.warning((Object[])new Object[]{e});
            return null;
        }
    }

    static Float getFloat(String value) {
        if (value == null) {
            return null;
        }
        value = ConverterUtil.decryptStringFromJavaCode(value);
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            Debug.warning((Object[])new Object[]{e});
            return null;
        }
    }

    static Double getDouble(String value) {
        if (value == null) {
            return null;
        }
        value = ConverterUtil.decryptStringFromJavaCode(value);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            Debug.warning((Object[])new Object[]{e});
            return null;
        }
    }

    static PropertyValue getStringWithUserCode(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("CODE:")) {
            return PropertyValue.createUserCode((String)ConverterUtil.decryptStringFromJavaCode(value.substring(5)));
        }
        if (value.startsWith("STRING:")) {
            return MidpTypes.createStringValue((String)ConverterUtil.decryptStringFromJavaCode(value.substring(7)));
        }
        Debug.warning((Object[])new Object[]{"Invalid string code value", value});
        return null;
    }

    public static String decryptStringFromJavaCode(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        block11: while (i < len) {
            char c = value.charAt(i);
            ++i;
            if (c != '\\') {
                sb.append(c);
                continue;
            }
            c = value.charAt(i);
            ++i;
            switch (c) {
                case 'r': {
                    sb.append('\r');
                    continue block11;
                }
                case 'n': {
                    sb.append('\n');
                    continue block11;
                }
                case 't': {
                    sb.append('\t');
                    continue block11;
                }
                case 'u': {
                    if (i + 4 > len) {
                        Debug.warning((Object[])new Object[]{"Invalid hex number at the end", value.substring(i)});
                        continue block11;
                    }
                    try {
                        sb.append((char)Integer.parseInt(value.substring(i, i + 4), 16));
                    }
                    catch (NumberFormatException e) {
                        Debug.warning((Object[])new Object[]{"Invalid hex number format", value.substring(i, i + 4)});
                    }
                    i += 4;
                    continue block11;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append(c);
                    continue block11;
                }
            }
            if (c < '0' || c > '9') {
                Debug.warning((Object[])new Object[]{"Invalid character after slash", Character.valueOf(c)});
                continue;
            }
            if (--i + 3 > len) {
                Debug.warning((Object[])new Object[]{"Invalid octal number at the end: ", value.substring(i)});
                continue;
            }
            try {
                sb.append((char)Integer.parseInt(value.substring(i, i + 3), 8));
            }
            catch (NumberFormatException e) {
                Debug.warning((Object[])new Object[]{"Invalid octal number format", value.substring(i, i + 3)});
            }
            i += 3;
        }
        return sb.toString();
    }

    static PropertyValue decryptStringArrayArray(String value, TypeID type, int dimension) {
        char c;
        if (value == null) {
            return PropertyValue.createNull();
        }
        if (dimension <= 0) {
            return MidpTypes.createStringValue((String)value);
        }
        type = type.getComponentType();
        int pos = 0;
        int number = 0;
        while (Character.isDigit(c = ConverterUtil.lookCharAhead(value, pos++))) {
            number = number * 10 + (c - 48);
        }
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        for (int i = 0; i < number; ++i) {
            String valuePart = null;
            if (Character.isDigit(ConverterUtil.lookCharAhead(value, pos))) {
                char c2;
                int number2 = 0;
                while (Character.isDigit(c2 = ConverterUtil.lookCharAhead(value, pos++))) {
                    number2 = number2 * 10 + (c2 - 48);
                }
                valuePart = value.substring(pos, pos + number2);
                pos += number2 + 1;
            } else {
                ++pos;
            }
            values.add(ConverterUtil.decryptStringArrayArray(valuePart, type, dimension - 1));
        }
        return PropertyValue.createArray((TypeID)type, values);
    }

    private static char lookCharAhead(String string, int pos) {
        return pos < string.length() ? string.charAt(pos) : (char)'\u0000';
    }

    static void convertStringWithUserCode(DesignComponent component, String propertyName, String value) {
        PropertyValue propertyValue = ConverterUtil.getStringWithUserCode(value);
        if (propertyValue != null) {
            component.writeProperty(propertyName, propertyValue);
        }
    }

    static void convertByte(DesignComponent component, String propertyName, String value) {
        Byte b = ConverterUtil.getByte(value);
        if (b != null) {
            component.writeProperty(propertyName, MidpTypes.createByteValue((byte)b));
        }
    }

    static void convertShort(DesignComponent component, String propertyName, String value) {
        Short s = ConverterUtil.getShort(value);
        if (s != null) {
            component.writeProperty(propertyName, MidpTypes.createShortValue((short)s));
        }
    }

    static void convertInteger(DesignComponent component, String propertyName, String value) {
        Integer integer = ConverterUtil.getInteger(value);
        if (integer != null) {
            component.writeProperty(propertyName, MidpTypes.createIntegerValue((int)integer));
        }
    }

    static void convertLong(DesignComponent component, String propertyName, String value) {
        Long l = ConverterUtil.getLong(value);
        if (l != null) {
            component.writeProperty(propertyName, MidpTypes.createLongValue((long)l));
        }
    }

    static void convertFloat(DesignComponent component, String propertyName, String value) {
        Float fl = ConverterUtil.getFloat(value);
        if (fl != null) {
            component.writeProperty(propertyName, MidpTypes.createFloatValue((float)fl.floatValue()));
        }
    }

    static void convertDouble(DesignComponent component, String propertyName, String value) {
        Double d = ConverterUtil.getDouble(value);
        if (d != null) {
            component.writeProperty(propertyName, MidpTypes.createDoubleValue((double)d));
        }
    }

    static void convertChar(DesignComponent component, String propertyName, String value) {
        Character ch = ConverterUtil.getChar(value);
        if (ch != null) {
            component.writeProperty(propertyName, MidpTypes.createCharValue((char)ch.charValue()));
        }
    }

    static void convertString(DesignComponent component, String propertyName, String value) {
        if ((value = ConverterUtil.decryptStringFromJavaCode(value)) != null) {
            component.writeProperty(propertyName, MidpTypes.createStringValue((String)value));
        }
    }

    static void convertBoolean(DesignComponent component, String propertyName, String value) {
        Boolean bool = ConverterUtil.getBoolean(value);
        if (bool != null) {
            component.writeProperty(propertyName, MidpTypes.createBooleanValue((boolean)bool));
        }
    }

    static void convertConverterItemComponent(DesignComponent component, String propertyName, HashMap<String, ConverterItem> id2item, String value) {
        DesignComponent ref = Converter.convertConverterItemComponent(id2item, value, component.getDocument());
        if (ref != null) {
            component.writeProperty(propertyName, PropertyValue.createComponentReference((DesignComponent)ref));
        }
    }

    static void convertToPropertyValue(DesignComponent component, String propertyName, TypeID propertyType, String value) {
        if (MidpTypes.TYPEID_BOOLEAN.equals((Object)propertyType)) {
            ConverterUtil.convertBoolean(component, propertyName, value);
        } else if (MidpTypes.TYPEID_BYTE.equals((Object)propertyType)) {
            ConverterUtil.convertByte(component, propertyName, value);
        } else if (MidpTypes.TYPEID_CHAR.equals((Object)propertyType)) {
            component.writeProperty(propertyName, MidpTypes.createCharValue((char)value.charAt(0)));
        } else if (MidpTypes.TYPEID_DOUBLE.equals((Object)propertyType)) {
            ConverterUtil.convertDouble(component, propertyName, value);
        } else if (MidpTypes.TYPEID_FLOAT.equals((Object)propertyType)) {
            ConverterUtil.convertFloat(component, propertyName, value);
        } else if (MidpTypes.TYPEID_INT.equals((Object)propertyType)) {
            ConverterUtil.convertInteger(component, propertyName, value);
        } else if (MidpTypes.TYPEID_JAVA_CODE.equals((Object)propertyType)) {
            if (value != null) {
                component.writeProperty(propertyName, MidpTypes.createJavaCodeValue((String)value));
            }
        } else if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)propertyType)) {
            ConverterUtil.convertString(component, propertyName, value);
        } else if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)propertyType)) {
            ConverterUtil.convertString(component, propertyName, value);
        } else if (MidpTypes.TYPEID_LONG.equals((Object)propertyType)) {
            ConverterUtil.convertLong(component, propertyName, value);
        } else if (MidpTypes.TYPEID_SHORT.equals((Object)propertyType)) {
            ConverterUtil.convertShort(component, propertyName, value);
        }
    }
}

