/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.components.commands.CommandCD;
import org.netbeans.modules.vmd.midp.components.resources.FontCD;
import org.netbeans.modules.vmd.midp.components.resources.ImageCD;
import org.netbeans.modules.vmd.midp.components.resources.TickerCD;
import org.netbeans.modules.vmd.midp.converter.wizard.Converter;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterUtil;

public class ConverterResources {
    static void convertFont(ConverterItem item, DesignDocument document) {
        DesignComponent font = document.createComponent(FontCD.TYPEID);
        Converter.convertClass(item, font);
        MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)ResourcesCategoryCD.TYPEID).addComponent(font);
        String specifier = item.getPropertyValue("specifier");
        if ("FONT_INPUT_TEXT".equals(specifier)) {
            font.writeProperty("fontKind", MidpTypes.createIntegerValue((int)3));
        } else if ("FONT_STATIC_TEXT".equals(specifier)) {
            font.writeProperty("fontKind", MidpTypes.createIntegerValue((int)2));
        } else {
            ConverterUtil.convertInteger(font, "style", item.getPropertyValue("style"));
            String face = item.getPropertyValue("face");
            if ("FACE_MONOSPACE".equals(face)) {
                font.writeProperty("face", MidpTypes.createIntegerValue((int)32));
            } else if ("FACE_PROPORTIONAL".equals(face)) {
                font.writeProperty("face", MidpTypes.createIntegerValue((int)64));
            } else if ("FACE_SYSTEM".equals(face)) {
                font.writeProperty("face", MidpTypes.createIntegerValue((int)0));
            }
            String size = item.getPropertyValue("size");
            if ("SIZE_SMALL".equals(size)) {
                font.writeProperty("bold", MidpTypes.createIntegerValue((int)8));
            } else if ("SIZE_MEDIUM".equals(size)) {
                font.writeProperty("bold", MidpTypes.createIntegerValue((int)0));
            } else if ("SIZE_LARGE".equals(size)) {
                font.writeProperty("bold", MidpTypes.createIntegerValue((int)16));
            }
            boolean nonDefault = item.isPropertyValueSet("style") || item.isPropertyValueSet("face") || item.isPropertyValueSet("size");
            font.writeProperty("fontKind", MidpTypes.createIntegerValue((int)(nonDefault ? 2 : 0)));
        }
    }

    static void convertImage(ConverterItem item, DesignDocument document) {
        DesignComponent image = document.createComponent(ImageCD.TYPEID);
        Converter.convertClass(item, image);
        MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)ResourcesCategoryCD.TYPEID).addComponent(image);
        ConverterUtil.convertString(image, "resourcePath", item.getPropertyValue("imageResourcePath"));
    }

    static void convertTicker(ConverterItem item, DesignDocument document) {
        DesignComponent ticker = document.createComponent(TickerCD.TYPEID);
        Converter.convertClass(item, ticker);
        MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)ResourcesCategoryCD.TYPEID).addComponent(ticker);
        ConverterUtil.convertStringWithUserCode(ticker, "string", item.getPropertyValue("string"));
    }

    static void convertCommand(ConverterItem item, DesignDocument document) {
        DesignComponent command = document.createComponent(CommandCD.TYPEID);
        Converter.convertClass(item, command);
        MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)CommandsCategoryCD.TYPEID).addComponent(command);
        ConverterUtil.convertStringWithUserCode(command, "label", item.getPropertyValue("label"));
        ConverterUtil.convertStringWithUserCode(command, "longLabel", item.getPropertyValue("longLabel"));
        ConverterUtil.convertInteger(command, "priority", item.getPropertyValue("priority"));
        String typeValue = item.getPropertyValue("type");
        int type = "SCREEN".equals(typeValue) ? 1 : ("BACK".equals(typeValue) ? 2 : ("CANCEL".equals(typeValue) ? 3 : ("OK".equals(typeValue) ? 4 : ("HELP".equals(typeValue) ? 5 : ("STOP".equals(typeValue) ? 6 : ("EXIT".equals(typeValue) ? 7 : ("ITEM".equals(typeValue) ? 8 : 4)))))));
        command.writeProperty("type", MidpTypes.createIntegerValue((int)type));
    }
}

