/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.support.ArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.DisplayablesCategoryCD;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.components.displayables.FormCD;
import org.netbeans.modules.vmd.midp.components.displayables.ListCD;
import org.netbeans.modules.vmd.midp.components.displayables.TextBoxCD;
import org.netbeans.modules.vmd.midp.components.sources.CommandEventSourceCD;
import org.netbeans.modules.vmd.midp.components.sources.ListSelectCommandEventSourceCD;
import org.netbeans.modules.vmd.midp.converter.wizard.Converter;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterActions;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterUtil;

public class ConverterDisplayables {
    static void convertDisplayable(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent displayable) {
        ArrayList<String> commandsList;
        DesignComponent ticker;
        Converter.convertClass(item, displayable);
        DesignDocument document = displayable.getDocument();
        MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)DisplayablesCategoryCD.TYPEID).addComponent(displayable);
        ConverterUtil.convertStringWithUserCode(displayable, "title", item.getPropertyValue("title"));
        ConverterItem tickerItem = Converter.convertConverterItem(id2item, item.getPropertyValue("ticker"), document);
        if (tickerItem != null && (ticker = tickerItem.getRelatedComponent()) != null) {
            displayable.writeProperty("ticker", PropertyValue.createComponentReference((DesignComponent)ticker));
        }
        if ((commandsList = item.getContainerPropertyValue("commands")) != null) {
            for (String commandValue : commandsList) {
                ConverterItem commandActionItem = id2item.get(commandValue);
                if (commandActionItem == null) continue;
                ConverterActions.convertCommandAction(id2item, commandActionItem, document);
                DesignComponent eventSource = commandActionItem.getRelatedComponent();
                if (eventSource != null) {
                    MidpDocumentSupport.addEventSource((DesignComponent)displayable, (String)"commands", (DesignComponent)eventSource);
                    eventSource.writeProperty("displayable", PropertyValue.createComponentReference((DesignComponent)displayable));
                    continue;
                }
                Debug.warning((Object[])new Object[]{"Unrecognized command", item, commandValue});
            }
        }
    }

    static void convertScreen(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent screen) {
        ConverterDisplayables.convertDisplayable(id2item, item, screen);
    }

    static void convertForm(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterDisplayables.convertFormCore(id2item, item, document.createComponent(FormCD.TYPEID));
    }

    static void convertFormCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent form) {
        ConverterDisplayables.convertScreen(id2item, item, form);
        ArrayList<String> itemsList = item.getContainerPropertyValue("items");
        if (itemsList != null) {
            for (String itemValue : itemsList) {
                DesignComponent itemComponent = Converter.convertConverterItemComponent(id2item, itemValue, form.getDocument());
                if (itemComponent == null) continue;
                form.addComponent(itemComponent);
                ArraySupport.append((DesignComponent)form, (String)"items", (DesignComponent)itemComponent);
            }
        }
    }

    static void convertTextBox(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterDisplayables.convertTextBoxCore(id2item, item, document.createComponent(TextBoxCD.TYPEID));
    }

    static void convertTextBoxCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent textbox) {
        ConverterDisplayables.convertScreen(id2item, item, textbox);
        ConverterUtil.convertStringWithUserCode(textbox, "string", item.getPropertyValue("string"));
        ConverterUtil.convertInteger(textbox, "maxSize", item.getPropertyValue("maxSize"));
        ConverterUtil.convertString(textbox, "initialInputMode", item.getPropertyValue("initialInputMode"));
        ConverterUtil.convertInteger(textbox, "constraints", item.getPropertyValue("constraints"));
    }

    static void convertList(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ComponentProducer producer = DocumentSupport.getComponentProducer((DesignDocument)document, (String)ListCD.TYPEID.toString());
        DesignComponent list = producer.createComponent(document).getMainComponent();
        ConverterDisplayables.convertListCore(id2item, item, list);
    }

    static void convertListCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent list) {
        String choiceTypeValue;
        ConverterDisplayables.convertScreen(id2item, item, list);
        ConverterItem selectCommandActionItem = id2item.get(item.getPropertyValue("selectCommandAction"));
        List selectCommandEventSourceComponents = DocumentSupport.gatherSubComponentsOfType((DesignComponent)list, (TypeID)ListSelectCommandEventSourceCD.TYPEID);
        DesignComponent selectCommandEventSource = (DesignComponent)selectCommandEventSourceComponents.get(0);
        Converter.convertObject(selectCommandActionItem, selectCommandEventSource);
        ConverterActions.convertCommandActionHandler(id2item, selectCommandActionItem, selectCommandEventSource);
        if (item.isPropertyValueSet("selectCommand")) {
            DesignComponent selectCommand = Converter.convertConverterItemComponent(id2item, item.getPropertyValue("selectCommand"), list.getDocument());
            if (selectCommand != null) {
                List commandEventSources = DocumentSupport.gatherSubComponentsOfType((DesignComponent)list, (TypeID)CommandEventSourceCD.TYPEID);
                boolean found = false;
                for (DesignComponent commandEventSource : commandEventSources) {
                    DesignComponent foundCommand = commandEventSource.readProperty("command").getComponent();
                    if (selectCommand != foundCommand) continue;
                    found = true;
                    list.writeProperty("selectCommand", PropertyValue.createComponentReference((DesignComponent)commandEventSource));
                    break;
                }
                if (!found) {
                    Debug.warning((Object[])new Object[]{"selectCommand not found for", item});
                }
            } else {
                list.writeProperty("selectCommand", PropertyValue.createNull());
            }
        }
        if ("EXCLUSIVE".equals(choiceTypeValue = item.getPropertyValue("choiceType"))) {
            list.writeProperty("listType", MidpTypes.createIntegerValue((int)1));
        } else if ("IMPLICIT".equals(choiceTypeValue)) {
            list.writeProperty("listType", MidpTypes.createIntegerValue((int)3));
        } else if ("MULTIPLE".equals(choiceTypeValue)) {
            list.writeProperty("listType", MidpTypes.createIntegerValue((int)2));
        }
        String fitPolicyValue = item.getPropertyValue("fitPolicy");
        if ("TEXT_WRAP_DEFAULT".equals(fitPolicyValue)) {
            list.writeProperty("fitPolicy", MidpTypes.createIntegerValue((int)0));
        } else if ("TEXT_WRAP_OFF".equals(fitPolicyValue)) {
            list.writeProperty("fitPolicy", MidpTypes.createIntegerValue((int)2));
        } else if ("TEXT_WRAP_ON".equals(fitPolicyValue)) {
            list.writeProperty("fitPolicy", MidpTypes.createIntegerValue((int)1));
        }
        ArrayList<String> elementsList = item.getContainerPropertyValue("elements");
        if (elementsList != null) {
            for (String elementValue : elementsList) {
                DesignComponent listElement = Converter.convertConverterItemComponent(id2item, elementValue, list.getDocument());
                if (listElement == null) {
                    Debug.warning((Object[])new Object[]{"ListElement not found", elementValue});
                    continue;
                }
                list.addComponent(listElement);
                ArraySupport.append((DesignComponent)list, (String)"elements", (DesignComponent)listElement);
            }
        }
        ConverterUtil.convertBoolean(list, "indexBasedSwitch", item.getPropertyValue("indexBasedSwitch"));
    }

    static void convertAlert(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterDisplayables.convertAlertCore(id2item, item, document.createComponent(AlertCD.TYPEID));
    }

    static void convertAlertCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent alert) {
        String type;
        ConverterDisplayables.convertScreen(id2item, item, alert);
        ConverterUtil.convertStringWithUserCode(alert, "string", item.getPropertyValue("string"));
        ConverterUtil.convertInteger(alert, "timeout", item.getPropertyValue("timeout"));
        DesignComponent image = Converter.convertConverterItemComponent(id2item, item.getPropertyValue("image"), alert.getDocument());
        if (image != null) {
            alert.writeProperty("image", PropertyValue.createComponentReference((DesignComponent)image));
        }
        if ("ALERT".equals(type = item.getPropertyValue("type"))) {
            alert.writeProperty("type", MidpTypes.createAlertTypeValue((MidpTypes.AlertType)MidpTypes.AlertType.ALARM));
        } else if ("CONFIRMATION".equals(type)) {
            alert.writeProperty("type", MidpTypes.createAlertTypeValue((MidpTypes.AlertType)MidpTypes.AlertType.CONFIRMATION));
        } else if ("ERROR".equals(type)) {
            alert.writeProperty("type", MidpTypes.createAlertTypeValue((MidpTypes.AlertType)MidpTypes.AlertType.ERROR));
        } else if ("INFO".equals(type)) {
            alert.writeProperty("type", MidpTypes.createAlertTypeValue((MidpTypes.AlertType)MidpTypes.AlertType.INFO));
        } else if ("WARNING".equals(type)) {
            alert.writeProperty("type", MidpTypes.createAlertTypeValue((MidpTypes.AlertType)MidpTypes.AlertType.WARNING));
        }
        DesignComponent indicator = Converter.convertConverterItemComponent(id2item, item.getPropertyValue("indicator"), alert.getDocument());
        if (indicator != null) {
            alert.addComponent(indicator);
            alert.writeProperty("indicator", PropertyValue.createComponentReference((DesignComponent)indicator));
        }
    }

    static void convertCanvas(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent canvas) {
        ConverterDisplayables.convertDisplayable(id2item, item, canvas);
        ConverterUtil.convertBoolean(canvas, "isFullScreen", item.getPropertyValue("fullScreen"));
    }
}

