/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.vmd.api.flow.FlowSupport;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.PointsCategoryCD;
import org.netbeans.modules.vmd.midp.components.points.MobileDeviceCD;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterActions;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterBuilt;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterCode;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterCustom;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterDisplayables;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterElements;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItems;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterResources;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterSVG;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterUtil;
import org.netbeans.modules.vmd.midp.converter.wizard.XMLUtil;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class Converter {
    public static ArrayList<String> convert(final FileObject inputJavaFile, FileObject inputDesignFile, String outputFileName) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            AntProjectHelper helper;
            DataFolder folder = DataFolder.findFolder((FileObject)inputJavaFile.getParent());
            DataObject input = DataObject.find((FileObject)inputJavaFile);
            EditorCookie editorCookie = (EditorCookie)input.getCookie(EditorCookie.class);
            final StyledDocument styledDocument = editorCookie.openDocument();
            Node rootNode = XMLUtil.getRootNode(inputDesignFile);
            if (!"1.3".equals(XMLUtil.getAttributeValue(rootNode, "version"))) {
                Debug.warning((Object[])new Object[]{NbBundle.getMessage(Converter.class, (String)"Convert.oldDesign.error")});
                errors.add(NbBundle.getMessage(Converter.class, (String)"Convert.oldDesign.error"));
                return errors;
            }
            final List<ConverterItem> items = Converter.getConverterItems(rootNode);
            DataObject template = DataObject.find((FileObject)FileUtil.getConfigFile((String)"Templates/MIDP/ConverterVisualMIDlet.java"));
            final DataObject outputDesign = template.createFromTemplate(folder, outputFileName);
            DocumentSerializer serializer = IOSupport.getDocumentSerializer((DataObject)outputDesign);
            serializer.waitDocumentLoaded();
            final DesignDocument document = serializer.getDocument();
            EditorCookie outputEditorCookie = (EditorCookie)outputDesign.getCookie(EditorCookie.class);
            final StyledDocument outputStyledDocument = outputEditorCookie.openDocument();
            ConverterCustom.loadItemsToRegistry(items, document);
            final HashMap<String, ConverterItem> id2item = new HashMap<String, ConverterItem>();
            for (ConverterItem item : items) {
                id2item.put(item.getID(), item);
            }
            document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    for (ConverterItem item : items) {
                        Converter.convert(id2item, item, document);
                    }
                    try {
                        ConverterCode.convertCode(items, styledDocument, outputStyledDocument, document, inputJavaFile.getName(), outputDesign.getPrimaryFile().getName());
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
            for (ConverterItem item : items) {
                if (item.isUsed()) continue;
                Debug.warning((Object[])new Object[]{"Unrecognized component: " + item.getTypeID()});
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    document.getTransactionManager().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            FlowScene scene = FlowSupport.getFlowSceneForDocument((DesignDocument)document);
                            for (FlowNodeDescriptor node : scene.getNodes()) {
                                Widget widget = scene.findWidget((Object)node);
                                if (widget == null) continue;
                                widget.setPreferredLocation(null);
                            }
                        }
                    });
                }
            });
            IOSupport.forceUpdateCode((DataObject)outputDesign);
            CloneableEditorSupport cloneableEditorSupport = IOSupport.getCloneableEditorSupport((DataObject)outputDesign);
            cloneableEditorSupport.saveDocument();
            cloneableEditorSupport.close();
            final String[] classNames = new String[2];
            JavaSource.forDocument((Document)styledDocument).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassTree classTree = ConverterCode.findMainClass(parameter);
                    TypeElement element = (TypeElement)parameter.getTrees().getElement(TreePath.getPath(parameter.getCompilationUnit(), (Tree)classTree));
                    classNames[0] = element.getQualifiedName().toString();
                }
            }, true);
            JavaSource.forDocument((Document)outputStyledDocument).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassTree classTree = ConverterCode.findMainClass(parameter);
                    TypeElement element = (TypeElement)parameter.getTrees().getElement(TreePath.getPath(parameter.getCompilationUnit(), (Tree)classTree));
                    classNames[1] = element.getQualifiedName().toString();
                }
            }, true);
            Project project = FileOwnerQuery.getOwner((FileObject)inputJavaFile);
            if (project != null && (helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class)) != null) {
                J2MEProjectGenerator.copyMIDletProperty((Project)project, (AntProjectHelper)helper, (String)classNames[0], (String)classNames[1]);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return errors;
    }

    private static List<ConverterItem> getConverterItems(Node rootNode) {
        ArrayList<ConverterItem> components = new ArrayList<ConverterItem>();
        Node documentNode = XMLUtil.getChild(rootNode, "DesignDocument");
        for (Node componentNode : XMLUtil.getChildren(documentNode, "DesignComponent")) {
            String typeid = XMLUtil.getAttributeValue(componentNode, "typeid");
            typeid = Converter.convertTypeIDFromString(typeid);
            ConverterItem item = new ConverterItem(XMLUtil.getAttributeValue(componentNode, "uid"), XMLUtil.getAttributeValue(componentNode, "id"), typeid);
            for (Node propertyNode : XMLUtil.getChildren(componentNode, "Property")) {
                item.addProperty(XMLUtil.getAttributeValue(propertyNode, "name"), XMLUtil.getAttributeValue(propertyNode, "value"));
            }
            for (Node containerPropertyNode : XMLUtil.getChildren(componentNode, "ContainerProperty")) {
                String name = XMLUtil.getAttributeValue(containerPropertyNode, "name");
                item.initContainerProperty(name);
                for (Node itemNode : XMLUtil.getChildren(containerPropertyNode, "ContainerPropertyItem")) {
                    item.addContainerPropertyItem(name, XMLUtil.getAttributeValue(itemNode, "value"));
                }
            }
            components.add(item);
        }
        return components;
    }

    private static String convertTypeIDFromString(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int dimension = 0;
        if (string.charAt(0) == '#') {
            int pos = 1;
            while (true) {
                char c;
                if (pos >= string.length()) {
                    dimension = 0;
                    break;
                }
                if ((c = string.charAt(pos++)) == '#') break;
                if (!Character.isDigit(c)) {
                    dimension = 0;
                    break;
                }
                dimension = dimension * 10 + (c - 48);
            }
            if (dimension > 0) {
                string = string.substring(pos);
            }
        }
        return (i = string.indexOf(58)) >= 0 ? string.substring(i + 1) : string;
    }

    private static void convert(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        if (item.isUsed()) {
            return;
        }
        String id = item.getID();
        String typeID = item.getTypeID();
        if ("javax.microedition.lcdui.Command".equals(typeID)) {
            ConverterResources.convertCommand(item, document);
        } else if ("javax.microedition.lcdui.Alert".equals(typeID)) {
            ConverterDisplayables.convertAlert(id2item, item, document);
        } else if ("javax.microedition.lcdui.Form".equals(typeID)) {
            ConverterDisplayables.convertForm(id2item, item, document);
        } else if ("javax.microedition.lcdui.List".equals(typeID)) {
            ConverterDisplayables.convertList(id2item, item, document);
        } else if ("javax.microedition.lcdui.TextBox".equals(typeID)) {
            ConverterDisplayables.convertTextBox(id2item, item, document);
        } else if ("javax.microedition.lcdui.ChoiceGroup".equals(typeID)) {
            ConverterItems.convertChoiceGroup(id2item, item, document);
        } else if ("javax.microedition.lcdui.DateField".equals(typeID)) {
            ConverterItems.convertDateField(id2item, item, document);
        } else if ("javax.microedition.lcdui.Gauge".equals(typeID)) {
            ConverterItems.convertGauge(id2item, item, document);
        } else if ("javax.microedition.lcdui.Gauge-AlertIndicator_Helper".equals(typeID)) {
            ConverterItems.convertAlertIndicator(id2item, item, document);
        } else if ("javax.microedition.lcdui.ImageItem".equals(typeID)) {
            ConverterItems.convertImageItem(id2item, item, document);
        } else if ("javax.microedition.lcdui.Spacer".equals(typeID)) {
            ConverterItems.convertSpacer(id2item, item, document);
        } else if ("javax.microedition.lcdui.StringItem".equals(typeID)) {
            ConverterItems.convertStringItem(id2item, item, document);
        } else if ("javax.microedition.lcdui.TextField".equals(typeID)) {
            ConverterItems.convertTextField(id2item, item, document);
        } else if ("javax.microedition.lcdui.Font".equals(typeID)) {
            ConverterResources.convertFont(item, document);
        } else if ("javax.microedition.lcdui.Ticker".equals(typeID)) {
            ConverterResources.convertTicker(item, document);
        } else if ("javax.microedition.lcdui.Image".equals(typeID)) {
            ConverterResources.convertImage(item, document);
        } else if ("GROUP-org.netbeans.modules.mvd.model.midp2.Midp2ChoiceElementDC".equals(typeID)) {
            ConverterElements.convertChoiceElement(id2item, item, document);
        } else if ("GROUP-org.netbeans.modules.mvd.model.midp2.Midp2ListElementDC".equals(typeID)) {
            ConverterElements.convertListElement(id2item, item, document);
        } else if ("org.netbeans.microedition.util.SimpleCancellableTask".equals(typeID)) {
            ConverterBuilt.convertSimpleCancellableTask(id2item, item, document);
        } else if ("org.netbeans.microedition.lcdui.SimpleTableModel".equals(typeID)) {
            ConverterBuilt.convertSimpleTableModel(id2item, item, document);
        } else if ("org.netbeans.microedition.lcdui.SplashScreen".equals(typeID)) {
            ConverterBuilt.convertSplashScreen(id2item, item, document);
        } else if ("org.netbeans.microedition.lcdui.TableItem".equals(typeID)) {
            ConverterBuilt.convertTableItem(id2item, item, document);
        } else if ("org.netbeans.microedition.lcdui.WaitScreen".equals(typeID)) {
            ConverterBuilt.convertWaitScreen(id2item, item, document);
        } else if ("javax.microedition.m2g.SVGImage".equals(typeID)) {
            ConverterSVG.convertImage(id2item, item, document);
        } else if ("org.netbeans.microedition.svg.SVGAnimatorWrapper".equals(typeID)) {
            ConverterSVG.convertPlayer(id2item, item, document);
        } else if ("org.netbeans.microedition.svg.SVGMenu".equals(typeID)) {
            ConverterSVG.convertMenu(id2item, item, document);
        } else if ("GROUP-org.netbeans.modules.vmd.components.svg.SvgMenuElementDC".equals(typeID)) {
            ConverterSVG.convertMenuElement(id2item, item, document);
        } else if ("org.netbeans.microedition.svg.SVGSplashScreen".equals(typeID)) {
            ConverterSVG.convertSplashScreen(id2item, item, document);
        } else if ("org.netbeans.microedition.svg.SVGWaitScreen".equals(typeID)) {
            ConverterSVG.convertWaitScreen(id2item, item, document);
        } else if ("$MobileDevice".equals(id)) {
            DesignComponent pointsCategory = MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)PointsCategoryCD.TYPEID);
            List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)pointsCategory, (TypeID)MobileDeviceCD.TYPEID);
            DesignComponent mobileDevice = (DesignComponent)list.get(0);
            Converter.convertObject(item, mobileDevice);
        } else if ("$StartPoint".equals(id)) {
            DesignComponent pointsCategory = MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)PointsCategoryCD.TYPEID);
            List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)pointsCategory, (TypeID)MobileDeviceCD.TYPEID);
            DesignComponent mobileDevice = (DesignComponent)list.get(0);
            DesignComponent startEventSource = mobileDevice.readProperty("start").getComponent();
            Converter.convertObject(item, startEventSource);
            ConverterActions.convertCommandActionHandler(id2item, item, startEventSource);
        } else if (ConverterCustom.isClassComponent(item)) {
            ConverterCustom.convertCustom(id2item, item, document);
        }
    }

    static ConverterItem convertConverterItem(HashMap<String, ConverterItem> id2item, String value, DesignDocument document) {
        ConverterItem item = id2item.get(value);
        if (item != null) {
            Converter.convert(id2item, item, document);
            if (item.isUsed()) {
                return item;
            }
        }
        return null;
    }

    static DesignComponent convertConverterItemComponent(HashMap<String, ConverterItem> id2item, String propertyValue, DesignDocument document) {
        ConverterItem item = Converter.convertConverterItem(id2item, propertyValue, document);
        return item != null ? item.getRelatedComponent() : null;
    }

    static void convertObject(ConverterItem item, DesignComponent component) {
        item.setUsed(component);
    }

    static void convertClass(ConverterItem item, DesignComponent component) {
        Converter.convertObject(item, component);
        item.setClass();
        component.writeProperty("instanceName", MidpTypes.createStringValue((String)item.getID()));
        Boolean lazy = ConverterUtil.getBoolean(item.getPropertyValue("lazyInitialized"));
        component.writeProperty("lazyInit", MidpTypes.createBooleanValue((lazy == null || lazy != false ? 1 : 0) != 0));
    }
}

