/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion;

import groovy.lang.MetaMethod;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.swing.ImageIcon;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.Variable;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.completion.CompletionHandler;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.ElementHandleSupport;
import org.netbeans.modules.groovy.editor.api.elements.GroovyElement;
import org.netbeans.modules.groovy.editor.api.elements.KeywordElement;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.openide.util.ImageUtilities;

public abstract class CompletionItem
extends DefaultCompletionProposal {
    private static final Logger LOG = Logger.getLogger(CompletionItem.class.getName());
    protected final GroovyElement element;
    private static volatile ImageIcon groovyIcon;
    private static volatile ImageIcon javaIcon;
    private static volatile ImageIcon newConstructorIcon;

    private CompletionItem(GroovyElement element, int anchorOffset) {
        this.element = element;
        this.anchorOffset = anchorOffset;
        LOG.setLevel(Level.OFF);
    }

    public String getName() {
        return this.element.getName();
    }

    public ElementHandle getElement() {
        LOG.log(Level.FINEST, "getElement() element : {0}", this.element);
        return null;
    }

    public org.netbeans.modules.csl.api.ElementKind getKind() {
        return this.element.getKind();
    }

    public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public String toString() {
        String cls = ((Object)((Object)this)).getClass().getName();
        cls = cls.substring(cls.lastIndexOf(46) + 1);
        return cls + "(" + this.getKind() + "): " + this.getName();
    }

    public static CompletionItem forJavaMethod(String className, String simpleName, String parameterString, TypeMirror returnType, Set<Modifier> modifiers, int anchorOffset, boolean emphasise, boolean nameOnly) {
        return new JavaMethodItem(className, simpleName, parameterString, returnType, modifiers, anchorOffset, emphasise, nameOnly);
    }

    public static CompletionItem forJavaMethod(String className, String simpleName, String parameterString, String returnType, Set<Modifier> modifiers, int anchorOffset, boolean emphasise, boolean nameOnly) {
        return new JavaMethodItem(className, simpleName, parameterString, returnType, modifiers, anchorOffset, emphasise, nameOnly);
    }

    public static CompletionItem forDynamicMethod(int anchorOffset, String name, String[] parameters, String returnType, boolean nameOnly, boolean prefix) {
        return new DynamicMethodItem(anchorOffset, name, parameters, returnType, nameOnly, prefix);
    }

    public static CompletionItem forDynamicField(int anchorOffset, String name, String type) {
        return new DynamicFieldItem(anchorOffset, name, type);
    }

    public static class ParameterDescriptor {
        private final String fullTypeName;
        private final String typeName;
        private final String name;

        public ParameterDescriptor(String fullTypeName, String typeName, String name) {
            this.fullTypeName = fullTypeName;
            this.typeName = typeName;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getFullTypeName() {
            return this.fullTypeName;
        }
    }

    public static class NewVarItem
    extends CompletionItem {
        private final String var;

        public NewVarItem(String var, int anchorOffset) {
            super(null, anchorOffset);
            this.var = var;
        }

        @Override
        public String getName() {
            return this.var;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.VARIABLE;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.LOCAL_VARIABLE, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }
    }

    public static class LocalVarItem
    extends CompletionItem {
        private final Variable var;

        public LocalVarItem(Variable var, int anchorOffset) {
            super(null, anchorOffset);
            this.var = var;
        }

        @Override
        public String getName() {
            return this.var.getName();
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.VARIABLE;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return NbUtilities.stripPackage(Utilities.translateClassLoaderTypeName(this.var.getType().getName()));
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.LOCAL_VARIABLE, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }
    }

    public static class FieldItem
    extends CompletionItem {
        private final String name;
        private final ParserResult info;
        private final String typeName;
        private final int modifiers;

        public FieldItem(String name, int modifiers, int anchorOffset, ParserResult info, String typeName) {
            super(null, anchorOffset);
            this.name = name;
            this.info = info;
            this.typeName = typeName;
            this.modifiers = modifiers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.FIELD;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.typeName;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.FIELD, Utilities.reflectionModifiersToModel(this.modifiers));
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.info, new KeywordElement(this.name));
        }
    }

    public static class JavaFieldItem
    extends CompletionItem {
        private final String className;
        private final String name;
        private final TypeMirror type;
        private final Set<Modifier> modifiers;
        private final boolean emphasise;

        public JavaFieldItem(String className, String name, TypeMirror type, Set<Modifier> modifiers, int anchorOffset, boolean emphasise) {
            super(null, anchorOffset);
            this.className = className;
            this.name = name;
            this.type = type;
            this.modifiers = modifiers;
            this.emphasise = emphasise;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.FIELD;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            String retType = "";
            if (this.type != null) {
                retType = ((Object)Utilities.getTypeName(this.type, false)).toString();
            }
            formatter.appendText(retType);
            return formatter.getText();
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.FIELD, this.modifiers);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Utilities.modelModifiersToGsf(this.modifiers);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.className, this.name, org.netbeans.modules.csl.api.ElementKind.FIELD, Utilities.modelModifiersToGsf(this.modifiers));
        }
    }

    public static class ConstructorItem
    extends CompletionItem {
        private final String name;
        private static final String NEW_CSTR = "org/netbeans/modules/groovy/editor/resources/new_constructor_16.png";
        private boolean expand;
        private final String paramListString;
        private final List<ParameterDescriptor> paramList;

        public ConstructorItem(String name, String paramListString, List<ParameterDescriptor> paramList, int anchorOffset, boolean expand) {
            super(null, anchorOffset);
            this.name = name;
            this.expand = expand;
            this.paramListString = paramListString;
            this.paramList = paramList;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            if (this.expand) {
                return this.name + " - generate";
            }
            return this.name + "(" + this.paramListString + ")";
        }

        @Override
        public String getName() {
            if (this.expand) {
                return this.name + "()\n{\n}";
            }
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.CONSTRUCTOR;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        public ImageIcon getIcon() {
            if (newConstructorIcon == null) {
                newConstructorIcon = ImageUtilities.loadImageIcon((String)NEW_CSTR, (boolean)false);
            }
            return newConstructorIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }

        public boolean isSmart() {
            return true;
        }

        public String getCustomInsertTemplate() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getInsertPrefix());
            sb.append("(");
            int id = 1;
            for (ParameterDescriptor paramDesc : this.paramList) {
                LOG.log(Level.FINEST, "-------------------------------------------------------------------");
                LOG.log(Level.FINEST, "paramDesc.fullTypeName : {0}", paramDesc.getFullTypeName());
                LOG.log(Level.FINEST, "paramDesc.typeName     : {0}", paramDesc.getTypeName());
                LOG.log(Level.FINEST, "paramDesc.name         : {0}", paramDesc.getName());
                sb.append("${");
                sb.append("groovy-cc-");
                sb.append(Integer.toString(id));
                sb.append(" default=\"");
                sb.append(paramDesc.getName());
                sb.append("\"");
                sb.append("}");
                if (id < this.paramList.size()) {
                    sb.append(", ");
                }
                ++id;
            }
            sb.append(")");
            LOG.log(Level.FINEST, "Template returned : {0}", sb.toString());
            return sb.toString();
        }
    }

    public static class TypeItem
    extends CompletionItem {
        private final String name;
        private final ElementKind ek;

        public TypeItem(String name, int anchorOffset, ElementKind ek) {
            super(null, anchorOffset);
            this.name = name;
            this.ek = ek;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.CLASS;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)this.ek, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }
    }

    public static class PackageItem
    extends CompletionItem {
        private final String keyword;
        private final ParserResult info;

        public PackageItem(String keyword, int anchorOffset, ParserResult info) {
            super(null, anchorOffset);
            this.keyword = keyword;
            this.info = info;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.PACKAGE;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.PACKAGE, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.info, new KeywordElement(this.keyword));
        }
    }

    public static class KeywordItem
    extends CompletionItem {
        private static final String JAVA_KEYWORD = "org/netbeans/modules/groovy/editor/resources/duke.png";
        private final String keyword;
        private final String description;
        private final boolean isGroovy;
        private final ParserResult info;

        public KeywordItem(String keyword, String description, int anchorOffset, ParserResult info, boolean isGroovy) {
            super(null, anchorOffset);
            this.keyword = keyword;
            this.description = description;
            this.info = info;
            this.isGroovy = isGroovy;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.KEYWORD;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.description != null) {
                formatter.appendHtml(this.description);
                return formatter.getText();
            }
            return null;
        }

        public ImageIcon getIcon() {
            if (this.isGroovy) {
                if (groovyIcon == null) {
                    groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
                }
                return groovyIcon;
            }
            if (javaIcon == null) {
                javaIcon = ImageUtilities.loadImageIcon((String)JAVA_KEYWORD, (boolean)false);
            }
            return javaIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.info, new KeywordElement(this.keyword));
        }
    }

    public static class MetaMethodItem
    extends CompletionItem {
        private final MetaMethod method;
        private final boolean isGDK;
        private final AstMethodElement methodElement;
        private final boolean nameOnly;

        public MetaMethodItem(Class clz, MetaMethod method, int anchorOffset, boolean isGDK, boolean nameOnly) {
            super(null, anchorOffset);
            this.method = method;
            this.isGDK = isGDK;
            this.nameOnly = nameOnly;
            this.methodElement = new AstMethodElement(null, new ASTNode(), clz, method, isGDK);
        }

        public MetaMethod getMethod() {
            return this.method;
        }

        @Override
        public String getName() {
            return this.method.getName() + "()";
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.METHOD;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            org.netbeans.modules.csl.api.ElementKind kind = this.getKind();
            formatter.name(kind, true);
            if (this.isGDK) {
                formatter.appendText(this.method.getName());
                String signature = this.method.getSignature();
                int start = signature.indexOf("(");
                int end = signature.indexOf(")");
                String sig = signature.substring(start + 1, end);
                StringBuffer buf = new StringBuffer();
                for (String param : sig.split(",")) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(NbUtilities.stripPackage(Utilities.translateClassLoaderTypeName(param)));
                }
                String simpleSig = buf.toString();
                formatter.appendText("(" + simpleSig + ")");
            } else {
                formatter.appendText(CompletionHandler.getMethodSignature(this.method, false, this.isGDK));
            }
            formatter.name(kind, false);
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            String retType = this.method.getReturnType().getSimpleName();
            retType = NbUtilities.stripPackage(retType);
            formatter.appendText(retType);
            return formatter.getText();
        }

        public ImageIcon getIcon() {
            if (!this.isGDK) {
                return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.METHOD, Utilities.reflectionModifiersToModel(this.method.getModifiers()));
            }
            if (groovyIcon == null) {
                groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
            }
            return groovyIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return this.methodElement;
        }

        public String getCustomInsertTemplate() {
            if (this.nameOnly) {
                return this.method.getName();
            }
            return super.getCustomInsertTemplate();
        }
    }

    private static class DynamicMethodItem
    extends CompletionItem {
        private final String name;
        private final String[] parameters;
        private final String returnType;
        private final boolean nameOnly;
        private final boolean prefix;

        public DynamicMethodItem(int anchorOffset, String name, String[] parameters, String returnType, boolean nameOnly, boolean prefix) {
            super(null, anchorOffset);
            this.name = name;
            this.parameters = parameters;
            this.returnType = returnType;
            this.nameOnly = nameOnly;
            this.prefix = prefix;
        }

        @Override
        public String getName() {
            return this.name + "()";
        }

        public String getSortText() {
            return this.name + (this.prefix ? 1 : 0) + this.parameters.length;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.METHOD;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            org.netbeans.modules.csl.api.ElementKind kind = this.getKind();
            formatter.name(kind, true);
            formatter.appendText(this.name);
            if (!this.prefix) {
                StringBuilder buf = new StringBuilder();
                for (String param : this.parameters) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(NbUtilities.stripPackage(Utilities.translateClassLoaderTypeName(param)));
                }
                String simpleSig = buf.toString();
                formatter.appendText("(" + simpleSig + ")");
            } else {
                formatter.appendText("...");
            }
            formatter.name(kind, false);
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            String retType = this.returnType;
            retType = NbUtilities.stripPackage(retType);
            formatter.appendText(retType);
            return formatter.getText();
        }

        public ImageIcon getIcon() {
            if (groovyIcon == null) {
                groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
            }
            return groovyIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(null, this.name, org.netbeans.modules.csl.api.ElementKind.METHOD, Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED));
        }

        public String getCustomInsertTemplate() {
            if (this.nameOnly) {
                return this.name;
            }
            return super.getCustomInsertTemplate();
        }
    }

    public static class DynamicFieldItem
    extends CompletionItem {
        private final String name;
        private final String type;

        public DynamicFieldItem(int anchorOffset, String name, String type) {
            super(null, anchorOffset);
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.FIELD;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            String retType = this.type;
            retType = NbUtilities.stripPackage(retType);
            formatter.appendText(retType);
            return formatter.getText();
        }

        public ImageIcon getIcon() {
            if (groovyIcon == null) {
                groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
            }
            return groovyIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(null, this.name, org.netbeans.modules.csl.api.ElementKind.FIELD, Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED));
        }
    }

    private static class JavaMethodItem
    extends CompletionItem {
        private final String className;
        private final String simpleName;
        private final String parameterString;
        private final String returnType;
        private final Set<Modifier> modifiers;
        private final boolean emphasise;
        private final boolean nameOnly;

        public JavaMethodItem(String className, String simpleName, String parameterString, TypeMirror returnType, Set<Modifier> modifiers, int anchorOffset, boolean emphasise, boolean nameOnly) {
            this(className, simpleName, parameterString, ((Object)Utilities.getTypeName(returnType, false)).toString(), modifiers, anchorOffset, emphasise, nameOnly);
        }

        public JavaMethodItem(String className, String simpleName, String parameterString, String returnType, Set<Modifier> modifiers, int anchorOffset, boolean emphasise, boolean nameOnly) {
            super(null, anchorOffset);
            this.className = className;
            this.simpleName = simpleName;
            this.parameterString = parameterString;
            this.returnType = NbUtilities.stripPackage(returnType);
            this.modifiers = modifiers;
            this.emphasise = emphasise;
            this.nameOnly = nameOnly;
        }

        @Override
        public String getName() {
            return this.simpleName + "()";
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.METHOD;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            if (this.emphasise) {
                formatter.emphasis(true);
            }
            formatter.appendText(this.simpleName + "(" + this.parameterString + ")");
            if (this.emphasise) {
                formatter.emphasis(false);
            }
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            String retType = "";
            if (this.returnType != null) {
                retType = this.returnType;
            }
            formatter.appendText(retType);
            return formatter.getText();
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.METHOD, this.modifiers);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Utilities.modelModifiersToGsf(this.modifiers);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.className, this.simpleName, org.netbeans.modules.csl.api.ElementKind.METHOD, Utilities.modelModifiersToGsf(this.modifiers));
        }

        public String getCustomInsertTemplate() {
            if (this.nameOnly) {
                return this.simpleName;
            }
            return super.getCustomInsertTemplate();
        }
    }
}

