/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.EventListener;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyListener;

public final class ViewHierarchy {
    private static final Logger LOG = Logger.getLogger(ViewHierarchy.class.getName());
    private final JTextComponent component;
    private final ListenerList<ViewHierarchyListener> listenerList;

    public static synchronized ViewHierarchy get(JTextComponent component) {
        ViewHierarchy viewHierarchy = (ViewHierarchy)component.getClientProperty(ViewHierarchy.class);
        if (viewHierarchy == null) {
            viewHierarchy = new ViewHierarchy(component);
            component.putClientProperty(ViewHierarchy.class, viewHierarchy);
        }
        return viewHierarchy;
    }

    private ViewHierarchy(JTextComponent component) {
        this.component = component;
        this.listenerList = new ListenerList();
    }

    public void addViewHierarchyListener(ViewHierarchyListener l) {
        this.listenerList.add((EventListener)l);
    }

    public void removeViewHierarchyListener(ViewHierarchyListener l) {
        this.listenerList.remove((EventListener)l);
    }

    void fireViewHierarchyEvent(ViewHierarchyEvent evt) {
        for (ViewHierarchyListener l : this.listenerList.getListeners()) {
            l.viewHierarchyChanged(evt);
        }
    }
}

