/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.highlight.error.CppUpToDateStatusProvider;
import org.netbeans.modules.cnd.highlight.error.HighlightProviderTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;

public class HighlightProvider {
    private Hook hook;
    public static final boolean TRACE_ANNOTATIONS = Boolean.getBoolean("cnd.highlight.trace.annotations");
    private static final HighlightProvider instance = new HighlightProvider();

    public synchronized void setHook(Hook hook) {
        this.hook = hook;
    }

    public static HighlightProvider getInstance() {
        return instance;
    }

    private HighlightProvider() {
    }

    void update(CsmFile file, Document doc, DataObject dao, HighlightProviderTaskFactory.CancellableInterruptor interrupter) {
        assert (doc != null || file == null);
        if (doc instanceof BaseDocument) {
            this.addAnnotations((BaseDocument)doc, file, dao, interrupter);
        }
    }

    void clear(Document doc) {
        assert (doc != null);
        if (doc instanceof BaseDocument) {
            this.removeAnnotations(doc);
            CppUpToDateStatusProvider.get((BaseDocument)doc).setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
        }
    }

    private static Severity getSeverity(CsmErrorInfo info) {
        switch (info.getSeverity()) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: {
                return Severity.WARNING;
            }
        }
        throw new IllegalArgumentException("Unexpected severity: " + info.getSeverity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotations(final BaseDocument doc, CsmFile file, final DataObject dao, final HighlightProviderTaskFactory.CancellableInterruptor interrupter) {
        CppUpToDateStatusProvider.get(doc).setUpToDate(UpToDateStatus.UP_TO_DATE_PROCESSING);
        final ArrayList<ErrorDescription> descriptions = new ArrayList<ErrorDescription>();
        if (TRACE_ANNOTATIONS) {
            System.err.printf("\nSetting annotations for %s\n", file);
        }
        CsmErrorProvider.Response response = new CsmErrorProvider.Response(){
            private int lastSize;
            {
                this.lastSize = descriptions.size();
            }

            public void addError(CsmErrorInfo info) {
                if (interrupter.cancelled()) {
                    return;
                }
                PositionBounds pb = HighlightProvider.createPositionBounds(dao, info.getStartOffset(), info.getEndOffset());
                ErrorDescription desc = null;
                if (pb != null) {
                    try {
                        desc = ErrorDescriptionFactory.createErrorDescription((Severity)HighlightProvider.getSeverity(info), (String)info.getMessage(), (Document)doc, (Position)pb.getBegin().getPosition(), (Position)pb.getEnd().getPosition());
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    descriptions.add(desc);
                    if (TRACE_ANNOTATIONS) {
                        System.err.printf("\tadded to a bag %s\n", desc.toString());
                    }
                } else if (TRACE_ANNOTATIONS) {
                    System.err.printf("\tCan't create PositionBounds for %s\n", info);
                }
            }

            public void done() {
                if (descriptions.size() > this.lastSize) {
                    this.lastSize = descriptions.size();
                    if (TRACE_ANNOTATIONS) {
                        System.err.printf("Showing %d errors\n", descriptions.size());
                    }
                    HintsController.setErrors((Document)doc, (String)HighlightProvider.class.getName(), (Collection)descriptions);
                }
            }
        };
        this.removeAnnotations((Document)doc);
        DocumentListener listener = null;
        if (doc != null) {
            listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    interrupter.cancel();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    interrupter.cancel();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            doc.addDocumentListener(listener);
        }
        try {
            CsmErrorProvider.getDefault().getErrors((CsmErrorProvider.Request)new RequestImpl(file, (Document)doc, interrupter), response);
        }
        finally {
            if (listener != null) {
                doc.removeDocumentListener(listener);
            }
        }
        CppUpToDateStatusProvider.get(doc).setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
        Hook theHook = this.hook;
        if (theHook != null) {
            theHook.highlightingDone(((Object)file.getAbsolutePath()).toString(), descriptions);
        }
    }

    private static PositionBounds createPositionBounds(DataObject dao, int start, int end) {
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((DataObject)dao);
        if (ces != null) {
            PositionRef posBeg = ces.createPositionRef(start, Position.Bias.Forward);
            PositionRef posEnd = ces.createPositionRef(end, Position.Bias.Backward);
            return new PositionBounds(posBeg, posEnd);
        }
        return null;
    }

    private void removeAnnotations(Document doc) {
        HintsController.setErrors((Document)doc, (String)HighlightProvider.class.getName(), Collections.emptyList());
    }

    static class RequestImpl
    implements CsmErrorProvider.Request {
        private final CsmFile file;
        private CsmReferenceRepository.Interrupter interrupter;
        private final Document document;

        public RequestImpl(CsmFile file, Document doc, CsmReferenceRepository.Interrupter interrupter) {
            this.file = file;
            this.interrupter = interrupter;
            this.document = doc;
        }

        public CsmFile getFile() {
            return this.file;
        }

        public boolean isCancelled() {
            return this.interrupter.cancelled();
        }

        public Document getDocument() {
            return this.document;
        }
    }

    public static interface Hook {
        public void highlightingDone(String var1, List<ErrorDescription> var2);
    }
}

