/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.filters.FilterSet;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.global.InstrumentationFilter;

public class ProfilingSettings {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.Bundle");
    static final String DEFAULT_PROFILING_SETTINGS_NAME = bundle.getString("ProfilingSettings_DefaultProfilingSettingsName");
    private static final String UNKNOWN_PROFILING_SETTINGS_NAME = bundle.getString("ProfilingSettings_UnknownProfilingSettingsName");
    public static final int PROFILE_MONITOR = 1;
    public static final int PROFILE_MEMORY_ALLOCATIONS = 2;
    public static final int PROFILE_MEMORY_LIVENESS = 4;
    public static final int PROFILE_CPU_ENTIRE = 8;
    public static final int PROFILE_CPU_PART = 16;
    public static final int PROFILE_CPU_STOPWATCH = 32;
    public static final boolean QUICK_FILTER_INCLUSIVE = true;
    public static final boolean QUICK_FILTER_EXCLUSIVE = false;
    public static final String LINES_PREFIX = "[lines]";
    public static final String PROP_OVERRIDE_GLOBAL_SETTINGS = "profiler.settings.override";
    public static final String PROP_WORKING_DIR = "profiler.settings.override.working.dir";
    public static final String PROP_JVM_ARGS = "profiler.settings.override.jvm.args";
    public static final String PROP_JAVA_PLATFORM = "profiler.settings.override.java.platform";
    public static final String PROP_IS_PRESET = "profiler.settigns.ispreset";
    public static final String PROP_SETTINGS_NAME = "profiler.settings.settings.name";
    public static final String PROP_PROFILING_TYPE = "profiler.settings.profiling.type";
    public static final String PROP_THREADS_MONITORING_ENABLED = "profiler.settings.threads.monitoring.enabled";
    public static final String PROP_THREADS_SAMPLING_ENABLED = "profiler.settings.threads.sampling.enabled";
    public static final String PROP_CPU_PROFILING_TYPE = "profiler.settings.cpu.profiling.type";
    public static final String PROP_EXCLUDE_WAIT_TIME = "profiler.settings.cpu.exclude.wait.time";
    public static final String PROP_INSTR_SCHEME = "profiler.settings.instr.scheme";
    public static final String PROP_THREAD_CPU_TIMER_ON = "profiler.settings.thread.cpu.timer.on";
    public static final String PROP_INSTRUMENT_GETTER_SETTER_METHODS = "profiler.settings.istrument.getter.setter.methods";
    public static final String PROP_INSTRUMENT_EMPTY_METHODS = "profiler.settings.instrument.empty.methods";
    public static final String PROP_INSTRUMENT_METHOD_INVOKE = "profiler.settings.instrument.method.invoke";
    public static final String PROP_INSTRUMENT_SPAWNED_THREADS = "profiler.settings.instrument.spawned.threads";
    public static final String PROP_N_PROFILED_THREADS_LIMIT = "profiler.settings.n.profiled.threads.limit";
    public static final String PROP_SORT_RESULTS_BY_THREAD_CPU_TIME = "profiler.settings.sort.results.by.thread.cpu.time";
    public static final String PROP_SAMPLING_INTERVAL = "profiler.settings.sampling.interval";
    public static final String PROP_INSTRUMENTATION_ROOT_METHODS_SIZE = "profiler.settings.instrumentation.root.methods.size";
    public static final String PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX = "profiler.settings.istrumentation.root.methods-";
    public static final String PROP_INSTRUMENTATION_MARKER_METHODS_SIZE = "profiler.settings.instrumentation.marker.methods.size";
    public static final String PROP_INSTRUMENTATION_MARKER_METHODS_PREFIX = "profiler.settings.istrumentation.marker.methods-";
    public static final String PROP_FRAGMENT_SELECTION = "profiler.settings.fragment.selection";
    public static final String PROP_CODE_REGION_CPU_RES_BUF_SIZE = "profiler.settings.code.region.cpu.res.buf.size";
    public static final String PROP_RUN_GC_ON_GET_RESULTS_IN_MEMORY_PROFILING = "profiler.settings.run.gc.on.get.results.in.memory.profiling";
    public static final String PROP_OBJ_ALLOC_STACK_SAMPLING_INTERVAL = "profiler.settings.obj.alloc.stack.sampling.interval";
    public static final String PROP_OBJ_ALLOC_STACK_SAMPLING_DEPTH = "profiler.settings.obj.alloc.stack.sampling.depth";
    public static final String PROP_SELECTED_INSTR_FILTER = "profiler.settings.instrumentation.filter.selected";
    public static final String PROP_PROFILE_UNDERLYING_FRAMEWORK = "profiler.settings.profile.underlying.framework";
    public static final String PROP_PROFILING_POINTS_ENABLED = "profiler.settings.profilingpoints.enabled";
    public static final String PROP_QUICK_FILTER = "profiler.settings.cpu.quick.filter";
    public transient boolean instrRootMethodsPending = false;
    private ClientUtils.SourceCodeSelection fragmentSelection = null;
    private List instrumentationMarkerMethods = new ArrayList();
    private List instrumentationRootMethods = new ArrayList();
    private Object selectedInstrumentationFilter = SimpleFilter.NO_FILTER;
    private SimpleFilter quickFilter = FilterUtils.QUICK_FILTER;
    private String jvmArgs = "";
    private String platformName = null;
    private String settingsName = DEFAULT_PROFILING_SETTINGS_NAME;
    private String workingDir = "";
    private boolean excludeWaitTime = true;
    private boolean instrumentEmptyMethods = false;
    private boolean instrumentGetterSetterMethods = false;
    private boolean instrumentMethodInvoke = true;
    private boolean instrumentSpawnedThreads = false;
    private boolean isPreset = false;
    private boolean overrideGlobalSettings = false;
    private boolean profileUnderlyingFramework = false;
    private boolean runGCOnGetResultsInMemoryProfiling = true;
    private boolean sortResultsByThreadCPUTime = false;
    private boolean threadCPUTimerOn = false;
    private boolean threadsMonitoringEnabled = false;
    private boolean threadsSamplingEnabled = true;
    private boolean useProfilingPoints = true;
    private int allocStackTraceLimit = 0;
    private int allocTrackEvery = 10;
    private int codeRegionCPUResBufSize = 1000;
    private int cpuProfilingType = 0;
    private int instrScheme = 1;
    private int nProfiledThreadsLimit = 32;
    private int profilingType = 8;
    private int samplingInterval = 10;

    public ProfilingSettings() {
    }

    public ProfilingSettings(String name) {
        this.settingsName = name;
    }

    public void setAllocStackTraceLimit(int allocStackTraceLimit) {
        this.allocStackTraceLimit = allocStackTraceLimit;
    }

    public int getAllocStackTraceLimit() {
        return this.allocStackTraceLimit;
    }

    public void setAllocTrackEvery(int value) {
        this.allocTrackEvery = value;
    }

    public int getAllocTrackEvery() {
        return this.allocTrackEvery;
    }

    public void setCPUProfilingType(int cpuProfilingType) {
        this.cpuProfilingType = cpuProfilingType;
    }

    public int getCPUProfilingType() {
        return this.cpuProfilingType;
    }

    public void setCodeFragmentSelection(ClientUtils.SourceCodeSelection fragmentSel) {
        this.fragmentSelection = fragmentSel;
    }

    public ClientUtils.SourceCodeSelection getCodeFragmentSelection() {
        return this.fragmentSelection;
    }

    public void setCodeRegionCPUResBufSize(int codeRegionCPUResBufSize) {
        this.codeRegionCPUResBufSize = codeRegionCPUResBufSize;
    }

    public int getCodeRegionCPUResBufSize() {
        return this.codeRegionCPUResBufSize;
    }

    public void setExcludeWaitTime(boolean value) {
        this.excludeWaitTime = value;
    }

    public boolean getExcludeWaitTime() {
        return this.excludeWaitTime;
    }

    public void setInstrScheme(int instrScheme) {
        this.instrScheme = instrScheme;
    }

    public int getInstrScheme() {
        return this.instrScheme;
    }

    public void setInstrumentEmptyMethods(boolean instrumentEmptyMethods) {
        this.instrumentEmptyMethods = instrumentEmptyMethods;
    }

    public boolean getInstrumentEmptyMethods() {
        return this.instrumentEmptyMethods;
    }

    public void setInstrumentGetterSetterMethods(boolean instrumentGetterSetterMethods) {
        this.instrumentGetterSetterMethods = instrumentGetterSetterMethods;
    }

    public boolean getInstrumentGetterSetterMethods() {
        return this.instrumentGetterSetterMethods;
    }

    public void setInstrumentMethodInvoke(boolean instrumentMethodInvoke) {
        this.instrumentMethodInvoke = instrumentMethodInvoke;
    }

    public boolean getInstrumentMethodInvoke() {
        return this.instrumentMethodInvoke;
    }

    public void setInstrumentSpawnedThreads(boolean instrumentSpawnedThreads) {
        this.instrumentSpawnedThreads = instrumentSpawnedThreads;
    }

    public boolean getInstrumentSpawnedThreads() {
        return this.instrumentSpawnedThreads;
    }

    public void setInstrumentationMarkerMethods(ClientUtils.SourceCodeSelection[] markers) {
        this.instrumentationMarkerMethods.clear();
        for (int i = 0; i < markers.length; ++i) {
            ClientUtils.SourceCodeSelection marker = markers[i];
            if (!marker.isMarkerMethod()) continue;
            this.instrumentationMarkerMethods.add(marker);
        }
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationMarkerMethods() {
        return this.instrumentationMarkerMethods.toArray(new ClientUtils.SourceCodeSelection[this.instrumentationMarkerMethods.size()]);
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationMethods() {
        HashSet methods = new HashSet();
        methods.addAll(this.instrumentationRootMethods);
        methods.addAll(this.instrumentationMarkerMethods);
        return methods.toArray(new ClientUtils.SourceCodeSelection[methods.size()]);
    }

    public void setInstrumentationRootMethods(ClientUtils.SourceCodeSelection[] roots) {
        this.instrRootMethodsPending = false;
        this.instrumentationRootMethods.clear();
        for (int i = 0; i < roots.length; ++i) {
            ClientUtils.SourceCodeSelection root = roots[i];
            if (root.isMarkerMethod()) continue;
            this.instrumentationRootMethods.add(root);
        }
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationRootMethods() {
        return this.instrumentationRootMethods.toArray(new ClientUtils.SourceCodeSelection[this.instrumentationRootMethods.size()]);
    }

    public void setIsPreset(boolean isPreset) {
        this.isPreset = isPreset;
    }

    public void setJVMArgs(String args) {
        this.jvmArgs = args;
    }

    public String getJVMArgs() {
        return this.jvmArgs;
    }

    public void setJavaPlatformName(String value) {
        this.platformName = value;
    }

    public String getJavaPlatformName() {
        return this.platformName;
    }

    public void setNProfiledThreadsLimit(int nProfiledThreadsLimit) {
        this.nProfiledThreadsLimit = nProfiledThreadsLimit;
    }

    public int getNProfiledThreadsLimit() {
        return this.nProfiledThreadsLimit;
    }

    public void setOverrideGlobalSettings(boolean override) {
        this.overrideGlobalSettings = override;
    }

    public boolean getOverrideGlobalSettings() {
        return this.overrideGlobalSettings;
    }

    public boolean isPreset() {
        return this.isPreset;
    }

    public void setProfileUnderlyingFramework(boolean profileUF) {
        this.profileUnderlyingFramework = profileUF;
    }

    public boolean getProfileUnderlyingFramework() {
        return this.profileUnderlyingFramework;
    }

    public void setProfilingType(int profilingType) {
        this.profilingType = profilingType;
    }

    public int getProfilingType() {
        return this.profilingType;
    }

    public void setQuickFilter(SimpleFilter quickFilter) {
        this.quickFilter = quickFilter;
    }

    public SimpleFilter getQuickFilter() {
        return this.quickFilter;
    }

    public void setRunGCOnGetResultsInMemoryProfiling(boolean runGCOnGetResultsInMemoryProfiling) {
        this.runGCOnGetResultsInMemoryProfiling = runGCOnGetResultsInMemoryProfiling;
    }

    public boolean getRunGCOnGetResultsInMemoryProfiling() {
        return this.runGCOnGetResultsInMemoryProfiling;
    }

    public void setSamplingInterval(int samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSelectedInstrumentationFilter(Object sif) {
        this.selectedInstrumentationFilter = sif != null ? sif : SimpleFilter.NO_FILTER;
    }

    public Object getSelectedInstrumentationFilter() {
        return this.selectedInstrumentationFilter;
    }

    public void setSettingsName(String name) {
        this.settingsName = name;
    }

    public String getSettingsName() {
        return this.settingsName;
    }

    public void setSortResultsByThreadCPUTime(boolean sortResultsByThreadCPUTime) {
        this.sortResultsByThreadCPUTime = sortResultsByThreadCPUTime;
    }

    public boolean getSortResultsByThreadCPUTime() {
        return this.sortResultsByThreadCPUTime;
    }

    public void setThreadCPUTimerOn(boolean threadCPUTimerOn) {
        this.threadCPUTimerOn = threadCPUTimerOn;
    }

    public boolean getThreadCPUTimerOn() {
        return this.threadCPUTimerOn;
    }

    public void setThreadsMonitoringEnabled(boolean enabled) {
        this.threadsMonitoringEnabled = enabled;
    }

    public boolean getThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public void setThreadsSamplingEnabled(boolean enabled) {
        this.threadsSamplingEnabled = enabled;
    }

    public boolean getThreadsSamplingEnabled() {
        return this.threadsSamplingEnabled;
    }

    public void setUseProfilingPoints(boolean enabled) {
        this.useProfilingPoints = enabled;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void addRootMethod(String className, String methodName, String signature) {
        ClientUtils.SourceCodeSelection scs = new ClientUtils.SourceCodeSelection(className, methodName, signature);
        if (!this.instrumentationRootMethods.contains(scs)) {
            this.instrumentationRootMethods.add(scs);
        }
    }

    public void addRootMethods(ClientUtils.SourceCodeSelection[] selections) {
        for (int i = 0; i < selections.length; ++i) {
            if (this.instrumentationRootMethods.contains(selections[i])) continue;
            this.instrumentationRootMethods.add(selections[i]);
        }
    }

    public void applySettings(ProfilerEngineSettings settings) {
        if (this.getOverrideGlobalSettings()) {
            settings.setWorkingDir(this.getWorkingDir());
            settings.setJVMArgs(this.getJVMArgs());
            if (this.getJavaPlatformName() != null) {
                settings.setTargetJVMExeFile(Profiler.getDefault().getPlatformJavaFile(this.getJavaPlatformName()));
                settings.setTargetJDKVersionString(Profiler.getDefault().getPlatformJDKVersion(this.getJavaPlatformName()));
                settings.setSystemArchitecture(Profiler.getDefault().getPlatformArchitecture(this.getJavaPlatformName()));
            }
        }
        settings.setExcludeWaitTime(this.getExcludeWaitTime());
        settings.setCPUProfilingType(this.getCPUProfilingType());
        settings.setInstrScheme(this.getInstrScheme());
        settings.setAbsoluteTimerOn(true);
        settings.setThreadCPUTimerOn(this.getThreadCPUTimerOn());
        settings.setInstrumentGetterSetterMethods(this.getInstrumentGetterSetterMethods());
        settings.setInstrumentEmptyMethods(this.getInstrumentEmptyMethods());
        settings.setInstrumentMethodInvoke(this.getInstrumentMethodInvoke());
        settings.setInstrumentSpawnedThreads(this.getInstrumentSpawnedThreads());
        settings.setThreadsMonitoringEnabled(this.getThreadsMonitoringEnabled());
        settings.setThreadsSamplingEnabled(this.getThreadsSamplingEnabled());
        if (this.getNProfiledThreadsLimit() > 0) {
            settings.setNProfiledThreadsLimit(this.getNProfiledThreadsLimit());
        } else {
            settings.setNProfiledThreadsLimit(Integer.MAX_VALUE);
        }
        settings.setSortResultsByThreadCPUTime(this.getSortResultsByThreadCPUTime());
        settings.setSamplingInterval(this.getSamplingInterval());
        settings.setCodeRegionCPUResBufSize(this.getCodeRegionCPUResBufSize());
        settings.setRunGCOnGetResultsInMemoryProfiling(this.getRunGCOnGetResultsInMemoryProfiling());
        settings.setAllocTrackEvery(this.getAllocTrackEvery());
        settings.setAllocStackTraceLimit(this.getAllocStackTraceLimit());
        settings.setInstrumentationRootMethods(this.getInstrumentationMethods());
        InstrumentationFilter instrumentationFilter = settings.getInstrumentationFilter();
        instrumentationFilter.clearFilter();
        if (this.getSelectedInstrumentationFilter().equals(FilterUtils.NONE_FILTER)) {
            instrumentationFilter.setFilterType(0);
            instrumentationFilter.setFilterStrings("");
            return;
        }
        if (this.getSelectedInstrumentationFilter().equals(this.quickFilter)) {
            if (this.quickFilter.getFilterValue().length() > 0) {
                instrumentationFilter.setFilterType(this.quickFilter.getFilterType() == 1 ? 10 : 20);
                instrumentationFilter.setFilterStrings(this.quickFilter.getFilterValue());
            } else {
                instrumentationFilter.setFilterType(0);
                instrumentationFilter.setFilterStrings("");
            }
            return;
        }
        if (this.getSelectedInstrumentationFilter() instanceof SimpleFilter) {
            SimpleFilter ptpFilter = (SimpleFilter)this.getSelectedInstrumentationFilter();
            instrumentationFilter.setFilterType(ptpFilter.getFilterType() == 1 ? 10 : 20);
            instrumentationFilter.setFilterStrings(ptpFilter.getFilterValue());
            return;
        }
        if (this.getSelectedInstrumentationFilter() instanceof FilterSet) {
            FilterSet filterSet = (FilterSet)this.getSelectedInstrumentationFilter();
            GlobalFilters globalFilters = Profiler.getDefault().getGlobalFilters();
            instrumentationFilter.setFilterType(!filterSet.getFilterSetType() ? 10 : 20);
            StringBuffer flatFilterStringsBuffer = new StringBuffer();
            String[] activeGlobalFilters = filterSet.getActiveGlobalFilters();
            for (int i = 0; i < activeGlobalFilters.length; ++i) {
                String activeGlobalFilterValue = globalFilters.getFilterValue(activeGlobalFilters[i]);
                if (activeGlobalFilterValue == null) continue;
                flatFilterStringsBuffer.append(activeGlobalFilterValue);
                flatFilterStringsBuffer.append(" ");
            }
            instrumentationFilter.setFilterStrings(flatFilterStringsBuffer.toString());
            return;
        }
        instrumentationFilter.setFilterType(0);
        instrumentationFilter.setFilterStrings("");
    }

    public void copySettingsInto(ProfilingSettings settings) {
        settings.setProfilingType(this.getProfilingType());
        settings.setOverrideGlobalSettings(this.getOverrideGlobalSettings());
        settings.setWorkingDir(this.getWorkingDir());
        settings.setJVMArgs(this.getJVMArgs());
        settings.setJavaPlatformName(this.getJavaPlatformName());
        settings.setThreadsMonitoringEnabled(this.getThreadsMonitoringEnabled());
        settings.setThreadsSamplingEnabled(this.getThreadsSamplingEnabled());
        settings.setUseProfilingPoints(this.useProfilingPoints());
        settings.setExcludeWaitTime(this.getExcludeWaitTime());
        settings.setCPUProfilingType(this.getCPUProfilingType());
        settings.setInstrScheme(this.getInstrScheme());
        settings.setThreadCPUTimerOn(this.getThreadCPUTimerOn());
        settings.setInstrumentGetterSetterMethods(this.getInstrumentGetterSetterMethods());
        settings.setInstrumentEmptyMethods(this.getInstrumentEmptyMethods());
        settings.setInstrumentMethodInvoke(this.getInstrumentMethodInvoke());
        settings.setInstrumentSpawnedThreads(this.getInstrumentSpawnedThreads());
        settings.setNProfiledThreadsLimit(this.getNProfiledThreadsLimit());
        settings.setSortResultsByThreadCPUTime(this.getSortResultsByThreadCPUTime());
        settings.setSamplingInterval(this.getSamplingInterval());
        settings.setInstrumentationRootMethods(this.getInstrumentationRootMethods());
        settings.setCodeFragmentSelection(this.getCodeFragmentSelection());
        settings.setCodeRegionCPUResBufSize(this.getCodeRegionCPUResBufSize());
        settings.setRunGCOnGetResultsInMemoryProfiling(this.getRunGCOnGetResultsInMemoryProfiling());
        settings.setAllocTrackEvery(this.getAllocTrackEvery());
        settings.setAllocStackTraceLimit(this.getAllocStackTraceLimit());
        settings.setSelectedInstrumentationFilter(this.getSelectedInstrumentationFilter());
        settings.setQuickFilter(this.getQuickFilter());
        settings.setProfileUnderlyingFramework(this.getProfileUnderlyingFramework());
    }

    public String debug() {
        StringBuffer sb = new StringBuffer();
        sb.append("isPreset: " + this.isPreset());
        sb.append('\n');
        sb.append("name: " + this.getSettingsName());
        sb.append('\n');
        sb.append("profilingType: " + this.getProfilingType());
        sb.append('\n');
        sb.append("overrideGlobalSettings: " + this.getOverrideGlobalSettings());
        sb.append('\n');
        sb.append("workingDir: " + this.getWorkingDir());
        sb.append('\n');
        sb.append("jvmArgs: " + this.getJVMArgs());
        sb.append('\n');
        sb.append("javaPlatform: " + (this.getJavaPlatformName() == null ? "<project>" : this.getJavaPlatformName()));
        sb.append('\n');
        sb.append("threadsMonitoringEnabled: " + this.getThreadsMonitoringEnabled());
        sb.append('\n');
        sb.append("threadsSamplingEnabled: " + this.getThreadsSamplingEnabled());
        sb.append('\n');
        sb.append("useProfilingPoints: " + this.useProfilingPoints());
        sb.append('\n');
        sb.append("excludeWaitTime: " + this.getExcludeWaitTime());
        sb.append('\n');
        sb.append("cpuProfilingType: " + this.getCPUProfilingType());
        sb.append('\n');
        sb.append("instrScheme: " + this.getInstrScheme());
        sb.append('\n');
        sb.append("threadCPUTimerOn: " + this.getThreadCPUTimerOn());
        sb.append('\n');
        sb.append("instrumentGetterSetterMethods: " + this.getInstrumentGetterSetterMethods());
        sb.append('\n');
        sb.append("instrumentEmptyMethods: " + this.getInstrumentEmptyMethods());
        sb.append('\n');
        sb.append("instrumentMethodInvoke: " + this.getInstrumentMethodInvoke());
        sb.append('\n');
        sb.append("instrumentSpawnedThreads: " + this.getInstrumentSpawnedThreads());
        sb.append('\n');
        sb.append("nProfiledThreadsLimit: " + this.getNProfiledThreadsLimit());
        sb.append('\n');
        sb.append("sortResultsByThreadCPUTime: " + this.getSortResultsByThreadCPUTime());
        sb.append('\n');
        sb.append("samplingInterval: " + this.getSamplingInterval());
        sb.append('\n');
        sb.append("instrumentationRootMethods: " + this.instrumentationRootMethods);
        sb.append('\n');
        sb.append("codeFragmentSelection: " + this.getCodeFragmentSelection());
        sb.append('\n');
        sb.append("codeRegionCPUResBufSize: " + this.getCodeRegionCPUResBufSize());
        sb.append('\n');
        sb.append("runGCOnGetResultsInMemoryProfiling: " + this.getRunGCOnGetResultsInMemoryProfiling());
        sb.append('\n');
        sb.append("allocTrackEvery: " + this.getAllocTrackEvery());
        sb.append('\n');
        sb.append("allocStackTraceLimit: " + this.getAllocStackTraceLimit());
        sb.append('\n');
        sb.append("selectedInstrFilter: " + this.getSelectedInstrumentationFilter());
        sb.append('\n');
        sb.append("profileUnderlyingFramework: " + this.getProfileUnderlyingFramework());
        sb.append('\n');
        return sb.toString();
    }

    public void load(Map props) {
        this.load(props, "");
    }

    public void load(Map props, String prefix) {
        this.setIsPreset(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_IS_PRESET, "false")));
        this.setSettingsName(ProfilingSettings.getProperty(props, prefix + PROP_SETTINGS_NAME, UNKNOWN_PROFILING_SETTINGS_NAME));
        this.setProfilingType(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_PROFILING_TYPE, "8")));
        this.setOverrideGlobalSettings(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_OVERRIDE_GLOBAL_SETTINGS, "false")));
        this.setWorkingDir(ProfilingSettings.getProperty(props, prefix + PROP_WORKING_DIR, ""));
        this.setJVMArgs(ProfilingSettings.getProperty(props, prefix + PROP_JVM_ARGS, ""));
        this.setJavaPlatformName(ProfilingSettings.getProperty(props, prefix + PROP_JAVA_PLATFORM, null));
        this.setThreadsMonitoringEnabled(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_THREADS_MONITORING_ENABLED, "false")));
        this.setThreadsSamplingEnabled(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_THREADS_SAMPLING_ENABLED, "true")));
        this.setExcludeWaitTime(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_EXCLUDE_WAIT_TIME, "false")));
        this.setCPUProfilingType(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_CPU_PROFILING_TYPE, "0")));
        this.setInstrScheme(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_INSTR_SCHEME, "1")));
        this.setThreadCPUTimerOn(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_THREAD_CPU_TIMER_ON, "false")));
        this.setInstrumentGetterSetterMethods(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENT_GETTER_SETTER_METHODS, "false")));
        this.setInstrumentEmptyMethods(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENT_EMPTY_METHODS, "false")));
        this.setInstrumentMethodInvoke(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENT_METHOD_INVOKE, "true")));
        this.setInstrumentSpawnedThreads(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENT_SPAWNED_THREADS, "false")));
        this.setNProfiledThreadsLimit(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_N_PROFILED_THREADS_LIMIT, "32")));
        this.setSortResultsByThreadCPUTime(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_SORT_RESULTS_BY_THREAD_CPU_TIME, "false")));
        this.setProfileUnderlyingFramework(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_PROFILE_UNDERLYING_FRAMEWORK, "false")));
        Object iFilter = FilterUtils.loadFilter(props, prefix + PROP_SELECTED_INSTR_FILTER);
        if (iFilter == null) {
            iFilter = SimpleFilter.NO_FILTER;
        }
        this.setSelectedInstrumentationFilter(iFilter);
        SimpleFilter qFilter = (SimpleFilter)FilterUtils.loadFilter(props, prefix + PROP_QUICK_FILTER);
        if (qFilter == null) {
            qFilter = FilterUtils.QUICK_FILTER;
        }
        this.setQuickFilter(qFilter);
        if (this.getSelectedInstrumentationFilter() == null) {
            this.setSelectedInstrumentationFilter(SimpleFilter.NO_FILTER);
        }
        this.setSamplingInterval(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_SAMPLING_INTERVAL, "10")));
        int instrumentationRootMethodsSize = Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENTATION_ROOT_METHODS_SIZE, "0"));
        for (int i = 0; i < instrumentationRootMethodsSize; ++i) {
            ClientUtils.SourceCodeSelection scs = ClientUtils.stringToSelection((String)ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX + i, null));
            if (scs == null) continue;
            this.instrumentationRootMethods.add(scs);
        }
        int instrumentationMarkerMethodsSize = Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENTATION_MARKER_METHODS_SIZE, "0"));
        for (int i = 0; i < instrumentationMarkerMethodsSize; ++i) {
            ClientUtils.SourceCodeSelection scs = ClientUtils.stringToSelection((String)ProfilingSettings.getProperty(props, prefix + PROP_INSTRUMENTATION_MARKER_METHODS_PREFIX + i, null));
            if (scs == null) continue;
            scs.setMarkerMethod(true);
            this.instrumentationMarkerMethods.add(scs);
        }
        this.setCodeFragmentSelection(ClientUtils.stringToSelection((String)ProfilingSettings.getProperty(props, prefix + PROP_FRAGMENT_SELECTION, "")));
        this.setCodeRegionCPUResBufSize(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_CODE_REGION_CPU_RES_BUF_SIZE, "1000")));
        this.setRunGCOnGetResultsInMemoryProfiling(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_RUN_GC_ON_GET_RESULTS_IN_MEMORY_PROFILING, "true")));
        this.setAllocTrackEvery(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_OBJ_ALLOC_STACK_SAMPLING_INTERVAL, "10")));
        this.setAllocStackTraceLimit(Integer.parseInt(ProfilingSettings.getProperty(props, prefix + PROP_OBJ_ALLOC_STACK_SAMPLING_DEPTH, "-5")));
        this.setUseProfilingPoints(Boolean.valueOf(ProfilingSettings.getProperty(props, prefix + PROP_PROFILING_POINTS_ENABLED, "false")));
    }

    public static void saveRootMethods(ClientUtils.SourceCodeSelection[] roots, Map props) {
        props.put(PROP_INSTRUMENTATION_ROOT_METHODS_SIZE, Integer.toString(roots.length));
        for (int i = 0; i < roots.length; ++i) {
            props.put(PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX + i, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)roots[i]));
        }
    }

    public void store(Map props) {
        this.store(props, "");
    }

    public void store(Map props, String prefix) {
        int i;
        props.put(prefix + PROP_IS_PRESET, Boolean.toString(this.isPreset()));
        props.put(prefix + PROP_SETTINGS_NAME, this.getSettingsName());
        props.put(prefix + PROP_PROFILING_TYPE, Integer.toString(this.getProfilingType()));
        props.put(prefix + PROP_OVERRIDE_GLOBAL_SETTINGS, Boolean.toString(this.getOverrideGlobalSettings()));
        props.put(prefix + PROP_WORKING_DIR, this.getWorkingDir());
        props.put(prefix + PROP_JVM_ARGS, this.getJVMArgs());
        if (this.getJavaPlatformName() != null) {
            props.put(prefix + PROP_JAVA_PLATFORM, this.getJavaPlatformName());
        }
        props.put(prefix + PROP_THREADS_MONITORING_ENABLED, Boolean.toString(this.getThreadsMonitoringEnabled()));
        props.put(prefix + PROP_THREADS_SAMPLING_ENABLED, Boolean.toString(this.getThreadsSamplingEnabled()));
        props.put(prefix + PROP_EXCLUDE_WAIT_TIME, Boolean.toString(this.getExcludeWaitTime()));
        props.put(prefix + PROP_CPU_PROFILING_TYPE, Integer.toString(this.getCPUProfilingType()));
        props.put(prefix + PROP_INSTR_SCHEME, Integer.toString(this.getInstrScheme()));
        props.put(prefix + PROP_THREAD_CPU_TIMER_ON, Boolean.toString(this.getThreadCPUTimerOn()));
        props.put(prefix + PROP_INSTRUMENT_GETTER_SETTER_METHODS, Boolean.toString(this.getInstrumentGetterSetterMethods()));
        props.put(prefix + PROP_INSTRUMENT_EMPTY_METHODS, Boolean.toString(this.getInstrumentEmptyMethods()));
        props.put(prefix + PROP_INSTRUMENT_METHOD_INVOKE, Boolean.toString(this.getInstrumentMethodInvoke()));
        props.put(prefix + PROP_INSTRUMENT_SPAWNED_THREADS, Boolean.toString(this.getInstrumentSpawnedThreads()));
        props.put(prefix + PROP_N_PROFILED_THREADS_LIMIT, Integer.toString(this.getNProfiledThreadsLimit()));
        props.put(prefix + PROP_SORT_RESULTS_BY_THREAD_CPU_TIME, Boolean.toString(this.getSortResultsByThreadCPUTime()));
        FilterUtils.storeFilter(props, this.getSelectedInstrumentationFilter(), prefix + PROP_SELECTED_INSTR_FILTER);
        FilterUtils.storeFilter(props, this.getQuickFilter(), prefix + PROP_QUICK_FILTER);
        props.put(prefix + PROP_PROFILE_UNDERLYING_FRAMEWORK, Boolean.toString(this.getProfileUnderlyingFramework()));
        props.put(prefix + PROP_SAMPLING_INTERVAL, Integer.toString(this.getSamplingInterval()));
        props.put(prefix + PROP_INSTRUMENTATION_ROOT_METHODS_SIZE, Integer.toString(this.instrumentationRootMethods.size()));
        for (i = 0; i < this.instrumentationRootMethods.size(); ++i) {
            props.put(prefix + PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX + i, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)((ClientUtils.SourceCodeSelection)this.instrumentationRootMethods.get(i))));
        }
        props.put(prefix + PROP_INSTRUMENTATION_MARKER_METHODS_SIZE, Integer.toString(this.instrumentationMarkerMethods.size()));
        for (i = 0; i < this.instrumentationMarkerMethods.size(); ++i) {
            props.put(prefix + PROP_INSTRUMENTATION_MARKER_METHODS_PREFIX + i, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)((ClientUtils.SourceCodeSelection)this.instrumentationMarkerMethods.get(i))));
        }
        if (this.getCodeFragmentSelection() != null) {
            props.put(prefix + PROP_FRAGMENT_SELECTION, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)this.getCodeFragmentSelection()));
        }
        props.put(prefix + PROP_CODE_REGION_CPU_RES_BUF_SIZE, Integer.toString(this.getCodeRegionCPUResBufSize()));
        props.put(prefix + PROP_RUN_GC_ON_GET_RESULTS_IN_MEMORY_PROFILING, Boolean.toString(this.getRunGCOnGetResultsInMemoryProfiling()));
        props.put(prefix + PROP_OBJ_ALLOC_STACK_SAMPLING_INTERVAL, Integer.toString(this.getAllocTrackEvery()));
        props.put(prefix + PROP_OBJ_ALLOC_STACK_SAMPLING_DEPTH, Integer.toString(this.getAllocStackTraceLimit()));
        props.put(prefix + PROP_PROFILING_POINTS_ENABLED, Boolean.toString(this.useProfilingPoints()));
    }

    public String toString() {
        return this.getSettingsName();
    }

    public boolean useProfilingPoints() {
        return this.useProfilingPoints;
    }

    static String getProperty(Map props, Object key, String defaultValue) {
        Object ret = props.get(key);
        return ret != null ? (String)ret : defaultValue;
    }
}

