/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.javadoc.Comment;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.CollationKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocImpl
implements Doc,
Comparable<Object> {
    protected final DocEnv env;
    private Comment comment;
    private CollationKey collationkey = null;
    protected String documentation;
    private Tag[] firstSentence;
    private Tag[] inlineTags;

    DocImpl(DocEnv env, String documentation) {
        this.documentation = documentation;
        this.env = env;
    }

    protected String documentation() {
        if (this.documentation == null) {
            this.documentation = "";
        }
        return this.documentation;
    }

    Comment comment() {
        if (this.comment == null) {
            this.comment = new Comment(this, this.documentation());
        }
        return this.comment;
    }

    public String commentText() {
        return this.comment().commentText();
    }

    public Tag[] tags() {
        return this.comment().tags();
    }

    public Tag[] tags(String tagname) {
        return this.comment().tags(tagname);
    }

    public SeeTag[] seeTags() {
        return this.comment().seeTags();
    }

    public Tag[] inlineTags() {
        if (this.inlineTags == null) {
            this.inlineTags = Comment.getInlineTags(this, this.commentText());
        }
        return this.inlineTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] firstSentenceTags() {
        if (this.firstSentence == null) {
            this.inlineTags();
            try {
                this.env.setSilent(true);
                this.firstSentence = Comment.firstSentenceTags(this, this.commentText());
                Object var2_1 = null;
                this.env.setSilent(false);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.env.setSilent(false);
                throw throwable;
            }
        }
        return this.firstSentence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readHTMLDocumentation(InputStream input, FileObject filename) throws IOException {
        byte[] filecontents = new byte[input.available()];
        try {
            DataInputStream dataIn = new DataInputStream(input);
            dataIn.readFully(filecontents);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
        String encoding = this.env.getEncoding();
        String rawDoc = encoding != null ? new String(filecontents, encoding) : new String(filecontents);
        Pattern bodyPat = Pattern.compile("(?is).*<body\\b[^>]*>(.*)</body\\b.*");
        Matcher m = bodyPat.matcher(rawDoc);
        if (m.matches()) {
            return m.group(1);
        }
        String key = rawDoc.matches("(?is).*<body\\b.*") ? "javadoc.End_body_missing_from_html_file" : "javadoc.Body_missing_from_html_file";
        this.env.error(SourcePositionImpl.make(filename, -1, null), key);
        return "";
    }

    public String getRawCommentText() {
        return this.documentation();
    }

    public void setRawCommentText(String rawDocumentation) {
        this.documentation = rawDocumentation;
        this.comment = null;
    }

    CollationKey key() {
        if (this.collationkey == null) {
            this.collationkey = this.generateKey();
        }
        return this.collationkey;
    }

    CollationKey generateKey() {
        String k = this.name();
        return this.env.doclocale.collator.getCollationKey(k);
    }

    public String toString() {
        return this.qualifiedName();
    }

    public abstract String name();

    public abstract String qualifiedName();

    @Override
    public int compareTo(Object obj) {
        return this.key().compareTo(((DocImpl)obj).key());
    }

    public boolean isField() {
        return false;
    }

    public boolean isEnumConstant() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isAnnotationTypeElement() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isException() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isOrdinaryClass() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isIncluded();

    public SourcePosition position() {
        return null;
    }
}

