/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class IntToStringCache {
    private final List<CharSequence> cache;
    private final int version;
    private final long timestamp;
    private final Object oneItemCacheLock = new Lock();
    private CharSequence oneItemCacheString;
    private int oneItemCacheInt;

    public IntToStringCache() {
        this(System.currentTimeMillis());
    }

    public IntToStringCache(long timestamp) {
        this.cache = new ArrayList<CharSequence>();
        this.version = RepositoryTranslatorImpl.getVersion();
        this.timestamp = timestamp;
    }

    public IntToStringCache(DataInput stream) throws IOException {
        assert (stream != null);
        this.cache = new ArrayList<CharSequence>();
        this.version = stream.readInt();
        this.timestamp = stream.readLong();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            String value = stream.readUTF();
            CharSequence v = value.equals("") ? null : FilePathCache.getManager().getString((CharSequence)value);
            this.cache.add(v);
        }
    }

    public void write(DataOutput stream) throws IOException {
        assert (this.cache != null);
        assert (stream != null);
        stream.writeInt(this.version);
        stream.writeLong(this.timestamp);
        int size = this.cache.size();
        stream.writeInt(size);
        for (int i = 0; i < size; ++i) {
            CharSequence value = this.cache.get(i);
            if (value == null) {
                stream.writeUTF("");
                continue;
            }
            stream.writeUTF(((Object)value).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(CharSequence value) {
        Object object;
        CharSequence prevString = null;
        int prevInt = 0;
        Object object2 = this.oneItemCacheLock;
        synchronized (object2) {
            prevString = this.oneItemCacheString;
            prevInt = this.oneItemCacheInt;
        }
        if (value.equals(prevString)) {
            return prevInt;
        }
        int id = this.cache.indexOf(value);
        if (id == -1) {
            object = this.cache;
            synchronized (object) {
                id = this.cache.indexOf(value);
                if (id == -1) {
                    id = this.makeId(value);
                }
            }
        }
        object = this.oneItemCacheLock;
        synchronized (object) {
            this.oneItemCacheString = value;
            this.oneItemCacheInt = id;
        }
        return id;
    }

    private int makeId(CharSequence value) {
        this.cache.add(value);
        return this.cache.indexOf(value);
    }

    public CharSequence getValueById(int id) {
        return this.cache.get(id);
    }

    public boolean containsId(int id) {
        return 0 <= id && id < this.cache.size();
    }

    public int size() {
        return this.cache.size();
    }

    public int getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

