/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceConfigurator;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CPVendor;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.setFocus;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class CPVendorPanel
extends JPanel
implements ChangeListener,
DocumentListener,
ListDataListener,
WizardConstants {
    static final long serialVersionUID = 93474632245456421L;
    private ArrayList dbconns;
    private ResourceConfigHelper helper;
    private FieldGroup generalGroup;
    private FieldGroup propGroup;
    private FieldGroup vendorGroup;
    private boolean useExistingConnection = true;
    private String[] vendors;
    private boolean firstTime = true;
    private boolean setupValid = true;
    private static final String CONST_TRUE = "true";
    public ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Bundle");
    private final List listeners = new ArrayList();
    protected final CPVendor panel;
    private JTextArea descriptionTextArea;
    private JComboBox existingConnComboBox;
    private JRadioButton existingConnRadioButton;
    private JCheckBox isXA;
    private JPanel jPanel1;
    private JComboBox nameComboBox;
    private JTextField nameField;
    private JLabel nameLabel;
    private JRadioButton newCofigRadioButton;

    public CPVendorPanel(CPVendor panel, ResourceConfigHelper helper, Wizard wiardInfo) {
        int i;
        this.panel = panel;
        this.helper = helper;
        this.generalGroup = FieldGroupHelper.getFieldGroup(wiardInfo, "general");
        this.propGroup = FieldGroupHelper.getFieldGroup(wiardInfo, "properties");
        this.vendorGroup = FieldGroupHelper.getFieldGroup(wiardInfo, "propertiesUrl");
        ButtonGroup bg = new ButtonGroup();
        this.dbconns = new ArrayList();
        this.setName(this.bundle.getString("TITLE_ConnPoolWizardPanel_dbConn"));
        this.initComponents();
        this.nameLabel.setLabelFor(this.nameField);
        this.nameComboBox.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPVendorPanel.this.nameComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        bg.add(this.existingConnRadioButton);
        bg.add(this.newCofigRadioButton);
        bg.getSelection().addChangeListener(this);
        try {
            DatabaseConnection[] cons = ConnectionManager.getDefault().getConnections();
            for (i = 0; i < cons.length; ++i) {
                this.existingConnComboBox.addItem(cons[i].getName());
                this.dbconns.add(cons[i]);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.existingConnComboBox.getItemCount() == 0) {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("NoConnection"), 0);
            this.newCofigRadioButton.setSelected(true);
            this.newCofigRadioButton.setEnabled(true);
            this.nameComboBox.setEnabled(true);
            this.existingConnComboBox.setEnabled(false);
        } else {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
            this.existingConnRadioButton.setSelected(true);
            this.existingConnRadioButton.setEnabled(true);
            this.existingConnComboBox.setEnabled(true);
            this.nameComboBox.setEnabled(false);
            this.setExistingConnData();
        }
        Field vendorField = FieldHelper.getField(this.generalGroup, "database-vendor");
        this.vendors = FieldHelper.getTags(vendorField);
        for (i = 0; i < this.vendors.length; ++i) {
            this.nameComboBox.addItem(this.bundle.getString("DBVendor_" + this.vendors[i]));
        }
        if (this.nameComboBox.getItemCount() == 0) {
            this.nameComboBox.insertItemAt(this.bundle.getString("NoTemplate"), 0);
        } else {
            this.nameComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
        }
        this.nameComboBox.setSelectedIndex(0);
        this.existingConnComboBox.getModel().addListDataListener(this);
        this.nameComboBox.getModel().addListDataListener(this);
        this.isXA.setSelected(helper.getData().getString("isXA").equals(CONST_TRUE));
        this.isXA.addChangeListener(this);
        this.newCofigRadioButton.addChangeListener(this);
        this.firstTime = false;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.descriptionTextArea = new JTextArea();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.existingConnRadioButton = new JRadioButton();
        this.existingConnComboBox = new JComboBox();
        this.newCofigRadioButton = new JRadioButton();
        this.nameComboBox = new JComboBox();
        this.isXA = new JCheckBox();
        this.setMaximumSize(new Dimension(600, 350));
        this.setMinimumSize(new Dimension(600, 350));
        this.setPreferredSize(new Dimension(600, 350));
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(5);
        this.descriptionTextArea.setText(NbBundle.getMessage(CPVendorPanel.class, (String)"Description"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setFocusable(false);
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setRequestFocusEnabled(false);
        this.descriptionTextArea.setVerifyInputWhenFocusTarget(false);
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"LBL_pool-name"));
        this.nameField.setText(this.helper.getData().getString("name"));
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CPVendorPanel.this.nameFieldKeyReleased(evt);
            }
        });
        this.existingConnRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.existingConnRadioButton, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"ExistingConnection"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.existingConnComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.newCofigRadioButton, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"NewConfiguration"));
        this.nameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.nameComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.isXA, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"isXA"));
        this.isXA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.isXAActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.existingConnComboBox, 0, 535, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isXA).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.nameComboBox, 0, 532, Short.MAX_VALUE)).addComponent(this.newCofigRadioButton).addComponent(this.existingConnRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.nameLabel).addGap(10, 10, 10).addComponent(this.nameField, -1, 356, Short.MAX_VALUE))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTextArea).addGap(9, 9, 9)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.descriptionTextArea, -1, 64, Short.MAX_VALUE).addGap(17, 17, 17).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameField, -2, -1, -2).addComponent(this.nameLabel)).addGap(18, 18, 18).addComponent(this.existingConnRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.existingConnComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.newCofigRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nameComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.isXA).addGap(67, 67, 67)));
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_DescriptionA11yDesc"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_pool-nameA11yDesc"));
        this.existingConnRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_ExistingConnectionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_ExistingConnectionComboBoxA11yName"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_ExistingConnectionComboBoxA11yDesc"));
        this.newCofigRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_NewConnectionA11yDesc"));
        this.nameComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_NewConnectionComboBoxA11yName"));
        this.nameComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_NewConnectionComboBoxA11yDesc"));
        this.isXA.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_isXA_A11yDesc"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(11, 11, 11)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"TITLE_ConnPoolWizardPanel_dbConn"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"TITLE_ConnPoolWizardPanel_dbConn"));
    }

    private void nameFieldKeyReleased(KeyEvent evt) {
        String newValue;
        ResourceConfigData data = this.helper.getData();
        String value = data.getString("name");
        if (!value.equals(newValue = this.nameField.getText())) {
            this.helper.getData().setString("name", newValue);
        }
        this.fireChange();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.setResourceName();
    }

    public String getNameField() {
        return this.nameField.getText();
    }

    private void setResourceName() {
        String newValue;
        ResourceConfigData data = this.helper.getData();
        String value = data.getString("name");
        if (!value.equals(newValue = this.nameField.getText())) {
            this.helper.getData().setString("name", newValue);
            this.fireChange();
        }
        if (this.getRootPane().getDefaultButton() != null && this.getRootPane().getDefaultButton().isEnabled()) {
            this.getRootPane().getDefaultButton().doClick();
        }
    }

    private void isXAActionPerformed(ActionEvent evt) {
        this.setNewConfigData(false);
    }

    private void nameComboBoxActionPerformed(ActionEvent evt) {
        this.setNewConfigData(true);
    }

    private void setNewConfigData(boolean replaceProps) {
        if (this.firstTime) {
            return;
        }
        int index = this.nameComboBox.getSelectedIndex();
        if (index > 0) {
            if (this.useExistingConnection) {
                this.useExistingConnection = false;
            }
            ResourceConfigData data = this.helper.getData();
            data.setString("is-cp-existing", "false");
            String vendorName = this.vendors[index - 1];
            String savedVendorName = data.getString("database-vendor");
            String savedXA = data.getString("isXA");
            String XA = this.isXA.isSelected() ? CONST_TRUE : "false";
            boolean vendorNotChanged = vendorName.equals(savedVendorName);
            boolean isXANotChanged = XA.equals(savedXA);
            if (vendorNotChanged && isXANotChanged) {
                return;
            }
            if (!vendorNotChanged) {
                data.setString("database-vendor", vendorName);
            }
            if (!isXANotChanged) {
                data.setString("isXA", XA);
            }
            this.setDataSourceClassNameAndResTypeInData(vendorName);
            if (replaceProps) {
                this.setPropertiesInData(vendorName);
            }
        }
    }

    private void setDataSourceClassNameAndResTypeInData(String vendorName) {
        ResourceConfigData data = this.helper.getData();
        Field dsField = this.isXA.isSelected() ? FieldHelper.getField(this.generalGroup, "datasource-classname-xa") : FieldHelper.getField(this.generalGroup, "datasource-classname");
        data.setString("datasource-classname", FieldHelper.getConditionalFieldValue(dsField, vendorName));
        if (this.isXA.isSelected()) {
            data.setString("res-type", "javax.sql.XADataSource");
            data.setString("isXA", CONST_TRUE);
        } else {
            data.setString("res-type", "javax.sql.DataSource");
            data.setString("isXA", "false");
        }
    }

    private void setPropertiesInData(String vendorName) {
        ResourceConfigData data = this.helper.getData();
        data.setProperties(new Vector());
        Field[] propFields = this.propGroup.getField();
        for (int i = 0; i < propFields.length; ++i) {
            String value = FieldHelper.getConditionalFieldValue(propFields[i], vendorName);
            String name = propFields[i].getName();
            if (name.equals("URL") && value.length() > 0) {
                data.addProperty(name, FieldHelper.toUrl(value));
                continue;
            }
            if (name.equals("databaseName") && value.length() > 0) {
                data.addProperty(name, FieldHelper.toUrl(value));
                continue;
            }
            if (name.equals("User") || name.equals("Password")) {
                data.addProperty(propFields[i].getName(), value);
                continue;
            }
            if (value.length() <= 0 || !value.equals("NA")) continue;
            data.addProperty(propFields[i].getName(), "");
        }
    }

    private void existingConnComboBoxActionPerformed(ActionEvent evt) {
        this.setExistingConnData();
    }

    public void setExistingConnData() {
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            if (!this.useExistingConnection) {
                this.helper.getData().setResourceName("jdbc-connection-pool");
                this.useExistingConnection = true;
            }
            this.helper.getData().setString("is-cp-existing", CONST_TRUE);
            DatabaseConnection dbconn = (DatabaseConnection)this.dbconns.get(this.existingConnComboBox.getSelectedIndex() - 1);
            String url = dbconn.getDatabaseURL();
            String user = dbconn.getUser();
            String password = dbconn.getPassword();
            if (user != null && (password == null || password.trim().length() == 0)) {
                password = "()";
            }
            String tmpStr = url;
            Field urlField = FieldHelper.getField(this.vendorGroup, "vendorUrls");
            String vendorName = FieldHelper.getOptionNameFromValue(urlField, tmpStr);
            ResourceConfigData data = this.helper.getData();
            data.setProperties(new Vector());
            data.setString("database-vendor", vendorName);
            if (vendorName.equals("pointbase")) {
                data.addProperty("databaseName", dbconn.getDatabaseURL());
            } else if (vendorName.startsWith("derby")) {
                this.setDerbyProps(vendorName, url);
            } else {
                data.addProperty("URL", url);
            }
            data.addProperty("User", user);
            data.addProperty("Password", password);
            this.setDataSourceClassNameAndResTypeInData(vendorName);
        }
    }

    private void setDerbyProps(String vendorName, String url) {
        ResourceConfigData data = this.helper.getData();
        data.setProperties(new Vector());
        data.addProperty("URL", url);
        Field[] propFields = this.propGroup.getField();
        for (int i = 0; i < propFields.length; ++i) {
            String value = FieldHelper.getConditionalFieldValue(propFields[i], vendorName);
            if (!value.equals("NA")) continue;
            String name = propFields[i].getName();
            if (!vendorName.equals("derby_net")) continue;
            String hostName = "";
            String portNumber = "";
            String databaseName = "";
            try {
                String workingUrl = url.substring(url.indexOf("//") + 2, url.length());
                ResourceConfigurator rci = new ResourceConfigurator();
                hostName = rci.getDerbyServerName(workingUrl);
                portNumber = rci.getDerbyPortNo(workingUrl);
                databaseName = rci.getDerbyDatabaseName(workingUrl);
            }
            catch (StringIndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (name.equals("PortNumber")) {
                data.addProperty(name, portNumber);
                continue;
            }
            if (name.equals("DatabaseName")) {
                data.addProperty(name, databaseName);
                continue;
            }
            if (!name.equals("serverName")) continue;
            data.addProperty(name, hostName);
        }
    }

    public boolean hasValidData() {
        if (!this.setupValid) {
            this.panel.setErrorMsg(this.bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.panel.setErrorMsg(this.bundle.getString("Empty_String"));
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            this.panel.setErrorMsg(this.bundle.getString("Err_InvalidName"));
            return false;
        }
        if (!ResourceUtils.isLegalResourceName(name)) {
            this.panel.setErrorMsg(this.bundle.getString("Err_InvalidName"));
            return false;
        }
        if (!ResourceUtils.isUniqueFileName(name, this.helper.getData().getTargetFileObject(), "connectionPool")) {
            this.panel.setErrorMsg(this.bundle.getString("Err_DuplFileName"));
            return false;
        }
        if (this.existingConnRadioButton.isSelected()) {
            if (this.existingConnComboBox.getSelectedIndex() > 0) {
                return true;
            }
            this.panel.setErrorMsg(this.bundle.getString("Err_ChooseDBConn"));
        } else if (this.newCofigRadioButton.isSelected()) {
            if (this.nameComboBox.getSelectedIndex() > 0) {
                return true;
            }
            this.panel.setErrorMsg(this.bundle.getString("Err_ChooseDBVendor"));
        }
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.fireChange();
    }

    @Override
    public void intervalAdded(ListDataEvent p1) {
        this.fireChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent p1) {
        this.fireChange();
    }

    @Override
    public void contentsChanged(ListDataEvent p1) {
        this.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent p1) {
        if (this.firstTime) {
            return;
        }
        if (p1.getSource().getClass() == JToggleButton.ToggleButtonModel.class) {
            if (this.existingConnRadioButton.isSelected()) {
                if (this.firstTime) {
                    return;
                }
                this.existingConnComboBox.setEnabled(true);
                this.nameComboBox.setEnabled(false);
                this.setExistingConnData();
            } else {
                this.existingConnComboBox.setEnabled(false);
                this.nameComboBox.setEnabled(true);
                this.setNewConfigData(true);
            }
        }
        this.fireChange();
    }

    public CPVendorPanel setFirstTime(boolean first) {
        this.firstTime = first;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList tempList;
        ChangeEvent event = new ChangeEvent(this);
        List list = this.listeners;
        synchronized (list) {
            tempList = new ArrayList(this.listeners);
        }
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public void read(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        String targetName = wizard.getTargetName();
        if (this.helper.getData().getString("dynamicPanel").equals(CONST_TRUE)) {
            targetName = null;
        }
        FileObject setupFolder = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
        this.helper.getData().setTargetFileObject(setupFolder);
        if (setupFolder != null) {
            String resourceName = this.helper.getData().getString("name");
            if (resourceName != null && !resourceName.equals("")) {
                targetName = resourceName;
            }
            targetName = ResourceUtils.createUniqueFileName(targetName, setupFolder, "connectionPool");
            this.helper.getData().setTargetFile(targetName);
            this.nameField.setText(targetName);
            this.helper.getData().setString("name", targetName);
        } else {
            this.setupValid = false;
        }
    }

    public void setInitialFocus() {
        new setFocus(this.nameField);
    }
}

